/*
 * Decompiled with CFR 0.152.
 */
package net.rom.exoplanets.content.item;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.oredict.OreDictionary;
import net.rom.exoplanets.content.IMetal;
import net.rom.exoplanets.content.item.ItemBaseExo;
import net.rom.exoplanets.internal.inerf.IAddRecipe;
import net.rom.exoplanets.internal.inerf.ICustomModel;
import net.rom.exoplanets.util.CreativeExoTabs;

public abstract class ItemBaseMetal
extends ItemBaseExo
implements IAddRecipe,
ICustomModel {
    String modelName;
    String oreDictPrefix;

    ItemBaseMetal(String modelName, String oreDictPrefix) {
        this.modelName = modelName;
        this.oreDictPrefix = oreDictPrefix;
        this.func_77627_a(true);
        this.func_77637_a(CreativeExoTabs.ITEMS_CREATIVE_TABS);
    }

    public abstract List<IMetal> getMetals(Item var1);

    @Override
    public List<ItemStack> getSubItems(Item item) {
        ArrayList list = Lists.newArrayList();
        for (IMetal metal : this.getMetals(item)) {
            list.add(new ItemStack(item, 1, metal.getMeta()));
        }
        return list;
    }

    @Override
    public void registerModels() {
        String prefix = "exoplanets:" + this.modelName;
        for (IMetal metal : this.getMetals(this)) {
            ModelResourceLocation model = new ModelResourceLocation(prefix + metal.func_176610_l(), "inventory");
            ModelLoader.setCustomModelResourceLocation((Item)this, (int)metal.getMeta(), (ModelResourceLocation)model);
        }
    }

    @Override
    public void addOreDict() {
        for (IMetal metal : this.getMetals(this)) {
            ItemStack stack = new ItemStack((Item)this, 1, metal.getMeta());
            String name = this.oreDictPrefix + metal.getMetalName();
            OreDictionary.registerOre((String)name, (ItemStack)stack);
        }
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77667_c(stack) + stack.func_77952_i();
    }
}

