/*
 * Decompiled with CFR 0.152.
 */
package net.rom.exoplanets.content.entity;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.entity.IRocketType;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntityAutoRocket;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntitySpaceshipBase;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntityTieredRocket;
import micdoodle8.mods.galacticraft.api.tile.IFuelDock;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3Dim;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.IExitHeight;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.advancement.GCTriggers;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.network.IPacket;
import micdoodle8.mods.galacticraft.core.network.PacketDynamic;
import micdoodle8.mods.galacticraft.core.tile.TileEntityLandingPad;
import micdoodle8.mods.galacticraft.core.tile.TileEntityTelemetry;
import micdoodle8.mods.galacticraft.core.util.CompatibilityManager;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.GCLog;
import micdoodle8.mods.galacticraft.core.util.RedstoneUtil;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.rom.exoplanets.init.ExoItems;

public class EntityTwoPlayerRocket
extends EntityTieredRocket {
    public EntityTwoPlayerRocket(World par1World) {
        super(par1World);
        this.func_70105_a(1.2f, 6.5f);
    }

    public EntityTwoPlayerRocket(World world, double posX, double posY, double posZ) {
        super(world, posX, posY, posZ);
        this.func_70105_a(1.2f, 6.5f);
    }

    public EntityTwoPlayerRocket(World par1World, double par2, double par4, double par6, IRocketType.EnumRocketType rocketType) {
        super(par1World, par2, par4, par6);
        this.rocketType = rocketType;
        this.func_70105_a(1.2f, 6.5f);
        this.stacks = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
    }

    public EntityTwoPlayerRocket(World par1World, double par2, double par4, double par6, boolean reversed, IRocketType.EnumRocketType rocketType, NonNullList<ItemStack> inv) {
        this(par1World, par2, par4, par6, rocketType);
        this.stacks = inv;
    }

    protected void func_184200_o(Entity p_addPassenger_1_) {
        super.func_184200_o(p_addPassenger_1_);
    }

    protected boolean func_184219_q(Entity p_canFitPassenger_1_) {
        return this.func_184188_bt().size() <= 1;
    }

    public double func_70033_W() {
        return 1.5;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack(ExoItems.passengerRocket, 1, this.rocketType.getIndex());
    }

    protected void func_70088_a() {
        super.func_70088_a();
    }

    public double func_70042_X() {
        return 0.75;
    }

    public float getRotateOffset() {
        return 2.25f;
    }

    public double getOnPadYOffset() {
        return 0.0;
    }

    public void func_70071_h_() {
        AxisAlignedBB box;
        List var15;
        if (this.field_70170_p.field_72995_K && this.field_70175_ag && !CompatibilityManager.isCubicChunksLoaded) {
            Chunk chunk = this.field_70170_p.func_72964_e(this.field_70176_ah, this.field_70164_aj);
            int cx = MathHelper.func_76128_c((double)this.field_70165_t) >> 4;
            int cz = MathHelper.func_76128_c((double)this.field_70161_v) >> 4;
            if (chunk.func_177410_o() && this.field_70176_ah == cx && this.field_70164_aj == cz) {
                boolean thisfound = false;
                ClassInheritanceMultiMap mapEntities = chunk.func_177429_s()[this.field_70162_ai];
                for (Entity ent : mapEntities) {
                    if (ent != this) continue;
                    thisfound = true;
                    break;
                }
                if (!thisfound) {
                    chunk.func_76612_a((Entity)this);
                }
            }
        }
        if (this.launchPhase == EntitySpaceshipBase.EnumLaunchPhase.LANDING.ordinal() && this.hasValidFuel() && this.targetVec != null) {
            double yDiff = this.field_70163_u - this.getOnPadYOffset() - (double)this.targetVec.func_177956_o();
            this.field_70181_x = Math.max(-2.0, (yDiff - 0.04) / -55.0);
            double diff = this.field_70165_t - (double)this.targetVec.func_177958_n() - 0.5;
            double motX = diff > 0.0 ? Math.max(-0.1, diff / -100.0) : (diff < 0.0 ? Math.min(0.1, diff / -100.0) : 0.0);
            diff = this.field_70161_v - (double)this.targetVec.func_177952_p() - 0.5;
            double motZ = diff > 0.0 ? Math.max(-0.1, diff / -100.0) : (diff < 0.0 ? Math.min(0.1, diff / -100.0) : 0.0);
            if (motZ != 0.0 || motX != 0.0) {
                double angleYaw = Math.atan(motZ / motX);
                double signed = motX < 0.0 ? 50.0 : -50.0;
                double anglePitch = Math.atan(Math.sqrt(motZ * motZ + motX * motX) / signed) * 100.0;
                this.field_70177_z = (float)angleYaw * 57.295776f;
                this.field_70125_A = (float)anglePitch * 57.295776f;
            } else {
                this.field_70125_A = 0.0f;
            }
            if (yDiff > 1.0 && yDiff < 4.0) {
                for (Object o : this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_72317_d(0.0, -3.0, 0.0), EntitySpaceshipBase.rocketSelector)) {
                    if (!(o instanceof EntitySpaceshipBase)) continue;
                    ((EntitySpaceshipBase)o).dropShipAsItem();
                    ((EntitySpaceshipBase)o).func_70106_y();
                }
            }
            if (yDiff < 0.4) {
                int yMin = MathHelper.func_76128_c((double)(this.func_174813_aQ().field_72338_b - this.getOnPadYOffset() - 0.45)) - 2;
                int yMax = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72337_e) + 1;
                int zMin = MathHelper.func_76128_c((double)this.field_70161_v) - 1;
                int zMax = MathHelper.func_76128_c((double)this.field_70161_v) + 1;
                for (int x = MathHelper.func_76128_c((double)this.field_70165_t) - 1; x <= MathHelper.func_76128_c((double)this.field_70165_t) + 1; ++x) {
                    for (int z = zMin; z <= zMax; ++z) {
                        for (int y = yMin; y <= yMax; ++y) {
                            if (!(this.field_70170_p.func_175625_s(new BlockPos(x, y, z)) instanceof IFuelDock)) continue;
                            this.field_70125_A = 0.0f;
                            this.failRocket();
                        }
                    }
                }
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            this.func_70052_a(6, this.func_184202_aL());
        }
        this.func_70030_z();
        ++this.ticks;
        super.func_70071_h_();
        if (this.getAddToTelemetry()) {
            this.setAddTotele(false);
            for (BlockVec3Dim vec : new ArrayList<BlockVec3Dim>(this.getTeleList())) {
                TileEntity t1 = vec.getTileEntityNoLoad();
                if (!(t1 instanceof TileEntityTelemetry) || t1.func_145837_r() || ((TileEntityTelemetry)t1).linkedEntity != this) continue;
                ((TileEntityTelemetry)t1).addTrackedEntity((Entity)this);
            }
        }
        for (Entity e : this.func_184188_bt()) {
            e.field_70143_R = 0.0f;
        }
        double d = this.field_70170_p.field_73011_w instanceof IExitHeight ? ((IExitHeight)this.field_70170_p.field_73011_w).getYCoordinateToTeleport() : 1200.0;
        if (this.field_70163_u > d && this.launchPhase != EntitySpaceshipBase.EnumLaunchPhase.LANDING.ordinal()) {
            this.onReachAtmosphere();
        }
        if (this.rollAmplitude > 0.0f) {
            this.rollAmplitude -= 1.0f;
        }
        if (this.shipDamage > 0.0f) {
            this.shipDamage -= 1.0f;
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70163_u < 0.0) {
                this.func_70106_y();
            } else {
                double d2 = this.field_70170_p.field_73011_w instanceof IExitHeight ? ((IExitHeight)this.field_70170_p.field_73011_w).getYCoordinateToTeleport() : 1200.0;
                int n = this.launchPhase == EntitySpaceshipBase.EnumLaunchPhase.LANDING.ordinal() ? 355 : 100;
                if (this.field_70163_u > d2 + (double)n) {
                    boolean allGood = true;
                    for (Entity e : this.func_184188_bt()) {
                        if (!(e instanceof EntityPlayerMP)) continue;
                        allGood = false;
                        break;
                    }
                    if (!allGood) {
                        allGood = true;
                        for (Entity e : this.func_184188_bt()) {
                            if (!(e instanceof EntityPlayerMP)) continue;
                            GCPlayerStats stats = GCPlayerStats.get((Entity)e);
                            if (stats.isUsingPlanetSelectionGui()) {
                                this.func_70106_y();
                                continue;
                            }
                            allGood = false;
                        }
                        if (allGood) {
                            this.func_70106_y();
                        }
                    } else {
                        this.func_70106_y();
                    }
                }
            }
            if (this.timeSinceLaunch > 50.0f && this.field_70122_E) {
                this.failRocket();
            }
        }
        if (this.launchPhase == EntitySpaceshipBase.EnumLaunchPhase.UNIGNITED.ordinal()) {
            this.timeUntilLaunch = this.getPreLaunchWait();
        }
        this.timeSinceLaunch = this.launchPhase >= EntitySpaceshipBase.EnumLaunchPhase.LAUNCHED.ordinal() ? (this.timeSinceLaunch += 1.0f) : 0.0f;
        if (this.timeUntilLaunch > 0 && this.launchPhase == EntitySpaceshipBase.EnumLaunchPhase.IGNITED.ordinal()) {
            --this.timeUntilLaunch;
        }
        if (!(var15 = this.field_70170_p.func_72839_b((Entity)this, box = this.func_174813_aQ().func_186662_g(0.2))).isEmpty()) {
            for (Entity o : var15) {
                if (!this.func_184188_bt().contains(o)) continue;
                o.func_70108_f((Entity)this);
            }
        }
        if (this.timeUntilLaunch == 0 && this.launchPhase == EntitySpaceshipBase.EnumLaunchPhase.IGNITED.ordinal()) {
            this.setLaunchPhase(EntitySpaceshipBase.EnumLaunchPhase.LAUNCHED);
            this.onLaunch();
        }
        if (this.field_70125_A > 90.0f) {
            this.field_70125_A = 90.0f;
        }
        if (this.field_70125_A < -90.0f) {
            this.field_70125_A = -90.0f;
        }
        this.field_70159_w = -(50.0 * Math.cos((double)this.field_70177_z / 57.29577951308232) * Math.sin((double)this.field_70125_A * 0.01 / 57.29577951308232));
        this.field_70179_y = -(50.0 * Math.sin((double)this.field_70177_z / 57.29577951308232) * Math.sin((double)this.field_70125_A * 0.01 / 57.29577951308232));
        if (this.launchPhase < EntitySpaceshipBase.EnumLaunchPhase.LAUNCHED.ordinal()) {
            this.field_70179_y = 0.0;
            this.field_70181_x = 0.0;
            this.field_70159_w = 0.0;
        }
        if (this.field_70170_p.field_72995_K) {
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            if (this.shouldMoveClientSide()) {
                this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            }
        } else {
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        }
        this.func_70101_b(this.field_70177_z, this.field_70125_A);
        if (this.field_70170_p.field_72995_K) {
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        if (!this.field_70170_p.field_72995_K && this.ticks % 3L == 0L) {
            GalacticraftCore.packetPipeline.sendToDimension((IPacket)new PacketDynamic((Entity)this), this.field_70170_p.field_73011_w.getDimension());
        }
        if (this.launchPhase >= EntitySpaceshipBase.EnumLaunchPhase.LAUNCHED.ordinal() && this.func_184188_bt().size() >= 2) {
            for (Entity entity : this.func_184188_bt()) {
                if (!(entity instanceof EntityPlayerMP)) continue;
                GCTriggers.LAUNCH_ROCKET.trigger((EntityPlayerMP)this.func_184188_bt().get(0));
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.statusMessageCooldown > 0) {
                --this.statusMessageCooldown;
            }
            if (this.statusMessageCooldown == 0 && this.lastStatusMessageCooldown > 0 && this.statusValid) {
                this.autoLaunch_r();
            }
            if (this.autoLaunchCountdown > 0 && !this.func_184188_bt().isEmpty() && --this.autoLaunchCountdown <= 0) {
                this.autoLaunch_r();
            }
            if (this.autoLaunchSetting == EntityAutoRocket.EnumAutoLaunch.ROCKET_IS_FUELED && this.fuelTank.getFluidAmount() == this.fuelTank.getCapacity() && !this.func_184188_bt().isEmpty()) {
                this.autoLaunch_r();
            }
            if (this.autoLaunchSetting == EntityAutoRocket.EnumAutoLaunch.INSTANT && this.autoLaunchCountdown == 0 && !this.func_184188_bt().isEmpty()) {
                this.autoLaunch_r();
            }
            if (this.autoLaunchSetting == EntityAutoRocket.EnumAutoLaunch.REDSTONE_SIGNAL && this.ticks % 11L == 0L && this.getActiveLaunchController() != null && RedstoneUtil.isBlockReceivingRedstone((World)this.field_70170_p, (BlockPos)this.getActiveLaunchController().toBlockPos())) {
                this.autoLaunch_r();
            }
            if (this.launchPhase >= EntitySpaceshipBase.EnumLaunchPhase.LAUNCHED.ordinal()) {
                this.setPad(null);
            } else if (this.launchPhase == EntitySpaceshipBase.EnumLaunchPhase.UNIGNITED.ordinal() && this.getLandingPad() != null && this.ticks % 17L == 0L) {
                this.updateControllerSettings(this.getLandingPad());
            }
            this.lastStatusMessageCooldown = this.statusMessageCooldown;
        }
        if (this.launchPhase >= EntitySpaceshipBase.EnumLaunchPhase.IGNITED.ordinal()) {
            if (this.rocketSoundUpdater != null) {
                this.rocketSoundUpdater.func_73660_a();
                this.setRocketSoundToStop(true);
            }
        } else if (this.getRocketSoundToStop()) {
            this.stopRocketSound();
            if (this.rocketSoundUpdater != null) {
                FMLClientHandler.instance().getClient().func_147118_V().func_147683_b((ISound)this.rocketSoundUpdater);
            }
            this.rocketSoundUpdater = null;
        }
        int i = this.timeUntilLaunch >= 100 ? Math.abs(this.timeUntilLaunch / 100) : 1;
        if (this.getWaitForPlayer()) {
            if (!this.func_184188_bt().isEmpty()) {
                ArrayList passengers = new ArrayList(this.func_184188_bt());
                for (Entity passenger : passengers) {
                    if (this.ticks >= 40L) {
                        if (!this.field_70170_p.field_72995_K) {
                            this.func_184226_ay();
                            passenger.func_184205_a((Entity)this, true);
                            GCLog.debug((String)"Remounting player in rocket.");
                        }
                        this.setWaitForPlayer(false);
                        this.field_70181_x = -0.5;
                        continue;
                    }
                    this.field_70179_y = 0.0;
                    this.field_70181_x = 0.0;
                    this.field_70159_w = 0.0;
                    passenger.field_70179_y = 0.0;
                    passenger.field_70181_x = 0.0;
                    passenger.field_70159_w = 0.0;
                }
            } else {
                this.field_70179_y = 0.0;
                this.field_70181_x = 0.0;
                this.field_70159_w = 0.0;
            }
        }
        if (this.rumble > 0.0f) {
            this.rumble -= 1.0f;
        } else if (this.rumble < 0.0f) {
            this.rumble += 1.0f;
        }
        double rumbleAmount = (double)this.rumble / (double)(37 - 5 * Math.max(this.getRocketTier(), 5));
        for (Entity passenger : this.func_184188_bt()) {
            passenger.field_70165_t += rumbleAmount;
            passenger.field_70161_v += rumbleAmount;
        }
        if (this.launchPhase >= EntitySpaceshipBase.EnumLaunchPhase.IGNITED.ordinal()) {
            this.func_70057_ab();
            this.rumble = (float)this.field_70146_Z.nextInt(3) - 3.0f;
        }
        if (!this.field_70170_p.field_72995_K) {
            this.lastLastMotionY = this.lastMotionY;
            this.lastMotionY = this.field_70181_x;
        }
        if ((this.getLaunched() || this.launchPhase == EntitySpaceshipBase.EnumLaunchPhase.IGNITED.ordinal() && this.field_70146_Z.nextInt(i) == 0) && !ConfigManagerCore.disableSpaceshipParticles && this.hasValidFuel() && this.field_70170_p.field_72995_K && !this.field_70128_L) {
            double sinPitch = Math.sin((double)this.field_70125_A / 57.29577951308232);
            double x1 = 2.9 * Math.cos((double)this.field_70177_z / 57.29577951308232) * sinPitch;
            double z1 = 2.9 * Math.sin((double)this.field_70177_z / 57.29577951308232) * sinPitch;
            double y1 = 2.9 * Math.cos((double)(this.field_70125_A - 180.0f) / 57.29577951308232);
            if (this.launchPhase == EntitySpaceshipBase.EnumLaunchPhase.LANDING.ordinal() && this.targetVec != null) {
                double y = this.field_70163_u - (double)this.targetVec.func_177956_o();
                y = Math.min(Math.max(y, 80.0), 200.0);
                x1 *= y / 100.0;
                y1 *= y / 100.0;
                z1 *= y / 100.0;
            }
            double y = this.field_70167_r + (this.field_70163_u - this.field_70167_r) + y1 - this.field_70181_x + (!this.getLaunched() ? 2.5 : 1.0);
            double x2 = this.field_70165_t + x1 - this.field_70159_w;
            double z2 = this.field_70161_v + z1 - this.field_70179_y;
            double x3 = x2 + x1 / 2.0;
            double y3 = y + y1 / 2.0;
            double z3 = z2 + z1 / 2.0;
            Vector3 motionVec = new Vector3(x1, y1, z1);
            if (this.field_70173_aa % 2 == 0 && !this.getLaunched()) {
                return;
            }
            String flame = this.getLaunched() ? "launchFlameLaunched" : "launchFlameIdle";
            for (Entity entity : this.func_184188_bt()) {
                if (!(entity instanceof EntityLivingBase)) continue;
                Object[] rider = new Object[]{entity};
                Object[] none = new Object[]{};
                Random random = this.field_70146_Z;
                GalacticraftCore.proxy.spawnParticle(flame, new Vector3(x2 + 0.4 - random.nextDouble() / 10.0, y, z2 + 0.4 - random.nextDouble() / 10.0), motionVec, rider);
                GalacticraftCore.proxy.spawnParticle(flame, new Vector3(x2 - 0.4 + random.nextDouble() / 10.0, y, z2 + 0.4 - random.nextDouble() / 10.0), motionVec, rider);
                GalacticraftCore.proxy.spawnParticle(flame, new Vector3(x2 - 0.4 + random.nextDouble() / 10.0, y, z2 - 0.4 + random.nextDouble() / 10.0), motionVec, rider);
                GalacticraftCore.proxy.spawnParticle(flame, new Vector3(x2 + 0.4 - random.nextDouble() / 10.0, y, z2 - 0.4 + random.nextDouble() / 10.0), motionVec, rider);
                GalacticraftCore.proxy.spawnParticle(flame, new Vector3(x2, y, z2), motionVec, rider);
                GalacticraftCore.proxy.spawnParticle(flame, new Vector3(x2 + 0.4, y, z2), motionVec, rider);
                GalacticraftCore.proxy.spawnParticle(flame, new Vector3(x2 - 0.4, y, z2), motionVec, rider);
                GalacticraftCore.proxy.spawnParticle(flame, new Vector3(x2, y, z2 + 0.4), motionVec, rider);
                GalacticraftCore.proxy.spawnParticle(flame, new Vector3(x2, y, z2 - 0.4), motionVec, rider);
                double a = 8.0;
                double bx = motionVec.x + 2.5 / a;
                double bz = motionVec.z + 2.5 / a;
                GalacticraftCore.proxy.spawnParticle(flame, new Vector3(x3 + 0.2 - random.nextDouble() / 6.0, y3 + 0.4, z3 + 0.2 - random.nextDouble() / 6.0), new Vector3(bx - random.nextDouble() / a, motionVec.y, bz - random.nextDouble() / a), rider);
                GalacticraftCore.proxy.spawnParticle(flame, new Vector3(x3 - 0.2 + random.nextDouble() / 6.0, y3 + 0.4, z3 + 0.2 - random.nextDouble() / 6.0), new Vector3(bx - random.nextDouble() / a, motionVec.y, bz - random.nextDouble() / a), rider);
                GalacticraftCore.proxy.spawnParticle(flame, new Vector3(x3 - 0.2 + random.nextDouble() / 6.0, y3 + 0.4, z3 - 0.2 + random.nextDouble() / 6.0), new Vector3(bx - random.nextDouble() / a, motionVec.y, bz - random.nextDouble() / a), rider);
                GalacticraftCore.proxy.spawnParticle(flame, new Vector3(x3 + 0.2 - random.nextDouble() / 6.0, y3 + 0.4, z3 - 0.2 + random.nextDouble() / 6.0), new Vector3(bx - random.nextDouble() / a, motionVec.y, bz - random.nextDouble() / a), rider);
                GalacticraftCore.proxy.spawnParticle(flame, new Vector3(x3 + 0.2 - random.nextDouble() / 6.0, y3 - 0.4, z3 + 0.2 - random.nextDouble() / 6.0), new Vector3(bx - random.nextDouble() / a, motionVec.y, bz - random.nextDouble() / a), rider);
                GalacticraftCore.proxy.spawnParticle(flame, new Vector3(x3 - 0.2 + random.nextDouble() / 6.0, y3 - 0.4, z3 + 0.2 - random.nextDouble() / 6.0), new Vector3(bx - random.nextDouble() / a, motionVec.y, bz - random.nextDouble() / a), rider);
                GalacticraftCore.proxy.spawnParticle(flame, new Vector3(x3 - 0.2 + random.nextDouble() / 6.0, y3 - 0.4, z3 - 0.2 + random.nextDouble() / 6.0), new Vector3(bx - random.nextDouble() / a, motionVec.y, bz - random.nextDouble() / a), rider);
                GalacticraftCore.proxy.spawnParticle(flame, new Vector3(x3 + 0.2 - random.nextDouble() / 6.0, y3 - 0.4, z3 - 0.2 + random.nextDouble() / 6.0), new Vector3(bx - random.nextDouble() / a, motionVec.y, bz - random.nextDouble() / a), rider);
                GalacticraftCore.proxy.spawnParticle(flame, new Vector3(x3 + 0.7 - random.nextDouble() / 8.0, y3, z3 + 0.7 - random.nextDouble() / 8.0), new Vector3(bx - random.nextDouble() / a, motionVec.y, bz - random.nextDouble() / a), rider);
                GalacticraftCore.proxy.spawnParticle(flame, new Vector3(x3 - 0.7 + random.nextDouble() / 8.0, y3, z3 + 0.7 - random.nextDouble() / 8.0), new Vector3(bx - random.nextDouble() / a, motionVec.y, bz - random.nextDouble() / a), rider);
                GalacticraftCore.proxy.spawnParticle(flame, new Vector3(x3 - 0.7 + random.nextDouble() / 8.0, y3, z3 - 0.7 + random.nextDouble() / 8.0), new Vector3(bx - random.nextDouble() / a, motionVec.y, bz - random.nextDouble() / a), rider);
                GalacticraftCore.proxy.spawnParticle(flame, new Vector3(x3 + 0.7 - random.nextDouble() / 8.0, y3, z3 - 0.7 + random.nextDouble() / 8.0), new Vector3(bx - random.nextDouble() / a, motionVec.y, bz - random.nextDouble() / a), rider);
                GalacticraftCore.proxy.spawnParticle(flame, new Vector3(x3 + 0.7 - random.nextDouble() / 8.0, y3, z3 - random.nextDouble() / 8.0), new Vector3(bx - random.nextDouble() / a, motionVec.y, bz - random.nextDouble() / a), rider);
                GalacticraftCore.proxy.spawnParticle(flame, new Vector3(x3 - 0.7 + random.nextDouble() / 8.0, y3, z3 - random.nextDouble() / 8.0), new Vector3(bx - random.nextDouble() / a, motionVec.y, bz - random.nextDouble() / a), rider);
                GalacticraftCore.proxy.spawnParticle(flame, new Vector3(x3 + random.nextDouble() / 8.0, y3, z3 + 0.7 + random.nextDouble() / 8.0), new Vector3(bx - random.nextDouble() / a, motionVec.y, bz - random.nextDouble() / a), rider);
                GalacticraftCore.proxy.spawnParticle(flame, new Vector3(x3 - random.nextDouble() / 8.0, y3, z3 - 0.7 + random.nextDouble() / 8.0), new Vector3(bx - random.nextDouble() / a, motionVec.y, bz - random.nextDouble() / a), rider);
                GalacticraftCore.proxy.spawnParticle("blueflame", new Vector3(x2 - 0.8, y, z2), motionVec, none);
                GalacticraftCore.proxy.spawnParticle("blueflame", new Vector3(x2 + 0.8, y, z2), motionVec, none);
                GalacticraftCore.proxy.spawnParticle("blueflame", new Vector3(x2, y, z2 - 0.8), motionVec, none);
                GalacticraftCore.proxy.spawnParticle("blueflame", new Vector3(x2, y, z2 + 0.8), motionVec, none);
            }
        }
        if (this.launchPhase >= EntitySpaceshipBase.EnumLaunchPhase.LAUNCHED.ordinal() && this.hasValidFuel()) {
            if (this.launchPhase != EntitySpaceshipBase.EnumLaunchPhase.LAUNCHED.ordinal()) {
                this.field_70181_x -= 0.008;
            } else {
                double d3 = this.timeSinceLaunch / 150.0f;
                d3 = this.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider && ((IGalacticraftWorldProvider)this.field_70170_p.field_73011_w).hasNoAtmosphere() ? Math.min(d3 * 1.2, 1.8) : Math.min(d3, 1.2);
                if (d3 != 0.0) {
                    this.field_70181_x = -d3 * 2.0 * Math.cos((double)(this.field_70125_A - 180.0f) / 57.29577951308232);
                }
            }
            double d4 = 1.0;
            if (this.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider && (d4 = ((IGalacticraftWorldProvider)this.field_70170_p.field_73011_w).getFuelUsageMultiplier()) <= 0.0) {
                d4 = 1.0;
            }
            if (this.timeSinceLaunch % (float)MathHelper.func_76128_c((double)(2.0 * (1.0 / d4))) == 0.0f) {
                this.removeFuel(1);
                if (!this.hasValidFuel()) {
                    this.stopRocketSound();
                }
            }
        } else if (!this.hasValidFuel() && this.getLaunched() && !this.field_70170_p.field_72995_K && Math.abs(Math.sin(this.timeSinceLaunch / 1000.0f)) / 10.0 != 0.0) {
            this.field_70181_x -= Math.abs(Math.sin(this.timeSinceLaunch / 1000.0f)) / 20.0;
        }
    }

    private void autoLaunch_r() {
        try {
            Method method = EntityAutoRocket.class.getDeclaredMethod("autoLaunch", new Class[0]);
            method.setAccessible(true);
            method.invoke((Object)this, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private BlockVec3 getActiveLaunchController() {
        try {
            Field field = EntityAutoRocket.class.getDeclaredField("activeLaunchController");
            field.setAccessible(true);
            return (BlockVec3)field.get((Object)this);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            RuntimeException ex = new RuntimeException("Failed to get active launch controller via reflection!");
            ex.addSuppressed(e);
            throw ex;
        }
    }

    private boolean getRocketSoundToStop() {
        try {
            Field field = EntityAutoRocket.class.getDeclaredField("rocketSoundToStop");
            field.setAccessible(true);
            return (Boolean)field.get((Object)this);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            RuntimeException ex = new RuntimeException("Failed to get rocket sound state via reflection!");
            ex.addSuppressed(e);
            throw ex;
        }
    }

    private void setRocketSoundToStop(boolean b) {
        try {
            Field field = EntityAutoRocket.class.getDeclaredField("rocketSoundToStop");
            field.setAccessible(true);
            field.set((Object)this, b);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            RuntimeException ex = new RuntimeException("Failed to set rocket sound state via reflection!");
            ex.addSuppressed(e);
            throw ex;
        }
    }

    private boolean getAddToTelemetry() {
        try {
            Field field = EntitySpaceshipBase.class.getDeclaredField("addToTelemetry");
            field.setAccessible(true);
            return (Boolean)field.get((Object)this);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            RuntimeException ex = new RuntimeException("Failed to get telemetnry via reflection!");
            ex.addSuppressed(e);
            throw ex;
        }
    }

    private void setAddTotele(boolean b) {
        try {
            Field field = EntitySpaceshipBase.class.getDeclaredField("addToTelemetry");
            field.setAccessible(true);
            field.set((Object)this, b);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            RuntimeException ex = new RuntimeException("Failed to get telemetnry via reflection!");
            ex.addSuppressed(e);
            throw ex;
        }
    }

    private List<BlockVec3Dim> getTeleList() {
        try {
            Field field = EntitySpaceshipBase.class.getDeclaredField("telemetryList");
            field.setAccessible(true);
            return (List)field.get((Object)this);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            RuntimeException ex = new RuntimeException("Failed to get telemetnry via reflection!");
            ex.addSuppressed(e);
            throw ex;
        }
    }

    public float getCameraZoom() {
        return 25.0f;
    }

    public boolean defaultThirdPerson() {
        return true;
    }

    public int getRocketTier() {
        return 5;
    }

    public int getFuelTankCapacity() {
        return 2800;
    }

    public int getPreLaunchWait() {
        return 400;
    }

    public float getRenderOffsetY() {
        return -0.15f;
    }

    public boolean isDockValid(IFuelDock dock) {
        return dock instanceof TileEntityLandingPad;
    }
}

