/*
 * Decompiled with CFR 0.152.
 */
package net.rom.exoplanets.content.block.ore;

import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.oredict.OreDictionary;
import net.rom.exoplanets.content.EnumMetal;
import net.rom.exoplanets.content.block.BlockExoOre;
import net.rom.exoplanets.internal.RecipeBuilder;
import net.rom.exoplanets.internal.inerf.ICustomModel;
import net.rom.exoplanets.internal.inerf.item.ItemBlockMetaSubtypes;
import net.rom.exoplanets.util.CreativeExoTabs;

public class BlockOreMetal
extends BlockExoOre
implements ICustomModel {
    public static final PropertyEnum<EnumMetal> METAL = PropertyEnum.func_177709_a((String)"metal", EnumMetal.class);
    private String name;

    public BlockOreMetal(String name, boolean showInTab) {
        super(EnumMetal.values().length);
        this.func_149711_c(3.0f);
        this.func_149752_b(15.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.name = name;
        if (showInTab) {
            this.func_149647_a(CreativeExoTabs.TERRAIN_CREATIVE_TABS);
        }
        for (EnumMetal metal : EnumMetal.values()) {
            if (metal == EnumMetal.COPPER || metal == EnumMetal.TIN || metal == EnumMetal.ALUMINIUM) {
                this.setHarvestLevel("pickaxe", 1, this.func_176223_P().func_177226_a(METAL, (Comparable)((Object)metal)));
                continue;
            }
            this.setHarvestLevel("pickaxe", 2, this.func_176223_P().func_177226_a(METAL, (Comparable)((Object)metal)));
        }
    }

    @Override
    public void addRecipes(RecipeBuilder recipes) {
        for (EnumMetal metal : EnumMetal.values()) {
            ItemStack ore = new ItemStack((Block)this, 1, metal.meta);
            ItemStack ingot = metal.getIngot();
            recipes.addSmelting(ore, ingot, 0.5f);
        }
    }

    @Override
    public void addOreDict() {
        for (EnumMetal metal : EnumMetal.values()) {
            ItemStack stack = new ItemStack((Block)this, 1, metal.getMeta());
            OreDictionary.registerOre((String)("ore" + metal.getMetalName()), (ItemStack)stack);
            if (metal != EnumMetal.ALUMINIUM) continue;
            OreDictionary.registerOre((String)"oreAluminum", (ItemStack)stack);
        }
    }

    @Override
    public int func_180651_a(IBlockState state) {
        return ((EnumMetal)((Object)state.func_177229_b(METAL))).getMeta();
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        Item item = Item.func_150898_a((Block)this);
        for (EnumMetal metal : EnumMetal.values()) {
            ItemStack stack = new ItemStack(item, 1, metal.meta);
            list.add((Object)stack);
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(METAL, (Comparable)((Object)EnumMetal.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumMetal)((Object)state.func_177229_b(METAL))).getMeta();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{METAL});
    }

    @Override
    public void registerModels() {
        Item item = Item.func_150898_a((Block)this);
        for (EnumMetal metal : EnumMetal.values()) {
            ModelResourceLocation model = new ModelResourceLocation("exoplanets:" + this.name, "metal=" + metal.func_176610_l());
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)metal.getMeta(), (ModelResourceLocation)model);
        }
    }

    public static class ItemBlock
    extends ItemBlockMetaSubtypes {
        public ItemBlock(BlockOreMetal block) {
            super(block);
        }
    }
}

