/*
 * Decompiled with CFR 0.152.
 */
package net.rom.exoplanets.content.block.machine;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.rom.exoplanets.content.EnumMachineState;
import net.rom.exoplanets.content.item.IExoMetal;

public class BlockMachine
extends BlockContainer
implements IExoMetal {
    public static final PropertyEnum<EnumMachineState> FACING = PropertyEnum.func_177709_a((String)"facing", EnumMachineState.class);

    BlockMachine(Material materialIn) {
        super(materialIn);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(FACING, (Comparable)((Object)EnumMachineState.NORTH_OFF)));
        this.func_149711_c(4.0f);
        this.func_149752_b(6000.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.setHarvestLevel("pickaxe", 1);
    }

    @Override
    public List<ItemStack> getSubItems(Item item) {
        return ImmutableList.of((Object)new ItemStack(item));
    }

    public EnumMachineState getMachineState(World world, BlockPos pos) {
        return this.getMachineState(world.func_180495_p(pos));
    }

    public EnumMachineState getMachineState(IBlockState state) {
        return (EnumMachineState)((Object)state.func_177229_b(FACING));
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return null;
    }

    public int func_149750_m(IBlockState state) {
        return this.getMachineState((IBlockState)state).isOn ? 15 : 0;
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        this.setDefaultFacing(worldIn, pos, state);
    }

    private void setDefaultFacing(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K) {
            Block block = worldIn.func_180495_p(pos.func_177978_c()).func_177230_c();
            Block block1 = worldIn.func_180495_p(pos.func_177968_d()).func_177230_c();
            Block block2 = worldIn.func_180495_p(pos.func_177976_e()).func_177230_c();
            Block block3 = worldIn.func_180495_p(pos.func_177974_f()).func_177230_c();
            EnumMachineState machineState = (EnumMachineState)((Object)state.func_177229_b(FACING));
            if (machineState == EnumMachineState.NORTH_OFF && block.func_149730_j(state) && !block1.func_149730_j(state)) {
                machineState = EnumMachineState.SOUTH_OFF;
            } else if (machineState == EnumMachineState.SOUTH_OFF && block1.func_149730_j(state) && !block.func_149730_j(state)) {
                machineState = EnumMachineState.NORTH_OFF;
            } else if (machineState == EnumMachineState.WEST_OFF && block2.func_149730_j(state) && !block3.func_149730_j(state)) {
                machineState = EnumMachineState.EAST_OFF;
            } else if (machineState == EnumMachineState.EAST_OFF && block3.func_149730_j(state) && !block2.func_149730_j(state)) {
                machineState = EnumMachineState.WEST_OFF;
            }
            worldIn.func_180501_a(pos, state.func_177226_a(FACING, (Comparable)((Object)machineState)), 2);
        }
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        EnumMachineState machineState = EnumMachineState.fromEnumFacing(placer.func_174811_aO().func_176734_d());
        return this.func_176223_P().func_177226_a(FACING, (Comparable)((Object)machineState));
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        EnumMachineState machineState = EnumMachineState.fromEnumFacing(placer.func_174811_aO().func_176734_d());
        world.func_180501_a(pos, state.func_177226_a(FACING, (Comparable)((Object)machineState)), 2);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IInventory) {
            InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)((IInventory)tile));
            world.func_175666_e(pos, (Block)this);
        }
        super.func_180663_b(world, pos, state);
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        return Container.func_178144_a((TileEntity)world.func_175625_s(pos));
    }

    public ItemStack func_185473_a(World world, BlockPos pos, IBlockState state) {
        return new ItemStack(Item.func_150898_a((Block)this));
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public IBlockState func_176203_a(int meta) {
        EnumMachineState machineState = EnumMachineState.fromMeta(meta);
        return this.func_176223_P().func_177226_a(FACING, (Comparable)((Object)machineState));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumMachineState)((Object)state.func_177229_b(BlockMachine.FACING))).meta;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }
}

