/*
 * Decompiled with CFR 0.152.
 */
package net.rom.exoplanets.content.block.decoration;

import java.util.Locale;
import micdoodle8.mods.galacticraft.core.blocks.ISortableBlock;
import micdoodle8.mods.galacticraft.core.util.EnumSortCategoryBlock;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.model.ModelLoader;
import net.rom.exoplanets.content.EnumAlloy;
import net.rom.exoplanets.content.EnumMetal;
import net.rom.exoplanets.internal.RecipeBuilder;
import net.rom.exoplanets.internal.block.BlockMetaSubtypes;
import net.rom.exoplanets.internal.inerf.IAddRecipe;
import net.rom.exoplanets.internal.inerf.ICustomModel;
import net.rom.exoplanets.internal.inerf.item.ItemBlockMetaSubtypes;
import net.rom.exoplanets.util.CreativeExoTabs;

public class BlockMetalDecoration
extends BlockMetaSubtypes
implements ICustomModel,
IAddRecipe,
ISortableBlock {
    public static final PropertyEnum<Type> VARIANT = PropertyEnum.func_177709_a((String)"type", Type.class);

    public BlockMetalDecoration() {
        super(Material.field_151576_e, Type.values().length);
        this.func_149711_c(3.0f);
        this.func_149752_b(30.0f);
        this.setHarvestLevel("pickaxe", 2);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)Type.GRATING)));
        this.func_149647_a(CreativeExoTabs.DECO_CREATIVE_TABS);
    }

    public ItemStack getStack(Type type, int count) {
        return new ItemStack((Block)this, count, type.ordinal());
    }

    public IBlockState func_176203_a(int meta) {
        meta = MathHelper.func_76125_a((int)meta, (int)0, (int)(Type.values().length - 1));
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)Type.values()[meta]));
    }

    public int func_176201_c(IBlockState state) {
        return ((Type)((Object)state.func_177229_b(VARIANT))).ordinal();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    @Override
    public void registerModels() {
        Item item = Item.func_150898_a((Block)this);
        String fullName = "exoplanets:metaldecoration";
        for (Type type : Type.values()) {
            ModelResourceLocation model = new ModelResourceLocation(fullName, "type=" + type.func_176610_l());
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)type.ordinal(), (ModelResourceLocation)model);
        }
    }

    @Override
    public void addRecipes(RecipeBuilder recipes) {
        for (EnumMetal metals : EnumMetal.values()) {
            ItemStack sheets = metals.getSheet();
            ItemStack ingots = metals.getIngot();
            ItemStack grating = new ItemStack((Block)this, 4, 0);
            recipes.addShaped("grating", grating, "a a", "bbb", "   ", Character.valueOf('a'), Items.field_151042_j, Character.valueOf('b'), sheets);
            ItemStack grating_stripe = new ItemStack((Block)this, 4, 1);
            recipes.addShaped("grating_stripe", grating_stripe, "aca", "bbb", "   ", Character.valueOf('a'), Items.field_151042_j, Character.valueOf('b'), sheets, Character.valueOf('c'), Blocks.field_150325_L);
            ItemStack heavy_border = new ItemStack((Block)this, 2, 2);
            recipes.addSurround("heavy_border", heavy_border, EnumAlloy.STEEL.getSheet(), Items.field_151042_j);
            ItemStack light_border = new ItemStack((Block)this, 2, 3);
            recipes.addSurround("light_border", light_border, EnumMetal.ALUMINIUM.getSheet(), Items.field_151042_j);
            ItemStack pattern_m1 = new ItemStack((Block)this, 4, 4);
            recipes.addShaped("pattern_m1", pattern_m1, "aa ", "bc ", "   ", Character.valueOf('a'), sheets, Character.valueOf('b'), ingots, Character.valueOf('c'), Items.field_151042_j);
            ItemStack pattern_m2 = new ItemStack((Block)this, 4, 5);
            recipes.addShaped("pattern_m2", pattern_m2, "aa ", "bb ", "   ", Character.valueOf('a'), sheets, Character.valueOf('b'), ingots);
            ItemStack rivet = new ItemStack((Block)this, 4, 6);
            recipes.addShaped("rivet", rivet, "a a", "   ", "a a", Character.valueOf('a'), sheets);
            ItemStack fan = new ItemStack((Block)this, 4, 7);
            recipes.addShaped("fan", fan, " a ", "aba", " a ", Character.valueOf('a'), EnumAlloy.STEEL.getSheet(), Character.valueOf('b'), EnumAlloy.STEEL.getGear());
        }
    }

    public EnumSortCategoryBlock getCategory(int meta) {
        return EnumSortCategoryBlock.DECORATION;
    }

    public static class ItemBlock
    extends ItemBlockMetaSubtypes {
        public ItemBlock(BlockMetalDecoration block) {
            super(block);
        }
    }

    public static enum Type implements IStringSerializable
    {
        GRATING,
        GRATING_STRIPE,
        HEAVY_BORDER_METAL,
        LIGHT_BORDER_METAL,
        PATTERN_METAL,
        PATTERN_METAL_1,
        RIVET_METAL,
        METAL_FAN;


        public String func_176610_l() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public int getMetadata() {
            return this.ordinal();
        }
    }
}

