/*
 * Decompiled with CFR 0.152.
 */
package net.rom.exoplanets.content.block.decoration;

import com.google.common.base.Predicate;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.rom.exoplanets.content.block.BlockDecoration;
import net.rom.exoplanets.init.ExoBlocks;

public class BlockCellarLamp
extends BlockDecoration {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    protected static final AxisAlignedBB AABB_NORTH = new AxisAlignedBB(0.25, 0.25, 0.8, 0.75, 0.9, 1.0);
    protected static final AxisAlignedBB AABB_SOUTH = new AxisAlignedBB(0.25, 0.25, 0.0, 0.75, 0.9, 0.2);
    protected static final AxisAlignedBB AABB_WEST = new AxisAlignedBB(0.8, 0.25, 0.25, 1.0, 0.9, 0.75);
    protected static final AxisAlignedBB AABB_EAST = new AxisAlignedBB(0.0, 0.25, 0.25, 0.2, 0.9, 0.75);
    private final boolean isOn;

    public BlockCellarLamp(boolean isOn) {
        super(Material.field_151591_t);
        this.func_149711_c(2.0f);
        this.func_149752_b(5.0f);
        this.setHarvestLevel("axe", 2);
        this.func_149672_a(SoundType.field_185853_f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.isOn = isOn;
        if (isOn) {
            this.func_149715_a(1.0f);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
            default: {
                return AABB_NORTH;
            }
            case SOUTH: {
                return AABB_SOUTH;
            }
            case WEST: {
                return AABB_WEST;
            }
            case EAST: 
        }
        return AABB_EAST;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumFacing = EnumFacing.func_82600_a((int)meta);
        if (enumFacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumFacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumFacing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        if (this.canPlaceAt(worldIn, pos, facing)) {
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing);
        }
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            if (!this.canPlaceAt(worldIn, pos, enumfacing)) continue;
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
        }
        return this.func_176223_P();
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K) {
            if (!this.checkForDrop(worldIn, pos, state)) {
                return;
            }
            if (this.isOn && !worldIn.func_175640_z(pos)) {
                worldIn.func_180501_a(pos, ExoBlocks.cellar_lamp.func_176223_P().func_177226_a((IProperty)FACING, worldIn.func_180495_p(pos).func_177229_b((IProperty)FACING)), 2);
            } else if (!this.isOn && worldIn.func_175640_z(pos)) {
                worldIn.func_180501_a(pos, ExoBlocks.cellar_lamp_lit.func_176223_P().func_177226_a((IProperty)FACING, worldIn.func_180495_p(pos).func_177229_b((IProperty)FACING)), 2);
            }
        }
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!worldIn.field_72995_K) {
            if (!this.checkForDrop(worldIn, pos, state)) {
                return;
            }
            if (this.isOn && !worldIn.func_175640_z(pos)) {
                worldIn.func_175684_a(pos, (Block)this, 4);
            } else if (!this.isOn && worldIn.func_175640_z(pos)) {
                worldIn.func_180501_a(pos, ExoBlocks.cellar_lamp_lit.func_176223_P().func_177226_a((IProperty)FACING, worldIn.func_180495_p(pos).func_177229_b((IProperty)FACING)), 2);
            }
        }
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.field_72995_K && this.isOn && !worldIn.func_175640_z(pos)) {
            worldIn.func_180501_a(pos, ExoBlocks.cellar_lamp.func_176223_P().func_177226_a((IProperty)FACING, worldIn.func_180495_p(pos).func_177229_b((IProperty)FACING)), 2);
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)ExoBlocks.cellar_lamp);
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack(ExoBlocks.cellar_lamp);
    }

    protected ItemStack func_180643_i(IBlockState state) {
        return new ItemStack(ExoBlocks.cellar_lamp);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        return false;
    }

    private boolean canPlaceAt(World worldIn, BlockPos pos, EnumFacing facing) {
        BlockPos blockpos = pos.func_177972_a(facing.func_176734_d());
        return facing.func_176740_k().func_176722_c() && worldIn.isSideSolid(blockpos, facing, true);
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        for (EnumFacing enumfacing : FACING.func_177700_c()) {
            if (!this.canPlaceAt(worldIn, pos, enumfacing)) continue;
            return true;
        }
        return false;
    }

    protected boolean checkForDrop(World worldIn, BlockPos pos, IBlockState state) {
        if (state.func_177230_c() == this && this.canPlaceAt(worldIn, pos, (EnumFacing)state.func_177229_b((IProperty)FACING))) {
            return true;
        }
        if (worldIn.func_180495_p(pos).func_177230_c() == this) {
            this.func_176226_b(worldIn, pos, ExoBlocks.cellar_lamp.func_176223_P(), 0);
            worldIn.func_175698_g(pos);
        }
        return false;
    }
}

