/*
 * Decompiled with CFR 0.152.
 */
package net.rom.exoplanets.content;

import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.rom.exoplanets.content.IMetal;
import net.rom.exoplanets.content.block.ore.BlockOreMetal;
import net.rom.exoplanets.init.ExoBlocks;
import net.rom.exoplanets.init.ExoItems;

public enum EnumMetal implements IMetal
{
    COPPER(0, "Copper"),
    TIN(1, "Tin"),
    LEAD(2, "Lead"),
    NICKEL(3, "Nickel"),
    PLATINUM(4, "Platinum"),
    ALUMINIUM(5, "Aluminium"),
    TITANIUM(6, "Titanium"),
    TUNGSTEN(7, "Tungsten"),
    SILVER(8, "Silver"),
    ZINC(9, "Zinc");

    public final int meta;
    public final int dimension;
    public final String name;

    private EnumMetal(int meta, String name) {
        this(meta, name, 0);
    }

    private EnumMetal(int meta, String name, int dimension) {
        this.meta = meta;
        this.name = name;
        this.dimension = dimension;
    }

    @Override
    public int getMeta() {
        return this.meta;
    }

    @Override
    public String getMetalName() {
        return this.name;
    }

    @Override
    public String[] getMetalNames() {
        if (this == ALUMINIUM) {
            return new String[]{"Aluminium", "Aluminum"};
        }
        return new String[]{this.getMetalName()};
    }

    public String func_176610_l() {
        return this.name.toLowerCase(Locale.ROOT);
    }

    public static EnumMetal byMetadata(int meta) {
        if (meta < 0 || meta >= EnumMetal.values().length) {
            meta = 0;
        }
        return EnumMetal.values()[meta];
    }

    public IBlockState getOre() {
        return ExoBlocks.metalOre.func_176223_P().func_177226_a(BlockOreMetal.METAL, (Comparable)((Object)this));
    }

    public IBlockState getOre(Block ore) {
        return ore.func_176223_P().func_177226_a(BlockOreMetal.METAL, (Comparable)((Object)this));
    }

    public int getDimension() {
        return this.dimension;
    }

    @Override
    public boolean isAlloy() {
        return false;
    }

    @Override
    public boolean isClad() {
        return false;
    }

    @Override
    public ItemStack getBlock() {
        return new ItemStack(ExoBlocks.metalBlock, 1, this.meta);
    }

    @Override
    public ItemStack getIngot() {
        return new ItemStack(ExoItems.metalIngot, 1, this.meta);
    }

    @Override
    public ItemStack getDust() {
        return new ItemStack(ExoItems.metalDust, 1, this.meta);
    }

    @Override
    public ItemStack getSheet() {
        return new ItemStack(ExoItems.sheetBasic, 1, this.meta);
    }

    @Override
    public ItemStack getGear() {
        return new ItemStack(ExoItems.gearBasic, 1, this.meta);
    }

    @Override
    public ItemStack getPlate() {
        return null;
    }

    @Override
    public ItemStack getPile() {
        return null;
    }
}

