/*
 * Decompiled with CFR 0.152.
 */
package net.rom.exoplanets.content;

import javax.annotation.Nonnull;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;

public enum EnumMachineState implements IStringSerializable
{
    NORTH_OFF(2, "north_off", false),
    SOUTH_OFF(3, "south_off", false),
    WEST_OFF(4, "west_off", false),
    EAST_OFF(5, "east_off", false),
    NORTH_ON(10, "north_on", true),
    SOUTH_ON(11, "south_on", true),
    WEST_ON(12, "west_on", true),
    EAST_ON(13, "east_on", true);

    public final int meta;
    public final String name;
    public final boolean isOn;

    private EnumMachineState(int meta, String name, boolean isOn) {
        this.meta = meta;
        this.name = name;
        this.isOn = isOn;
    }

    public String func_176610_l() {
        return this.name;
    }

    @Nonnull
    public static EnumMachineState fromEnumFacing(EnumFacing facing) {
        switch (facing) {
            case EAST: {
                return EAST_OFF;
            }
            case NORTH: {
                return NORTH_OFF;
            }
            case SOUTH: {
                return SOUTH_OFF;
            }
            case WEST: {
                return WEST_OFF;
            }
        }
        return SOUTH_OFF;
    }

    public static EnumMachineState fromMeta(int meta) {
        for (EnumMachineState state : EnumMachineState.values()) {
            if (state.meta != meta) continue;
            return state;
        }
        return SOUTH_OFF;
    }
}

