/*
 * Decompiled with CFR 0.152.
 */
package net.rom.exoplanets.conf;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.config.IConfigElement;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.rom.exoplanets.ExoplanetsMod;

public class ConfigCore {
    static Configuration config;
    public static boolean enableCheckVersion;
    public static boolean enableOverworldOres;
    public static boolean enableDebug;
    public static boolean enableRealism;
    public static boolean warnBetaBuild;
    public static int configVersion;
    private static Map<String, List<String>> propOrder;
    private static String currentCat;
    public static final String CATEGORY_CORE = "Core Mod Settings";
    public static final String CATEGORY_CORE_LANGKEY = "exoplanets.configgui.category.core";

    public ConfigCore(File file) {
        config = new Configuration(file, "1.0");
        ConfigCore.syncConfig(true);
    }

    public static void syncConfig(boolean load) {
        try {
            propOrder.clear();
            if (!ConfigCore.config.isChild && load) {
                config.load();
            }
            config.addCustomCategoryComment(CATEGORY_CORE, CATEGORY_CORE);
            config.setCategoryLanguageKey(CATEGORY_CORE, CATEGORY_CORE_LANGKEY);
            config.setCategoryRequiresMcRestart(CATEGORY_CORE, true);
            Property prop = ConfigCore.getConfig(CATEGORY_CORE, "enableCheckVersion", true);
            prop.setComment("Enable/Disable Check Version");
            prop.setLanguageKey("exoplanets.configgui.enableCheckVersion");
            enableCheckVersion = prop.getBoolean(true);
            ConfigCore.finishProp(prop);
            prop = ConfigCore.getConfig(CATEGORY_CORE, "enableOverworldOres", true);
            prop.setComment("Enable/Disable Generation Ores on Overworld");
            prop.setLanguageKey("exoplanets.configgui.enableDebug");
            enableOverworldOres = prop.getBoolean(true);
            ConfigCore.finishProp(prop);
            prop = ConfigCore.getConfig(CATEGORY_CORE, "enableRealism", false);
            prop.setComment("Enabling loads the round & realistic Celestial Body Textures on the Celestial Map");
            prop.setLanguageKey("exoplanets.configgui.enableRealism");
            enableRealism = prop.getBoolean(false);
            ConfigCore.finishProp(prop);
            prop = ConfigCore.getConfig(CATEGORY_CORE, "warnBetaBuild", true);
            prop.setComment("Set to false to stop the Beta GUI from appearing at startup");
            prop.setLanguageKey("exoplanets.configgui.guiBeta");
            warnBetaBuild = prop.getBoolean(true);
            ConfigCore.finishProp(prop);
            if (config.hasChanged()) {
                config.save();
            }
        }
        catch (Exception e) {
            ExoplanetsMod.logger.bigError(true, "Intersteller Core Config had an issue loading the config file!", new Object[0]);
        }
    }

    public static void cleanConfig(Configuration config, Map<String, List<String>> propOrder) {
        LinkedList<String> categoriesToRemove = new LinkedList<String>();
        for (String catName : config.getCategoryNames()) {
            List<String> newProps = propOrder.get(catName);
            if (newProps == null) {
                categoriesToRemove.add(catName);
                continue;
            }
            ConfigCategory cat = config.getCategory(catName);
            LinkedList<String> toRemove = new LinkedList<String>();
            for (String oldprop : cat.keySet()) {
                if (newProps.contains(oldprop)) continue;
                toRemove.add(oldprop);
            }
            for (String removeMe : toRemove) {
                cat.remove((Object)removeMe);
            }
            config.setCategoryPropertyOrder(catName, propOrder.get(catName));
        }
        for (String catName : categoriesToRemove) {
            config.removeCategory(config.getCategory(catName));
        }
    }

    private static Property getConfig(String cat, String key, boolean defaultValue) {
        config.moveProperty(CATEGORY_CORE, key, cat);
        currentCat = cat;
        return config.get(cat, key, defaultValue);
    }

    private static void finishProp(Property prop) {
        if (propOrder.get(currentCat) == null) {
            propOrder.put(currentCat, new ArrayList());
        }
        propOrder.get(currentCat).add(prop.getName());
    }

    public static List<IConfigElement> getConfigElements() {
        ArrayList<IConfigElement> list = new ArrayList<IConfigElement>();
        ConfigCategory configGeneral = config.getCategory(CATEGORY_CORE);
        configGeneral.setComment("Core Settings");
        list.add((IConfigElement)new ConfigElement(configGeneral));
        return list;
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent eventArgs) {
        if (eventArgs.getModID().equals("exoplanets")) {
            config.save();
        }
    }

    static {
        propOrder = new TreeMap<String, List<String>>();
    }
}

