/*
 * Decompiled with CFR 0.152.
 */
package net.rom.exoplanets.compat.jei.alloyrefinery;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import net.rom.api.crafting.recipe.alloyrefinery.AlloyRefineryRecipe;
import net.rom.api.crafting.recipe.alloyrefinery.AlloyRefineryRecipeObject;

public class AlloyRefineryRecipeWrapper
implements IRecipeWrapper {
    private final AlloyRefineryRecipe recipe;

    public AlloyRefineryRecipeWrapper(@Nonnull AlloyRefineryRecipe recipe) {
        this.recipe = recipe;
    }

    List<AlloyRefineryRecipeObject> getInputObjects() {
        return Arrays.asList(this.recipe.getInputs());
    }

    private List<ItemStack> getInputs() {
        ArrayList list = Lists.newArrayList();
        for (AlloyRefineryRecipeObject recipeObject : this.recipe.getInputs()) {
            list.addAll(recipeObject.getPossibleItemStacks());
        }
        return list;
    }

    List<ItemStack> getOutputs() {
        return Collections.singletonList(this.recipe.getOutput());
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputs(ItemStack.class, this.getInputs());
        ingredients.setOutput(ItemStack.class, (Object)this.recipe.getOutput());
    }

    public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        FontRenderer fontRender = minecraft.field_71466_p;
        String str = String.format("%.1f XP", Float.valueOf(this.recipe.getExperience()));
        fontRender.func_175063_a(str, 63.0f, 0.0f, 0xFFFFFF);
        str = this.recipe.getCookTime() / 20 + "s";
        fontRender.func_175063_a(str, 66.0f, 28.0f, 0xFFFFFF);
    }
}

