/*
 * Decompiled with CFR 0.152.
 */
package net.rom.exoplanets.compat.jei.alloyrefinery;

import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.rom.api.crafting.recipe.alloyrefinery.AlloyRefineryRecipeObject;
import net.rom.exoplanets.ExoplanetsMod;
import net.rom.exoplanets.compat.jei.alloyrefinery.AlloyRefineryRecipeWrapper;

public class AlloyRefineryRecipeCategory
implements IRecipeCategory {
    public static final String UID = "exoplanets:alloy_refinery";
    private final IDrawable background;
    private final IDrawableAnimated flame;
    private final IDrawableAnimated arrow;
    private final String localizedName = ExoplanetsMod.translate.translate("jei.exoplanets.recipe.alloy_refinery", new Object[0]);

    public AlloyRefineryRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation backgroundLocation = new ResourceLocation("exoplanets:textures/gui/jei/alloyrefinery.png");
        this.background = guiHelper.createDrawable(backgroundLocation, 0, 0, 120, 40);
        ResourceLocation furnaceLocation = new ResourceLocation("minecraft", "textures/gui/container/furnace.png");
        IDrawableStatic flameDrawable = guiHelper.createDrawable(furnaceLocation, 176, 0, 14, 14);
        this.flame = guiHelper.createAnimatedDrawable(flameDrawable, 300, IDrawableAnimated.StartDirection.TOP, true);
        IDrawableStatic arrowDrawable = guiHelper.createDrawable(furnaceLocation, 176, 14, 24, 17);
        this.arrow = guiHelper.createAnimatedDrawable(arrowDrawable, 200, IDrawableAnimated.StartDirection.LEFT, false);
    }

    public void drawExtras(Minecraft minecraft) {
        this.flame.draw(minecraft, 2, 4);
        this.arrow.draw(minecraft, 62, 10);
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public String getTitle() {
        return this.localizedName;
    }

    public String getUid() {
        return UID;
    }

    public void setRecipe(IRecipeLayout recipeLayout, IRecipeWrapper recipeWrapper, IIngredients ingredients) {
        recipeLayout.getItemStacks().init(0, true, 25, 0);
        recipeLayout.getItemStacks().init(1, true, 43, 0);
        recipeLayout.getItemStacks().init(2, true, 25, 18);
        recipeLayout.getItemStacks().init(3, true, 43, 18);
        recipeLayout.getItemStacks().init(4, true, 0, 15);
        recipeLayout.getItemStacks().init(5, false, 98, 10);
        if (recipeWrapper instanceof AlloyRefineryRecipeWrapper) {
            AlloyRefineryRecipeWrapper wrapper = (AlloyRefineryRecipeWrapper)recipeWrapper;
            for (int i = 0; i < wrapper.getInputObjects().size(); ++i) {
                AlloyRefineryRecipeObject obj;
                AlloyRefineryRecipeObject recipeObject = obj = wrapper.getInputObjects().get(i);
                recipeLayout.getItemStacks().set(i, recipeObject.getPossibleItemStacks());
            }
            recipeLayout.getItemStacks().set(5, wrapper.getOutputs());
        }
    }

    public String getModName() {
        return "Interstellar: Exoplanets";
    }
}

