/*
 * Decompiled with CFR 0.152.
 */
package net.rom.exoplanets.client.gui;

import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.rom.exoplanets.conf.ConfigCore;
import net.rom.exoplanets.content.block.machine.container.ContainerMetalFurnace;
import net.rom.exoplanets.content.tile.TileEntityMetalFurnace;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiMetalFurnace
extends GuiContainer {
    private static final ResourceLocation guiTextures = new ResourceLocation("exoplanets", "textures/gui/metalfurnace.png");
    private IInventory tileFurnace;

    public GuiMetalFurnace(InventoryPlayer playerInventory, IInventory furnaceInventory) {
        super((Container)new ContainerMetalFurnace(playerInventory, furnaceInventory));
        this.tileFurnace = furnaceInventory;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        int i1;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(guiTextures);
        int k = (this.field_146294_l - this.field_146999_f) / 2;
        int l = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(k, l, 0, 0, this.field_146999_f, this.field_147000_g);
        if (TileEntityFurnace.func_174903_a((IInventory)this.tileFurnace)) {
            i1 = this.getBurnLeftScaled(13);
            this.func_73729_b(k + 7, l + 26 + 12 - i1, 176, 12 - i1, 14, i1 + 1);
        }
        i1 = this.getCookProgressScaled(24);
        this.func_73729_b(k + 79, l + 34, 176, 14, i1 + 1, 16);
        if (ConfigCore.enableDebug) {
            this.drawDebugInfo();
        }
    }

    private int getCookProgressScaled(int pixels) {
        int j = this.tileFurnace.func_174887_a_(2);
        int k = this.tileFurnace.func_174887_a_(3);
        return k != 0 && j != 0 ? j * pixels / k : 0;
    }

    private int getBurnLeftScaled(int pixels) {
        int currentItemBurnTime = this.tileFurnace.func_174887_a_(1);
        if (currentItemBurnTime == 0) {
            currentItemBurnTime = 200;
        }
        return this.tileFurnace.func_174887_a_(0) * pixels / currentItemBurnTime;
    }

    private void drawDebugInfo() {
        if (!(this.tileFurnace instanceof TileEntityMetalFurnace)) {
            return;
        }
        TileEntityMetalFurnace tile = (TileEntityMetalFurnace)this.tileFurnace;
        FontRenderer fontRender = this.field_146297_k.field_71466_p;
        int x = 5;
        int y = 5;
        int yIncrement = 10;
        int color = 0xFFFFFF;
        GL11.glPushMatrix();
        float scale = 0.75f;
        GL11.glScalef((float)scale, (float)scale, (float)1.0f);
        for (String str : tile.getDebugLines()) {
            fontRender.func_175063_a(str, (float)x, (float)y, color);
            y += yIncrement;
        }
        GL11.glPopMatrix();
    }
}

