/*
 * Decompiled with CFR 0.152.
 */
package net.rom.exoplanets.astronomy.yzceti.c;

import java.util.ArrayList;
import java.util.List;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.BiomeAdaptive;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.client.CloudRenderer;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DimensionType;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.rom.api.space.ExoPlanet;
import net.rom.exoplanets.astronomy.yzceti.YzCetiBlocks;
import net.rom.exoplanets.astronomy.yzceti.YzCetiDimensions;
import net.rom.exoplanets.astronomy.yzceti.c.ChunkProviderYzCetiC;
import net.rom.exoplanets.astronomy.yzceti.c.SkyProviderYzCetiC;
import net.rom.exoplanets.astronomy.yzceti.c.worldgen.BiomeProviderYzCetiC;
import net.rom.exoplanets.init.Planets;
import net.rom.exoplanets.internal.world.WorldProviderExoPlanet;

public class WorldProviderYzCetiC
extends WorldProviderExoPlanet {
    @Override
    public float getSolarSize() {
        return 1.0f;
    }

    @Override
    public double getMeteorFrequency() {
        return 2.0;
    }

    @Override
    public double getFuelUsageMultiplier() {
        return 3.8;
    }

    @Override
    public boolean hasBreathableAtmosphere() {
        return this.getExoPlanet().isBreathable();
    }

    public float getFallDamageModifier() {
        return 0.56f;
    }

    public float getSoundVolReductionAmount() {
        return 0.0f;
    }

    public float getThermalLevelModifier() {
        return 2.5f;
    }

    @Override
    public float getPlanetTemp() {
        ExoPlanet planet = this.getExoPlanet();
        float planetTemp = (float)planet.getPlanetTemp();
        planetTemp = this.isDaytime() ? (planetTemp *= 4.5f) : (float)planet.getPlanetTemp();
        return planetTemp;
    }

    public double getSolarEnergyMultiplier() {
        return 8.65;
    }

    public double getYCoordinateToTeleport() {
        return 1500.0;
    }

    public float func_76571_f() {
        return 128.0f;
    }

    @Override
    public Vector3 getSkyColor() {
        return new Vector3(0.0, 0.0, 0.0);
    }

    public boolean canRainOrSnow() {
        return this.getExoPlanet().isDoesRain();
    }

    public boolean hasSunset() {
        return true;
    }

    public boolean shouldDisablePrecipitation() {
        return !this.canRainOrSnow();
    }

    public boolean canDoRainSnowIce(Chunk chunk) {
        return this.canRainOrSnow();
    }

    @Override
    public boolean func_76567_e() {
        return this.shouldForceRespawn();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public float getStarBrightness(float par1) {
        float f1 = this.field_76579_a.func_72826_c(par1);
        float f2 = 1.0f - (MathHelper.func_76134_b((float)(f1 * (float)Math.PI * 2.0f)) * 2.0f + 0.3f);
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        return f2 * f2 * 1.8f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public float getSunBrightness(float par1) {
        float f1 = this.field_76579_a.func_72826_c(1.0f);
        float f2 = 0.9f - (MathHelper.func_76134_b((float)(f1 * (float)Math.PI * 2.0f)) * 2.0f + 0.2f);
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        f2 = 1.0f - f2;
        return f2 * 1.5f;
    }

    public CelestialBody getCelestialBody() {
        return Planets.YZCETIC;
    }

    public double getHorizon() {
        return 44.0;
    }

    public int func_76557_i() {
        return 65;
    }

    public boolean func_76566_a(int var1, int var2) {
        return true;
    }

    public ResourceLocation getDungeonChestType() {
        return null;
    }

    public List<Block> getSurfaceBlocks() {
        ArrayList<Block> blockList = new ArrayList<Block>();
        blockList.add(YzCetiBlocks.CetiC.C_SEDIMENTARYROCK);
        blockList.add(YzCetiBlocks.CetiC.C_IGNEOUS);
        blockList.add((Block)YzCetiBlocks.CetiC.C_GRAVEL);
        return blockList;
    }

    public DimensionType func_186058_p() {
        return YzCetiDimensions.YZCETIC;
    }

    public boolean func_76561_g() {
        return true;
    }

    public Class<? extends BiomeProvider> getBiomeProviderClass() {
        BiomeAdaptive.setBodyMultiBiome((CelestialBody)Planets.YZCETIC);
        return BiomeProviderYzCetiC.class;
    }

    @Override
    public Class<? extends IChunkGenerator> getChunkProviderClass() {
        return ChunkProviderYzCetiC.class;
    }

    @Override
    public long getDayLength() {
        return 28000L;
    }

    @Override
    public float getGravity() {
        return 0.03f;
    }

    @Override
    public ExoPlanet getExoPlanet() {
        return (ExoPlanet)this.getCelestialBody();
    }

    @Override
    public IRenderHandler getCloudRenderer() {
        if (super.getCloudRenderer() == null) {
            this.setCloudRenderer((IRenderHandler)new CloudRenderer());
        }
        return super.getCloudRenderer();
    }

    @SideOnly(value=Side.CLIENT)
    public IRenderHandler getSkyRenderer() {
        if (super.getSkyRenderer() == null) {
            this.setSkyRenderer((IRenderHandler)new SkyProviderYzCetiC());
        }
        return super.getSkyRenderer();
    }
}

