/*
 * Decompiled with CFR 0.152.
 */
package net.rom.exoplanets.astronomy.yzceti.b.worldgen.biome;

import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.chunk.ChunkPrimer;
import net.rom.exoplanets.astronomy.yzceti.YzCetiBlocks;
import net.rom.exoplanets.astronomy.yzceti.b.worldgen.BiomeDecoratorYzCetiB;
import net.rom.exoplanets.init.Planets;
import net.rom.exoplanets.internal.enums.EnumBiomeType;
import net.rom.exoplanets.internal.world.biome.BiomeSpace;

public class BiomeYzCetiBBase
extends BiomeSpace {
    protected static final IBlockState STONE = YzCetiBlocks.CetiB.B_METAMORPHIC.func_176223_P();
    protected static final IBlockState AIR = Blocks.field_150350_a.func_176223_P();
    protected static final IBlockState BEDROCK = Blocks.field_150357_h.func_176223_P();
    protected static final IBlockState GRAVEL = YzCetiBlocks.CetiB.B_IGNEOUS.func_176223_P();
    protected static final IBlockState DIRT = YzCetiBlocks.CetiB.B_METAMORPHIC.func_176223_P();
    protected static final IBlockState ICE = Blocks.field_150403_cj.func_176223_P();
    protected static final IBlockState WATER = Blocks.field_150355_j.func_176223_P();
    protected static final int SEA_LEVEL = 63;
    protected static final int SEA_FLOOR_LEVEL = 42;

    public BiomeYzCetiBBase(String singleName, Biome.BiomeProperties props) {
        super(singleName, props);
        this.setTempCategory(Biome.TempCategory.COLD);
        this.clearAllSpawning();
        this.setPlanetForBiome(Planets.YZCETID);
    }

    public final void generateYzCetiBTerrain(World worldIn, Random rand, ChunkPrimer chunkPrimerIn, int x, int z, double noiseVal) {
        int i = worldIn.func_181545_F();
        IBlockState topState = this.field_76752_A;
        IBlockState fillState = this.field_76753_B;
        int j = -1;
        int k = (int)(noiseVal / 3.0 + 3.0 + rand.nextDouble() * 0.25);
        int l = x & 0xF;
        int i1 = z & 0xF;
        for (int j1 = 255; j1 >= 0; --j1) {
            if (j1 == 0) {
                chunkPrimerIn.func_177855_a(i1, j1, l, BEDROCK);
                continue;
            }
            IBlockState iblockstate2 = chunkPrimerIn.func_177856_a(i1, j1, l);
            if (this.getBiomeType() == EnumBiomeType.OCEAN) {
                if (j1 < 63 && j1 > 42) {
                    chunkPrimerIn.func_177855_a(i1, j1, l, WATER);
                    continue;
                }
                if (j1 < 42) {
                    chunkPrimerIn.func_177855_a(i1, j1, l, STONE);
                    continue;
                }
                if (j1 == 42) {
                    chunkPrimerIn.func_177855_a(i1, j1, l, DIRT);
                    continue;
                }
                if (j1 < 63) continue;
                chunkPrimerIn.func_177855_a(i1, j1, l, AIR);
                continue;
            }
            if (iblockstate2.func_185904_a() == Material.field_151579_a) {
                j = -1;
                continue;
            }
            if (iblockstate2.func_177230_c() != YzCetiBlocks.CetiB.B_METAMORPHIC) continue;
            if (j == -1) {
                if (k <= 0) {
                    topState = AIR;
                    fillState = STONE;
                } else if (j1 >= i - 4 && j1 <= i + 1) {
                    topState = this.field_76752_A;
                    fillState = this.field_76753_B;
                }
                if (j1 < i && (topState == null || topState.func_185904_a() == Material.field_151579_a)) {
                    topState = ICE;
                }
                j = k;
                if (j1 >= i - 1) {
                    chunkPrimerIn.func_177855_a(i1, j1, l, topState);
                    continue;
                }
                if (j1 < i - 7 - k) {
                    topState = AIR;
                    fillState = STONE;
                    chunkPrimerIn.func_177855_a(i1, j1, l, GRAVEL);
                    continue;
                }
                chunkPrimerIn.func_177855_a(i1, j1, l, fillState);
                continue;
            }
            if (j <= 0) continue;
            --j;
            chunkPrimerIn.func_177855_a(i1, j1, l, fillState);
        }
    }

    public void func_180622_a(World worldIn, Random rand, ChunkPrimer chunkPrimerIn, int x, int z, double noiseVal) {
        this.generateYzCetiBTerrain(worldIn, rand, chunkPrimerIn, x, z, noiseVal);
    }

    public float func_76741_f() {
        return 0.1f;
    }

    public BiomeDecorator func_76729_a() {
        return new BiomeDecoratorYzCetiB();
    }

    protected BiomeDecoratorYzCetiB getBiomeDecorator() {
        return (BiomeDecoratorYzCetiB)this.field_76760_I;
    }
}

