/*
 * Decompiled with CFR 0.152.
 */
package net.rom.exoplanets.astronomy.yzceti.b;

import asmodeuscore.api.dimension.IAdvancedSpace;
import java.util.LinkedList;
import java.util.List;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.BiomeAdaptive;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.client.CloudRenderer;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DimensionType;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.rom.api.space.ExoPlanet;
import net.rom.exoplanets.astronomy.yzceti.YzCetiBlocks;
import net.rom.exoplanets.astronomy.yzceti.YzCetiDimensions;
import net.rom.exoplanets.astronomy.yzceti.b.ChunkProviderYzCetiB;
import net.rom.exoplanets.astronomy.yzceti.b.SkyProviderYzCetiB;
import net.rom.exoplanets.astronomy.yzceti.b.worldgen.BiomeProviderYzCetiB;
import net.rom.exoplanets.init.Planets;
import net.rom.exoplanets.internal.world.WorldProviderExoPlanet;

public class WorldProviderYzCetiB
extends WorldProviderExoPlanet
implements IAdvancedSpace {
    @Override
    public double getMeteorFrequency() {
        return 2.0;
    }

    @Override
    public float getSolarSize() {
        return 2.5f;
    }

    @Override
    public double getFuelUsageMultiplier() {
        return 1.4;
    }

    public float getFallDamageModifier() {
        return 0.1f;
    }

    public float getSoundVolReductionAmount() {
        return 1.0f;
    }

    public float getThermalLevelModifier() {
        return 5.5f;
    }

    @Override
    public float getPlanetTemp() {
        ExoPlanet planet = this.getExoPlanet();
        float planetTemp = (float)planet.getPlanetTemp();
        if (!this.isDaytime()) {
            planetTemp /= 1.4f;
        }
        return planetTemp;
    }

    public CelestialBody getCelestialBody() {
        return Planets.YZCETID;
    }

    public double getSolarEnergyMultiplier() {
        return 6.5;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public float getStarBrightness(float partialTicks) {
        float angle = this.field_76579_a.func_72826_c(partialTicks);
        float value = 1.0f - (MathHelper.func_76134_b((float)(angle * ((float)Math.PI * 2))) * 2.0f + 0.25f);
        value = MathHelper.func_76131_a((float)value, (float)0.0f, (float)1.0f);
        return value * value * 0.5f + 0.3f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public float getSunBrightness(float partialTicks) {
        float f1 = this.field_76579_a.func_72826_c(1.0f);
        float f2 = 1.0f - (MathHelper.func_76134_b((float)(f1 * ((float)Math.PI * 2))) * 2.0f + 0.2f);
        f2 = MathHelper.func_76131_a((float)f2, (float)0.0f, (float)1.0f);
        f2 = 1.2f - f2;
        return f2 * 0.8f;
    }

    public double getHorizon() {
        return 44.0;
    }

    public int func_76557_i() {
        return 76;
    }

    @Override
    public Vector3 getFogColor() {
        float f = 0.6f - this.getStarBrightness(1.0f);
        return new Vector3((double)(0.8352941f * f), (double)(0.28235295f * f), (double)(0.011764706f * f));
    }

    @Override
    public Vector3 getSkyColor() {
        float f = 0.3f - this.getStarBrightness(1.0f);
        return new Vector3((double)(0.89411765f * f), (double)(0.29411766f * f), (double)(0.003921569f * f));
    }

    public boolean canRainOrSnow() {
        return false;
    }

    public boolean hasSunset() {
        return false;
    }

    public ResourceLocation getDungeonChestType() {
        return null;
    }

    public List<Block> getSurfaceBlocks() {
        LinkedList<Block> list = new LinkedList<Block>();
        list.add(YzCetiBlocks.CetiB.B_METAMORPHIC);
        list.add(YzCetiBlocks.CetiB.B_LOOSE_SEDIMENT);
        list.add(YzCetiBlocks.CetiD.D_IGNEOUS);
        return list;
    }

    public Class<? extends BiomeProvider> getBiomeProviderClass() {
        BiomeAdaptive.setBodyMultiBiome((CelestialBody)Planets.YZCETID);
        return BiomeProviderYzCetiB.class;
    }

    public DimensionType func_186058_p() {
        return YzCetiDimensions.YZCETIB;
    }

    public double getYCoordinateToTeleport() {
        return 1500.0;
    }

    public boolean func_76566_a(int var1, int var2) {
        return true;
    }

    public boolean func_76561_g() {
        return true;
    }

    @Override
    public Class<? extends IChunkGenerator> getChunkProviderClass() {
        return ChunkProviderYzCetiB.class;
    }

    @Override
    public long getDayLength() {
        return 23500L;
    }

    @Override
    public float getGravity() {
        return 0.03f;
    }

    @Override
    public int AtmosphericPressure() {
        return 5;
    }

    @Override
    public boolean SolarRadiation() {
        return true;
    }

    @Override
    public double getSolarWindMultiplier() {
        return 0.6;
    }

    @Override
    public IAdvancedSpace.ClassBody getClassBody() {
        return IAdvancedSpace.ClassBody.SELENA;
    }

    @Override
    public float getSolarRadiationModify() {
        return 5.0f;
    }

    @Override
    public ExoPlanet getExoPlanet() {
        return (ExoPlanet)this.getCelestialBody();
    }

    @Override
    public IRenderHandler getCloudRenderer() {
        if (super.getCloudRenderer() == null) {
            this.setCloudRenderer((IRenderHandler)new CloudRenderer());
        }
        return super.getCloudRenderer();
    }

    @SideOnly(value=Side.CLIENT)
    public IRenderHandler getSkyRenderer() {
        if (super.getSkyRenderer() == null) {
            this.setSkyRenderer((IRenderHandler)new SkyProviderYzCetiB());
        }
        return super.getSkyRenderer();
    }
}

