/*
 * Decompiled with CFR 0.152.
 */
package net.rom.exoplanets.astronomy.trappist1.d;

import asmodeuscore.core.astronomy.dimension.world.worldengine.WE_ChunkProviderSpace;
import asmodeuscore.core.astronomy.dimension.world.worldengine.WE_WorldProviderSpace;
import asmodeuscore.core.utils.worldengine.WE_Biome;
import asmodeuscore.core.utils.worldengine.WE_ChunkProvider;
import asmodeuscore.core.utils.worldengine.standardcustomgen.WE_TerrainGenerator;
import java.util.List;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import net.minecraft.block.Block;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.rom.exoplanets.astronomy.trappist1.TrappistDimensions;
import net.rom.exoplanets.astronomy.trappist1.d.biomes.BiomeOceananic;
import net.rom.exoplanets.init.Planets;
import net.rom.exoplanets.util.RGB;

public class WorldProviderTrappist1D
extends WE_WorldProviderSpace {
    public static WE_ChunkProvider chunk;

    public double getFuelUsageMultiplier() {
        return 0.0;
    }

    public float getFallDamageModifier() {
        return 0.0f;
    }

    public double getHorizon() {
        return 5.0;
    }

    public CelestialBody getCelestialBody() {
        return Planets.TRAPPIST1D;
    }

    public int getDungeonSpacing() {
        return 0;
    }

    public ResourceLocation getDungeonChestType() {
        return null;
    }

    public List<Block> getSurfaceBlocks() {
        return null;
    }

    public void genSettings(WE_ChunkProvider cp) {
        chunk = cp;
        cp.createChunkGen_List.clear();
        cp.createChunkGen_InXZ_List.clear();
        cp.createChunkGen_InXYZ_List.clear();
        cp.decorateChunkGen_List.clear();
        WE_Biome.setBiomeMap((WE_ChunkProvider)cp, (double)2.6, (int)4, (double)1000.0, (double)1.0);
        WE_TerrainGenerator terrainGenerator = new WE_TerrainGenerator();
        terrainGenerator.worldSeaGen = true;
        terrainGenerator.worldSeaGenBlock = Blocks.field_150355_j.func_176223_P();
        terrainGenerator.worldSeaGenMaxY = 95;
        cp.createChunkGen_List.add(terrainGenerator);
        ((WE_ChunkProviderSpace)cp).worldGenerators.clear();
        cp.biomesList.clear();
        WE_Biome.addBiomeToGeneration((WE_ChunkProvider)cp, (WE_Biome)new BiomeOceananic());
    }

    public float getSolarSize() {
        return 0.3f / this.getCelestialBody().getRelativeDistanceFromCenter().unScaledDistance;
    }

    public int func_76559_b(long worldTime) {
        return (int)(worldTime / this.getDayLength() % 8L + 8L) % 8;
    }

    @SideOnly(value=Side.CLIENT)
    public void getLightmapColors(float partialTicks, float sunBrightness, float skyLight, float blockLight, float[] colors) {
        EntityPlayerSP player = FMLClientHandler.instance().getClientPlayerEntity();
        if (player != null) {
            int phase = this.func_76559_b(this.getWorldTime());
            if (skyLight > 0.0f && sunBrightness > 0.07f && phase != 0 && phase != 6) {
                colors[0] = colors[0] + skyLight + 0.3f;
                colors[1] = colors[1] + skyLight / 6.0f;
            }
        }
    }

    public void onChunkProvider(int cX, int cZ, ChunkPrimer primer) {
    }

    public void onPopulate(int x, int z) {
    }

    public void recreateStructures(Chunk chunkIn, int x, int z) {
    }

    public boolean shouldForceRespawn() {
        return !ConfigManagerCore.forceOverworldRespawn;
    }

    public Class<? extends IChunkGenerator> getChunkProviderClass() {
        return WE_ChunkProvider.class;
    }

    public DimensionType func_186058_p() {
        return TrappistDimensions.TRAPPIST_1D;
    }

    public boolean enableAdvancedThermalLevel() {
        return true;
    }

    protected float getThermalValueMod() {
        return 2.1f;
    }

    @SideOnly(value=Side.CLIENT)
    public float getStarBrightness(float partialTicks) {
        float angle = this.field_76579_a.func_72826_c(partialTicks);
        float value = 1.0f - (MathHelper.func_76134_b((float)(angle * ((float)Math.PI * 2))) * 2.0f + 0.25f);
        value = MathHelper.func_76131_a((float)value, (float)0.0f, (float)1.0f);
        return value * value * 0.5f + 0.3f;
    }

    @SideOnly(value=Side.CLIENT)
    public float getSunBrightness(float partialTicks) {
        float f1 = this.field_76579_a.func_72826_c(1.0f);
        float f2 = 1.0f - (MathHelper.func_76134_b((float)(f1 * ((float)Math.PI * 2))) * 2.0f + 0.2f);
        f2 = MathHelper.func_76131_a((float)f2, (float)0.0f, (float)1.0f);
        f2 = 1.2f - f2;
        return f2 * 0.8f;
    }

    public Vector3 getFogColor() {
        float f = 0.6f - this.getStarBrightness(1.0f);
        RGB c = RGB.parse("SkyBlue");
        return new Vector3((double)(c.getRed() * f), (double)(c.getGreen() * f), (double)(c.getBlue() * f));
    }

    public Vector3 getSkyColor() {
        float f = 0.3f - this.getStarBrightness(1.0f);
        RGB c = RGB.parse("SkyBlue");
        return new Vector3((double)(c.getRed() * f), (double)(c.getGreen() * f), (double)(c.getBlue() * f));
    }

    public boolean func_76561_g() {
        return false;
    }

    public boolean hasSunset() {
        return false;
    }

    public static int getGroundFromAbove(World world, int x, int z) {
        int y = 255;
        boolean foundGround = false;
        while (!foundGround && y-- > 0) {
            Block block = world.func_180495_p(new BlockPos(x, y, z)).func_177230_c();
            if (block == Blocks.field_150350_a) {
                y = -1;
                break;
            }
            foundGround = block != Blocks.field_150350_a;
        }
        return y;
    }
}

