/*
 * Decompiled with CFR 0.152.
 */
package net.rom.exoplanets.astronomy.kepler1649.c;

import asmodeuscore.core.astronomy.dimension.world.worldengine.WE_ChunkProviderSpace;
import asmodeuscore.core.astronomy.dimension.world.worldengine.WE_WorldProviderSpace;
import asmodeuscore.core.utils.worldengine.WE_Biome;
import asmodeuscore.core.utils.worldengine.WE_ChunkProvider;
import asmodeuscore.core.utils.worldengine.standardcustomgen.WE_CaveGen;
import asmodeuscore.core.utils.worldengine.standardcustomgen.WE_RavineGen;
import asmodeuscore.core.utils.worldengine.standardcustomgen.WE_TerrainGenerator;
import java.util.List;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import net.minecraft.block.Block;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DimensionType;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.rom.exoplanets.astronomy.kepler1649.Kepler1649Dimensions;
import net.rom.exoplanets.astronomy.kepler1649.KeplerBlocks;
import net.rom.exoplanets.astronomy.kepler1649.c.SkyProviderKepler1649c;
import net.rom.exoplanets.astronomy.kepler1649.c.biomes.TestHighMountains;
import net.rom.exoplanets.astronomy.kepler1649.c.biomes.TestPlains;
import net.rom.exoplanets.astronomy.kepler1649.c.worldgen.BiomeProviderKepler1649c;
import net.rom.exoplanets.init.Planets;

public class WorldProviderKepler1649c
extends WE_WorldProviderSpace {
    public static WE_ChunkProvider chunk;

    public boolean enableAdvancedThermalLevel() {
        return true;
    }

    protected float getThermalValueMod() {
        return 0.2f;
    }

    public double getHorizon() {
        return 44.0;
    }

    public double getFuelUsageMultiplier() {
        return 1.5;
    }

    public float getFallDamageModifier() {
        return 0.0f;
    }

    public long getDayLength() {
        return 24000L;
    }

    public CelestialBody getCelestialBody() {
        return Planets.KEPLER1649C;
    }

    public int getDungeonSpacing() {
        return 0;
    }

    public ResourceLocation getDungeonChestType() {
        return null;
    }

    public List<Block> getSurfaceBlocks() {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public IRenderHandler getSkyRenderer() {
        if (super.getSkyRenderer() == null) {
            this.setSkyRenderer((IRenderHandler)new SkyProviderKepler1649c());
        }
        return super.getSkyRenderer();
    }

    public void genSettings(WE_ChunkProvider cp) {
        chunk = cp;
        cp.createChunkGen_List.clear();
        cp.createChunkGen_InXZ_List.clear();
        cp.createChunkGen_InXYZ_List.clear();
        cp.decorateChunkGen_List.clear();
        WE_Biome.setBiomeMap((WE_ChunkProvider)cp, (double)1.5, (int)6, (double)1200.0, (double)1.0);
        WE_TerrainGenerator terrainGenerator = new WE_TerrainGenerator();
        terrainGenerator.worldStoneBlock = KeplerBlocks.Kepler1649C.kepler_surface2.func_176223_P();
        terrainGenerator.worldSeaGen = false;
        terrainGenerator.worldSeaGenBlock = Blocks.field_150355_j.func_176223_P();
        terrainGenerator.worldSeaGenMaxY = 64;
        cp.createChunkGen_List.add(terrainGenerator);
        WE_CaveGen cg = new WE_CaveGen();
        cg.replaceBlocksList.clear();
        cg.addReplacingBlock(terrainGenerator.worldStoneBlock);
        cg.lavaMaxY = 15;
        cp.createChunkGen_List.add(cg);
        WE_RavineGen rg = new WE_RavineGen();
        rg.replaceBlocksList.clear();
        rg.addReplacingBlock(terrainGenerator.worldStoneBlock);
        rg.lavaBlock = Blocks.field_150353_l.func_176223_P();
        rg.lavaMaxY = 15;
        cp.createChunkGen_List.add(rg);
        ((WE_ChunkProviderSpace)cp).worldGenerators.clear();
        cp.biomesList.clear();
        WE_Biome.addBiomeToGeneration((WE_ChunkProvider)cp, (WE_Biome)new TestPlains(-0.0, 0.0));
        WE_Biome.addBiomeToGeneration((WE_ChunkProvider)cp, (WE_Biome)new TestHighMountains(-0.4, 1.4));
    }

    public float getSolarSize() {
        return 0.3f / this.getCelestialBody().getRelativeDistanceFromCenter().unScaledDistance;
    }

    public int func_76559_b(long worldTime) {
        return (int)(worldTime / this.getDayLength() % 8L + 8L) % 8;
    }

    @SideOnly(value=Side.CLIENT)
    public void getLightmapColors(float partialTicks, float sunBrightness, float skyLight, float blockLight, float[] colors) {
        EntityPlayerSP player = FMLClientHandler.instance().getClientPlayerEntity();
        if (player != null) {
            int phase = this.func_76559_b(this.getWorldTime());
            if (skyLight > 0.0f && sunBrightness > 0.07f && phase != 0 && phase != 6) {
                colors[0] = colors[0] + skyLight + 0.3f;
                colors[1] = colors[1] + skyLight / 6.0f;
            }
        }
    }

    public void onChunkProvider(int cX, int cZ, ChunkPrimer primer) {
    }

    public void onPopulate(int cX, int cZ) {
    }

    public void recreateStructures(Chunk chunkIn, int x, int z) {
    }

    @SideOnly(value=Side.CLIENT)
    public float getStarBrightness(float partialTicks) {
        float angle = this.field_76579_a.func_72826_c(partialTicks);
        float value = 1.0f - (MathHelper.func_76134_b((float)(angle * ((float)Math.PI * 2))) * 2.0f + 0.25f);
        value = MathHelper.func_76131_a((float)value, (float)0.0f, (float)1.0f);
        return value * value * 0.5f + 0.3f;
    }

    @SideOnly(value=Side.CLIENT)
    public float getSunBrightness(float partialTicks) {
        float f1 = this.field_76579_a.func_72826_c(1.0f);
        float f2 = 1.0f - (MathHelper.func_76134_b((float)(f1 * ((float)Math.PI * 2))) * 2.0f + 0.2f);
        f2 = MathHelper.func_76131_a((float)f2, (float)0.0f, (float)1.0f);
        f2 = 1.2f - f2;
        return f2 * 0.8f;
    }

    public Vector3 getFogColor() {
        float f = 0.6f - this.getStarBrightness(1.0f);
        return new Vector3((double)(0.8352941f * f), (double)(0.28235295f * f), (double)(0.011764706f * f));
    }

    public Vector3 getSkyColor() {
        float f = 0.3f - this.getStarBrightness(1.0f);
        return new Vector3((double)(0.89411765f * f), (double)(0.29411766f * f), (double)(0.003921569f * f));
    }

    public boolean hasSunset() {
        return false;
    }

    public boolean shouldForceRespawn() {
        return !ConfigManagerCore.forceOverworldRespawn;
    }

    public Class<? extends IChunkGenerator> getChunkProviderClass() {
        return WE_ChunkProviderSpace.class;
    }

    public DimensionType func_186058_p() {
        return Kepler1649Dimensions.KEPLER1649_C;
    }

    public Class<? extends BiomeProvider> getBiomeProviderClass() {
        return BiomeProviderKepler1649c.class;
    }
}

