/*
 * Decompiled with CFR 0.152.
 */
package net.rom.exoplanets.astronomy;

import java.util.LinkedList;
import java.util.List;
import micdoodle8.mods.galacticraft.api.world.BiomeGenBaseGC;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.rom.exoplanets.astronomy.yzceti.b.worldgen.biome.BiomeYzCetiB;
import net.rom.exoplanets.astronomy.yzceti.b.worldgen.biome.BiomeYzCetiBDirty;
import net.rom.exoplanets.astronomy.yzceti.c.worldgen.biomes.BiomeYzCetiC;
import net.rom.exoplanets.astronomy.yzceti.c.worldgen.biomes.BiomeYzCetiCUnknown;

public class ExoplanetBiomes {
    public static final List<BiomeGenBaseGC> biomeList = new LinkedList<BiomeGenBaseGC>();
    public static final Biome CETIB_BASE = new BiomeYzCetiB(new Biome.BiomeProperties("Yz Ceti B"));
    public static final Biome CETIB_DIRTY = new BiomeYzCetiBDirty(new Biome.BiomeProperties("Yz Ceti B Dirty"));
    public static final Biome CETIC_BASE = new BiomeYzCetiC(new Biome.BiomeProperties("Yz Ceti C"));
    public static final Biome CETIC_UNKNWON = new BiomeYzCetiCUnknown(new Biome.BiomeProperties("Yz Ceti Unknown"));

    public static void init() {
        ExoplanetBiomes.addBiome(CETIB_BASE, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.DRY);
        ExoplanetBiomes.addBiome(CETIB_DIRTY, BiomeDictionary.Type.SPOOKY, BiomeDictionary.Type.DEAD);
        ExoplanetBiomes.addBiome(CETIC_BASE, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.DRY);
        ExoplanetBiomes.addBiome(CETIC_UNKNWON, BiomeDictionary.Type.SPOOKY, BiomeDictionary.Type.DEAD);
    }

    private static void addBiome(Biome biome, BiomeDictionary.Type ... biomeType) {
        ExoplanetBiomes.registerBiome(biome);
        ExoplanetBiomes.registerBiomeType(biome, biomeType);
    }

    public static void registerBiome(Biome biome) {
        ForgeRegistries.BIOMES.register((IForgeRegistryEntry)biome);
    }

    public static void registerBiomeType(Biome biome, BiomeDictionary.Type ... biomeType) {
        BiomeDictionary.addTypes((Biome)biome, (BiomeDictionary.Type[])biomeType);
    }
}

