/*
 * Decompiled with CFR 0.152.
 */
package net.rom.exoplanets.astronomy;

import net.rom.exoplanets.Assets;

public class CelestialAssets {
    private static final String YZCETI = "yzceti";
    private static final String KELPER1649 = "kepler1649";
    private static final String TRAPPIST = "trappist1";
    private static final String WOLF1061 = "wolf1061";

    public static void init() {
        CelestialAssets.registerNormal();
        CelestialAssets.registerRealistic();
    }

    private static void registerNormal() {
        CelestialAssets.put("yzcetistar", YZCETI);
        CelestialAssets.put("kepler1649star", KELPER1649);
        CelestialAssets.put("trappist1star", TRAPPIST);
        CelestialAssets.put("wolf1061star", WOLF1061);
        CelestialAssets.put("yzcetib", YZCETI);
        CelestialAssets.put("yzcetic", YZCETI);
        CelestialAssets.put("yzcetid", YZCETI);
        CelestialAssets.put("kepler1649b", KELPER1649);
        CelestialAssets.put("kepler1649c", KELPER1649);
        CelestialAssets.put("trappist1b", TRAPPIST);
        CelestialAssets.put("trappist1c", TRAPPIST);
        CelestialAssets.put("trappist1d", TRAPPIST);
        CelestialAssets.put("trappist1e", TRAPPIST);
        CelestialAssets.put("trappist1f", TRAPPIST);
        CelestialAssets.put("trappist1g", TRAPPIST);
        CelestialAssets.put("trappist1h", TRAPPIST);
        CelestialAssets.put("wolf1061b", WOLF1061);
        CelestialAssets.put("wolf1061c", WOLF1061);
        CelestialAssets.put("wolf1061d", WOLF1061);
    }

    private static void registerRealistic() {
        CelestialAssets.putRealistic("realyzcetistar", YZCETI);
        CelestialAssets.putRealistic("realkepler1649star", KELPER1649);
        CelestialAssets.putRealistic("realtrappist1star", TRAPPIST);
        CelestialAssets.putRealistic("realwolf1061star", WOLF1061);
        CelestialAssets.putRealistic("realyzcetib", YZCETI);
        CelestialAssets.putRealistic("realyzcetic", YZCETI);
        CelestialAssets.putRealistic("realyzcetid", YZCETI);
        CelestialAssets.putRealistic("realkepler1649b", KELPER1649);
        CelestialAssets.putRealistic("realkepler1649c", KELPER1649);
        CelestialAssets.putRealistic("realtrappist1b", TRAPPIST);
        CelestialAssets.putRealistic("realtrappist1c", TRAPPIST);
        CelestialAssets.putRealistic("realtrappist1d", TRAPPIST);
        CelestialAssets.putRealistic("realtrappist1e", TRAPPIST);
        CelestialAssets.putRealistic("realtrappist1f", TRAPPIST);
        CelestialAssets.putRealistic("realtrappist1g", TRAPPIST);
        CelestialAssets.putRealistic("realtrappist1h", TRAPPIST);
        CelestialAssets.putRealistic("realwolf1061b", WOLF1061);
        CelestialAssets.putRealistic("realwolf1061c", WOLF1061);
        CelestialAssets.putRealistic("realwolf1061d", WOLF1061);
    }

    private static void put(String name, String systemName) {
        Assets.addCelestialTexture(name, systemName);
    }

    private static void putRealistic(String name, String systemName) {
        Assets.addRealisticCelestialTexture(name, systemName);
    }
}

