/*
 * Decompiled with CFR 0.152.
 */
package net.rom.exoplanets;

import asmodeuscore.core.astronomy.BodiesRegistry;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import micdoodle8.mods.galacticraft.api.world.BiomeGenBaseGC;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.rom.exoplanets.astronomy.CelestialAssets;
import net.rom.exoplanets.astronomy.ExoplanetBiomes;
import net.rom.exoplanets.astronomy.kepler1649.Kepler1649Dimensions;
import net.rom.exoplanets.astronomy.trappist1.TrappistDimensions;
import net.rom.exoplanets.astronomy.yzceti.YzCetiDimensions;
import net.rom.exoplanets.conf.ConfigPlanets;
import net.rom.exoplanets.conf.ExoConfigs;
import net.rom.exoplanets.events.GuiHandlerExo;
import net.rom.exoplanets.events.HabitableZoneClientHandler;
import net.rom.exoplanets.init.ExoFluids;
import net.rom.exoplanets.init.ExoRecipes;
import net.rom.exoplanets.init.Planets;
import net.rom.exoplanets.init.RegistrationHandler;
import net.rom.exoplanets.init.SolarSystems;
import net.rom.exoplanets.internal.LogHelper;
import net.rom.exoplanets.internal.MCUtil;
import net.rom.exoplanets.internal.StellarRegistry;
import net.rom.exoplanets.proxy.ExoCommonProxy;
import net.rom.exoplanets.util.TranslateUtil;
import net.rom.exoplanets.world.OverworldOreGen;

@Mod(modid="exoplanets", name="Interstellar: Exoplanets", version="0.1.3", dependencies="required-after:galacticraftcore@[4.0.2.261,);required-after:galacticraftplanets;required-after:asmodeuscore@[0.0.30,)", acceptedMinecraftVersions="1.12.2", guiFactory="net.rom.exoplanets.client.screen.ExoplanetsConfigGuiFactory", certificateFingerprint="33ca92ce5eed6e15e06d52c25ddd6f2ac78f9cf4", useMetadata=true)
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ExoplanetsMod {
    @Mod.Instance(value="exoplanets")
    public static ExoplanetsMod instance;
    public static StellarRegistry REGISTRY;
    public static TranslateUtil translate;
    public static LogHelper logger;
    public static ResourceLocation location;
    @SidedProxy(clientSide="net.rom.exoplanets.proxy.ExoClientProxy", serverSide="net.rom.exoplanets.proxy.ExoCommonProxy")
    public static ExoCommonProxy proxy;
    public static Random random;
    public static String exoPlanetsDirectory;
    public static final boolean isDevBuild;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        exoPlanetsDirectory = event.getModConfigurationDirectory() + "/Exoplanets/";
        REGISTRY.setMod(this);
        REGISTRY.getRecipeMaker();
        BodiesRegistry.setMaxTier((int)3);
        ExoConfigs.init();
        ExoFluids.init();
        RegistrationHandler.init(REGISTRY);
        CelestialAssets.init();
        ExoplanetBiomes.init();
        SolarSystems.init();
        Planets.init();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new GuiHandlerExo());
        MinecraftForge.EVENT_BUS.register((Object)new HabitableZoneClientHandler());
        proxy.preInit(REGISTRY, event);
    }

    @Mod.EventHandler
    public static void init(FMLInitializationEvent event) {
        GameRegistry.registerWorldGenerator((IWorldGenerator)new OverworldOreGen(), (int)0);
        proxy.registerRender();
        for (BiomeGenBaseGC biome : ExoplanetBiomes.biomeList) {
            biome.registerTypes((Biome)biome);
        }
        proxy.init(REGISTRY, event);
    }

    @Mod.EventHandler
    public static void postInit(FMLPostInitializationEvent event) {
        ExoRecipes.alloySmelterRecipes();
        YzCetiDimensions.YZCETIB = WorldUtil.getDimensionTypeById((int)ConfigPlanets.id_yz_b);
        YzCetiDimensions.YZCETIC = WorldUtil.getDimensionTypeById((int)ConfigPlanets.id_yz_c);
        YzCetiDimensions.YZCETID = WorldUtil.getDimensionTypeById((int)ConfigPlanets.id_yz_d);
        TrappistDimensions.TRAPPIST_1C = WorldUtil.getDimensionTypeById((int)ConfigPlanets.id_trap_c);
        TrappistDimensions.TRAPPIST_1D = WorldUtil.getDimensionTypeById((int)ConfigPlanets.id_trap_d);
        TrappistDimensions.TRAPPIST_1E = WorldUtil.getDimensionTypeById((int)ConfigPlanets.id_trap_e);
        Kepler1649Dimensions.KEPLER1649_C = WorldUtil.getDimensionTypeById((int)ConfigPlanets.id_kepler_c);
        proxy.postInit(REGISTRY, event);
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent event) {
    }

    @Mod.EventHandler
    public void onFingerprintViolation(FMLFingerprintViolationEvent event) {
        if (!MCUtil.isDeobfuscated()) {
            logger.warn("Invalid fingerprint detected! The file " + event.getSource().getName() + " may have been tampered with. This version will NOT be supported by the author!");
        } else {
            logger.info("Ignoring fingerprint signing since we are in a Development Environment");
        }
    }

    static {
        REGISTRY = new StellarRegistry();
        translate = new TranslateUtil("exoplanets");
        logger = new LogHelper();
        location = new ResourceLocation("exoplanets");
        random = new Random();
        isDevBuild = MCUtil.isDeobfuscated();
        FluidRegistry.enableUniversalBucket();
    }
}

