/*
 * Decompiled with CFR 0.152.
 */
package net.rom.exoplanets;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.rom.exoplanets.ExoplanetsMod;
import net.rom.exoplanets.conf.ConfigCore;

public class Assets {
    private static final String DOMAIN = "exoplanets";
    public static Map<String, ResourceLocation> textures = new HashMap<String, ResourceLocation>();
    public static Map<String, ResourceLocation> spaceTextures = new HashMap<String, ResourceLocation>();
    public static Map<String, ResourceLocation[]> textureGroups = new HashMap<String, ResourceLocation[]>();
    private static Map<String, SoundEvent> sounds = new HashMap<String, SoundEvent>();

    private Assets() {
    }

    public static void addTexture(String name, String domain, String path) {
        name = name.toLowerCase();
        textures.put(name, new ResourceLocation(domain, path));
    }

    public static void addTexture(String name, String path) {
        name = name.toLowerCase();
        textures.put(name, new ResourceLocation(DOMAIN, path));
    }

    public static void addCelestialTexture(String name, String systemName) {
        systemName = systemName.toLowerCase();
        String path = "textures/celestialbodies/" + systemName + "/" + name + ".png";
        spaceTextures.put(name, new ResourceLocation(DOMAIN, path));
    }

    public static void addRealisticCelestialTexture(String name, String systemName) {
        systemName = systemName.toLowerCase();
        String planetName = name.replace("real", "");
        String path = "textures/celestialbodies/" + systemName + "/realism/" + planetName + ".png";
        spaceTextures.put(name, new ResourceLocation(DOMAIN, path));
    }

    public static ResourceLocation getTexture(String name) {
        if (!textures.containsKey(name = name.toLowerCase())) {
            return null;
        }
        return textures.get(name);
    }

    public static ResourceLocation getCelestialTexture(String name) {
        if (!ConfigCore.enableRealism) {
            return Assets.getCelestial(name);
        }
        return Assets.getRealistic("real" + name);
    }

    private static ResourceLocation getCelestial(String name) {
        if (!spaceTextures.containsKey(name = name.toLowerCase())) {
            ExoplanetsMod.logger.error("Cannot assign texture " + name + " as it does not exist");
            return null;
        }
        return spaceTextures.get(name);
    }

    private static ResourceLocation getRealistic(String name) {
        if (!spaceTextures.containsKey(name = name.toLowerCase())) {
            ExoplanetsMod.logger.error("Cannot assign texture " + name + " as it does not exist");
            return null;
        }
        return spaceTextures.get(name);
    }
}

