/*
 * Decompiled with CFR 0.152.
 */
package net.rom.api.space;

import asmodeuscore.api.dimension.IAdvancedSpace;
import asmodeuscore.core.astronomy.BodiesRegistry;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import micdoodle8.mods.galacticraft.api.GalacticraftRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.Moon;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import micdoodle8.mods.galacticraft.api.galaxies.SolarSystem;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.AtmosphereInfo;
import micdoodle8.mods.galacticraft.api.world.EnumAtmosphericGas;
import micdoodle8.mods.galacticraft.api.world.ITeleportType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.biome.Biome;
import net.rom.api.space.ExoPlanet;
import net.rom.api.space.ExoStar;
import net.rom.api.space.ExoSystem;
import net.rom.exoplanets.Assets;

public class Universe {
    public static List<ExoSystem> enabledSystems = new ArrayList<ExoSystem>();

    public static ExoStar buildExoStar(String starName, int temp, double mass, double radius) {
        ExoStar star = new ExoStar(starName);
        star.setStarName(starName);
        star.setSurfaceTemp(temp);
        star.setStarMass(mass);
        star.setStarRadius(radius);
        star.setSpectralClass();
        return star;
    }

    public static ExoSystem buildSolarSystem(String name, ExoStar exoStar, Vector3 pos) {
        ExoSystem body = new ExoSystem(name, "milky_way");
        exoStar.setParentSolarSystem(body);
        body.setMainStar(exoStar);
        body.setMapPosition(pos);
        exoStar.setBodyIcon(Assets.getCelestialTexture(exoStar.getName()));
        return body;
    }

    public static void registerProvider(String name, int id, int staticId, Class<? extends WorldProvider> provider) {
        GalacticraftRegistry.registerDimension((String)name, (String)("_" + name.toLowerCase()), (int)staticId, provider, (boolean)true);
    }

    public static void registerProvider(String name, int id, Class<? extends WorldProvider> provider) {
        GalacticraftRegistry.registerDimension((String)name, (String)("_" + name.toLowerCase()), (int)id, provider, (boolean)false);
    }

    public static void registerSolarSystem(SolarSystem solarSystem) {
        GalaxyRegistry.registerSolarSystem((SolarSystem)solarSystem);
    }

    public static void registerPlanet(Planet planet) {
        GalaxyRegistry.registerPlanet((Planet)planet);
    }

    public static void registerMoon(Moon moon) {
        GalaxyRegistry.registerMoon((Moon)moon);
    }

    public static void registerTeleportType(Class<? extends WorldProvider> clazz, ITeleportType type) {
        GalacticraftRegistry.registerTeleportType(clazz, (ITeleportType)type);
    }

    public static void registerRocketGui(Class<? extends WorldProvider> clazz, String planetString) {
        GalacticraftRegistry.registerRocketGui(clazz, (ResourceLocation)new ResourceLocation("exoplanets", "textures/gui/rocketgui/" + planetString + ".png"));
    }

    public static class ExoPlanetBuilder {
        private static ExoPlanet planet;

        ExoPlanetBuilder(ExoPlanet planet) {
            ExoPlanetBuilder.planet = planet;
        }

        public static Builder build(ExoPlanet planet) {
            new ExoPlanetBuilder(planet);
            return new Builder();
        }

        public static ExoPlanet build(float phaseShift, int tier, float temp, double windLevel, EnumAtmosphericGas[] gasses, Biome[] biomes, IAdvancedSpace.ClassBody clazz, float eccentricityX, float eccentricityY, float orbitOffsetX, float orbitOffsetY, double gravity, long dayLength) {
            planet.setPhaseShift(phaseShift);
            planet.setRelativeSize(1.0f);
            planet.setTierRequired(tier);
            planet.setBodyIcon(Assets.getCelestialTexture(planet.getName()));
            planet.setTierRequired(tier);
            planet.setPlanetTemp(temp);
            planet.setBiomeInfo(biomes);
            planet.setClassBody(clazz);
            planet.setPlanetGravity((float)gravity);
            planet.setDayLength(dayLength);
            planet.setOrbitEccentricity(eccentricityX, eccentricityY);
            planet.setOrbitOffset(orbitOffsetX, orbitOffsetY);
            ExoPlanetBuilder.setAtmosphere(temp, windLevel, gasses);
            BodiesRegistry.setOrbitData((CelestialBody)planet, (float)phaseShift, (float)1.0f, (float)((float)planet.getOrbitPeriod()));
            return planet;
        }

        public static ExoPlanet build(float phaseShift, int tier, float temp, double windLevel, EnumAtmosphericGas[] gasses, Biome[] biomes, IAdvancedSpace.ClassBody clazz, double gravity, long dayLength) {
            planet.setPhaseShift(phaseShift);
            planet.setRelativeSize(1.0f);
            planet.setTierRequired(tier);
            planet.setBodyIcon(Assets.getCelestialTexture(planet.getName()));
            planet.setTierRequired(tier);
            planet.setBiomeInfo(biomes);
            planet.setPlanetTemp(temp);
            planet.setClassBody(clazz);
            planet.setPlanetGravity((float)gravity);
            planet.setDayLength(dayLength);
            ExoPlanetBuilder.setAtmosphere(temp, windLevel, gasses);
            BodiesRegistry.setOrbitData((CelestialBody)planet, (float)phaseShift, (float)1.0f, (float)((float)planet.getOrbitPeriod()));
            return planet;
        }

        public static ExoPlanet build(float phaseShift) {
            planet.setBodyIcon(Assets.getCelestialTexture(planet.getExoPlanetName()));
            planet.setPhaseShift(phaseShift);
            planet.setRelativeSize(1.0f);
            planet.setRingColorRGB(0.8f, 0.0f, 0.0f);
            planet.setUnreachable();
            return planet;
        }

        private static void setAtmosphere(double relativeTemp, double windLevel, EnumAtmosphericGas ... gasses) {
            boolean canBreathe = false;
            boolean canRain = false;
            boolean isCorr = false;
            float d = 0.0f;
            for (EnumAtmosphericGas enumAtmosphericGas : gasses) {
                d += 1.0f;
                planet.atmosphereComponent(enumAtmosphericGas);
                if (enumAtmosphericGas == EnumAtmosphericGas.OXYGEN) {
                    canBreathe = true;
                }
                if (enumAtmosphericGas == EnumAtmosphericGas.CO2) {
                    canRain = true;
                }
                if (enumAtmosphericGas != EnumAtmosphericGas.METHANE) continue;
                isCorr = true;
            }
            planet.setAtmosphere(new AtmosphereInfo(Boolean.valueOf(canBreathe), canRain, isCorr, (float)relativeTemp, (float)windLevel, d));
        }

        public static class Builder {
            private float phaseShift;
            private int tier;
            private float temp;
            private float windLevel;
            private EnumAtmosphericGas[] gasses;
            private Biome[] biomes;
            private boolean normalOrbit = true;
            private float eccentricityX;
            private float eccentricityY;
            private float orbitOffsetX;
            private float orbitOffsetY;
            private IAdvancedSpace.ClassBody clazz;
            private double gravity;
            private long dayLength;
            private boolean unreachable;

            public Builder unreachable(boolean unreachable) {
                this.unreachable = unreachable;
                return this;
            }

            public Builder gravity(double gravity) {
                this.gravity = gravity;
                return this;
            }

            public Builder dayLength(long dayLength) {
                this.dayLength = dayLength;
                return this;
            }

            public Builder eccentricities(float eccentricityX, float eccentricityY) {
                this.eccentricityX = eccentricityX;
                this.eccentricityY = eccentricityY;
                return this;
            }

            public Builder orbitOffsets(float orbitOffsetX, float orbitOffsetY) {
                this.orbitOffsetX = orbitOffsetX;
                this.orbitOffsetY = orbitOffsetY;
                return this;
            }

            public Builder clazz(IAdvancedSpace.ClassBody clazz) {
                this.clazz = clazz;
                return this;
            }

            public Builder normalOrbit(boolean normalOrbit) {
                this.normalOrbit = normalOrbit;
                return this;
            }

            public Builder phaseShift(float phaseShift) {
                this.phaseShift = phaseShift;
                return this;
            }

            public Builder tier(int tier) {
                this.tier = tier;
                return this;
            }

            public Builder tempWind(float temp, float windLevel) {
                this.temp = temp;
                this.windLevel = windLevel;
                return this;
            }

            public Builder gasses(EnumAtmosphericGas ... gasses) {
                this.gasses = gasses;
                return this;
            }

            public Builder biomes(Biome ... biomes) {
                this.biomes = biomes;
                return this;
            }

            public ExoPlanet genUnreachable() {
                return ExoPlanetBuilder.build(this.phaseShift);
            }

            public ExoPlanet generate() {
                if (this.unreachable) {
                    return ExoPlanetBuilder.build(this.phaseShift);
                }
                if (!this.normalOrbit) {
                    return ExoPlanetBuilder.build(this.phaseShift, this.tier, this.temp, this.windLevel, this.gasses, this.biomes, this.clazz, this.eccentricityX, this.eccentricityY, this.orbitOffsetX, this.orbitOffsetY, this.gravity, this.dayLength);
                }
                return ExoPlanetBuilder.build(this.phaseShift, this.tier, this.temp, this.windLevel, this.gasses, this.biomes, this.clazz, this.gravity, this.dayLength);
            }

            @Generated
            public float getPhaseShift() {
                return this.phaseShift;
            }

            @Generated
            public int getTier() {
                return this.tier;
            }

            @Generated
            public float getTemp() {
                return this.temp;
            }

            @Generated
            public float getWindLevel() {
                return this.windLevel;
            }

            @Generated
            public EnumAtmosphericGas[] getGasses() {
                return this.gasses;
            }

            @Generated
            public Biome[] getBiomes() {
                return this.biomes;
            }

            @Generated
            public boolean isNormalOrbit() {
                return this.normalOrbit;
            }

            @Generated
            public float getEccentricityX() {
                return this.eccentricityX;
            }

            @Generated
            public float getEccentricityY() {
                return this.eccentricityY;
            }

            @Generated
            public float getOrbitOffsetX() {
                return this.orbitOffsetX;
            }

            @Generated
            public float getOrbitOffsetY() {
                return this.orbitOffsetY;
            }

            @Generated
            public IAdvancedSpace.ClassBody getClazz() {
                return this.clazz;
            }

            @Generated
            public double getGravity() {
                return this.gravity;
            }

            @Generated
            public long getDayLength() {
                return this.dayLength;
            }

            @Generated
            public boolean isUnreachable() {
                return this.unreachable;
            }
        }
    }
}

