/*
 * Decompiled with CFR 0.152.
 */
package net.rom.api.space;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.rom.api.space.ExoStar;
import net.rom.api.space.RelayStation;

public class ExoRegistry {
    static int maxRelayID = 0;
    static TreeMap<String, RelayStation> relays = Maps.newTreeMap();
    static BiMap<String, Integer> relayIDs = HashBiMap.create();
    static HashMap<CelestialBody, List<RelayStation>> relayList = Maps.newHashMap();

    private ExoRegistry() {
    }

    public static RelayStation getRelayStationFromDimensionID(int dimensionID) {
        for (RelayStation relay : relays.values()) {
            if (relay.getDimensionID() != dimensionID) continue;
            return relay;
        }
        return null;
    }

    public static void refreshGalaxies() {
        relayList.clear();
        for (RelayStation relay : ExoRegistry.getRegisteredRelayStations().values()) {
            ExoStar body = relay.getParent();
            List<RelayStation> listOfRelayStations = relayList.get(body);
            if (listOfRelayStations == null) {
                listOfRelayStations = new ArrayList<RelayStation>();
            }
            listOfRelayStations.add(relay);
            relayList.put((CelestialBody)body, listOfRelayStations);
        }
    }

    public static List<RelayStation> getRelayStationsForCelestialBody(CelestialBody celestialBody) {
        List<RelayStation> relayStationList1 = relayList.get(celestialBody);
        if (relayStationList1 == null) {
            return new ArrayList<RelayStation>();
        }
        return ImmutableList.copyOf(relayStationList1);
    }

    public static CelestialBody getCelestialBodyFromUnlocalizedName(String unlocalizedName) {
        for (RelayStation relay : relays.values()) {
            if (!relay.getUnlocalizedName().equals(unlocalizedName)) continue;
            return relay;
        }
        return null;
    }

    public static Map<String, RelayStation> getRegisteredRelayStations() {
        return (Map)relays.clone();
    }

    public static Map<String, Integer> getRegisteredRelayStationIDs() {
        return ImmutableMap.copyOf(relayIDs);
    }

    public static int getRelayStationID(String relayStationName) {
        return (Integer)relayIDs.get((Object)relayStationName);
    }

    public static boolean registerRelayStation(RelayStation relayStation) {
        if (relayIDs.containsKey((Object)relayStation.getName())) {
            return false;
        }
        relays.put(relayStation.getName(), relayStation);
        relayIDs.put((Object)relayStation.getName(), (Object)(++maxRelayID));
        MinecraftForge.EVENT_BUS.post((Event)new RelayStationRegisterEvent(relayStation.getName(), maxRelayID));
        return true;
    }

    public static class RelayStationRegisterEvent
    extends Event {
        public final String relayStationName;
        public final int relayStationID;

        public RelayStationRegisterEvent(String relayStationName, int relayStationID) {
            this.relayStationName = relayStationName;
            this.relayStationID = relayStationID;
        }
    }
}

