/*
 * Decompiled with CFR 0.152.
 */
package net.rom.api.space;

import asmodeuscore.api.dimension.IAdvancedSpace;
import asmodeuscore.api.space.IExBody;
import java.util.ArrayList;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import micdoodle8.mods.galacticraft.api.galaxies.Star;
import micdoodle8.mods.galacticraft.api.world.AtmosphereInfo;
import micdoodle8.mods.galacticraft.api.world.EnumAtmosphericGas;
import net.rom.api.space.ExoSystem;
import net.rom.api.space.impl.IExoPlanet;
import net.rom.exoplanets.internal.Calculations;
import net.rom.exoplanets.internal.enums.EnumPlanetType;
import net.rom.exoplanets.internal.enums.EnumTPHClass;

public class ExoPlanet
extends Planet
implements IExoPlanet,
IExBody {
    private EnumTPHClass habibilityClass;
    private EnumPlanetType planetType;
    private String exoplanetName;
    private Star planetHost;
    private ExoSystem planetSystem;
    private double orbitPeriod;
    private double distanceFromCenter;
    private double planetMass;
    private double planetRadius;
    private double planetTemp;
    private double gravity;
    private long dayLength;
    private boolean breathable;
    private boolean rains;
    private AtmosphereInfo atmos;
    private ArrayList<EnumAtmosphericGas> atmosGasses = new ArrayList();
    private IAdvancedSpace.ClassBody classBody;
    private float orbit_eccentricityX;
    private float orbit_eccentricityY;
    private float orbit_offsetX;
    private float orbit_offsetY;

    public ExoPlanet(String planetName) {
        super(planetName.toLowerCase());
        this.setExoPlanetName(planetName);
        this.setAtmos();
        this.addChecklistKeys(new String[]{"thermal_padding", "equip_oxygen_suit", "equip_parachute"});
        this.setPlanetType();
        this.setTHPClass();
    }

    public ExoPlanet getExoPlanet() {
        return this;
    }

    public ExoPlanet setTHPClass() {
        this.habibilityClass = Calculations.getTPHFromTemp(this.getPlanetTemp());
        return this;
    }

    public ExoPlanet setPlanetType() {
        this.planetType = Calculations.getPlanetType(this.getPlanetMass(), this.getPlanetRadius());
        return this;
    }

    public ExoPlanet setPlanetHost(Star planetHost) {
        this.planetHost = planetHost;
        return this;
    }

    public ExoPlanet setPlanetSystem(ExoSystem planetSystem) {
        this.planetSystem = planetSystem;
        this.setParentSolarSystem(planetSystem);
        return this;
    }

    public ExoPlanet setDayLength(long dayLength) {
        this.dayLength = dayLength;
        return this;
    }

    public ExoPlanet setPlanetGravity(float gravity) {
        this.gravity = gravity;
        return this;
    }

    public ExoPlanet setOrbitPeriod(float orbitPeriod) {
        this.orbitPeriod = orbitPeriod;
        return this;
    }

    public ExoPlanet setDistanceFromCenter(float par1, float par2) {
        this.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(par1, par2));
        return this;
    }

    public ExoPlanet setDistanceFromCenter(float par1) {
        this.setDistanceFromCenter(par1, par1);
        return this;
    }

    public ExoPlanet setPlanetMass(double planetMass) {
        this.planetMass = planetMass;
        return this;
    }

    public ExoPlanet setPlanetRadius(double planetRadius) {
        this.planetRadius = planetRadius;
        return this;
    }

    public Planet setPlanetTemp(double planetTemp) {
        this.planetTemp = planetTemp;
        return this;
    }

    public ExoPlanet setBreathable(boolean breathable) {
        this.breathable = breathable;
        return this;
    }

    public Planet setRains(boolean rains) {
        this.rains = rains;
        return this;
    }

    public Planet setAtmos() {
        this.atmos = this.setAtmos(new AtmosphereInfo(Boolean.valueOf(this.isBreathable()), this.isDoesRain(), this.isCorrosive(this.habibilityClass), 0.0f, 0.0f, 0.0f));
        return this;
    }

    public boolean isCorrosive(EnumTPHClass tphClass) {
        boolean cor = false;
        if (tphClass == EnumTPHClass.T) {
            cor = true;
            return cor;
        }
        return cor;
    }

    public Planet setAtmosGasses(EnumAtmosphericGas ... gasses) {
        for (EnumAtmosphericGas gas : this.atmosGasses) {
            if (gas == null) continue;
            this.atmosphereComponent(gas);
            this.atmosGasses.add(gas);
        }
        return this;
    }

    public ExoPlanet setExoPlanetName(String name) {
        this.exoplanetName = name;
        return this;
    }

    @Override
    public String getExoPlanetName() {
        return this.exoplanetName;
    }

    @Override
    public ExoSystem getPlanetSystem() {
        return this.planetSystem;
    }

    @Override
    public Star getPlanetHost() {
        return this.planetHost;
    }

    @Override
    public EnumTPHClass getTphClass() {
        return this.habibilityClass;
    }

    @Override
    public EnumPlanetType getPlanetType() {
        return this.planetType;
    }

    @Override
    public double getOrbitPeriod() {
        return this.orbitPeriod;
    }

    @Override
    public float getGravity() {
        return (float)this.gravity;
    }

    @Override
    public double getPlanetMass() {
        return this.planetMass;
    }

    @Override
    public double getPlanetRadius() {
        return this.planetRadius;
    }

    @Override
    public double getPlanetTemp() {
        return this.planetTemp;
    }

    @Override
    public boolean isBreathable() {
        return this.breathable;
    }

    @Override
    public boolean isDoesRain() {
        return this.rains;
    }

    @Override
    public AtmosphereInfo getAtmos() {
        return null;
    }

    @Override
    public long getDayLength() {
        return this.dayLength;
    }

    @Override
    public ArrayList<EnumAtmosphericGas> getAtmosGasses() {
        return null;
    }

    public float getAtmosphericPressure() {
        return 0.0f;
    }

    public float getSolarRadiationMod() {
        return 0.0f;
    }

    public ExoPlanet setClassBody(IAdvancedSpace.ClassBody classBody) {
        this.classBody = classBody;
        return this;
    }

    public IAdvancedSpace.ClassBody getClassPlanet() {
        return this.classBody;
    }

    public double getDistanceFromCenter() {
        return this.distanceFromCenter;
    }

    public AtmosphereInfo getAtmosphereInfo() {
        return this.atmos;
    }

    public AtmosphereInfo setAtmos(AtmosphereInfo atmos) {
        this.atmos = atmos;
        return this.atmos;
    }

    public void setAtmosphericPressure(int pressure) {
    }

    public ExoPlanet setOrbitEccentricity(float eccentricityX, float eccentricityY) {
        this.orbit_eccentricityX = eccentricityX;
        this.orbit_eccentricityY = eccentricityY;
        return this;
    }

    public ExoPlanet setOrbitOffset(float x, float y) {
        this.orbit_offsetX = x;
        this.orbit_offsetY = y;
        return this;
    }

    public float getXOrbitEccentricity() {
        return this.orbit_eccentricityX;
    }

    public float getYOrbitEccentricity() {
        return this.orbit_eccentricityY;
    }

    public float getXOrbitOffset() {
        return this.orbit_offsetX;
    }

    public float getYOrbitOffset() {
        return this.orbit_offsetY;
    }

    public float getWaterPressure() {
        return 0.0f;
    }
}

