/*
 * Decompiled with CFR 0.152.
 */
package net.rom.api.research;

import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.rom.api.research.IResearch;
import net.rom.api.research.Research;

public class Researches {
    private static final int MIN_research_BIT = 0;
    private static final int MAX_research_IDS = Short.MAX_VALUE;
    public final Random random;
    private final BitSet bitSet = new BitSet(Short.MAX_VALUE);
    private final Map<Integer, IResearch> researchMap = new HashMap<Integer, IResearch>();
    private final Map<IResearch, Integer> researchIntegerMap = new HashMap<IResearch, Integer>();
    private final Map<String, IResearch> stringResearchMap = new HashMap<String, IResearch>();

    public Researches() {
        this.random = new Random();
    }

    public IResearch getResearchWithID(int researchID) {
        return this.researchMap.get(researchID);
    }

    public int getResearchID(IResearch research) {
        return this.researchIntegerMap.get(research);
    }

    public IResearch getResearchByName(String name) {
        return this.stringResearchMap.get(name);
    }

    public void registerResearch(String name, Research research) {
        if (this.researchIntegerMap.containsKey(research)) {
            throw new RuntimeException(name + " Research is already registered");
        }
        int id = this.bitSet.nextClearBit(0);
        this.researchMap.put(id, research);
        this.researchIntegerMap.put(research, id);
        this.stringResearchMap.put(name, research);
        this.bitSet.set(id, true);
    }

    public void registerResearchAt(Integer id, String name, IResearch research) {
        this.researchMap.put(id, research);
        this.researchIntegerMap.put(research, id);
        this.bitSet.set((int)id, true);
        this.stringResearchMap.put(name, research);
    }

    public Set<String> getAllResearchName() {
        return this.stringResearchMap.keySet();
    }
}

