/*
 * Decompiled with CFR 0.152.
 */
package net.rom.api.research;

import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.rom.api.research.IResearch;
import net.rom.api.research.IResearchReward;

public class ResearchStack {
    boolean completed;
    private NBTTagCompound tagCompound;
    private UUID giverUniqueID;
    private Entity giver;
    private IResearch research;

    ResearchStack() {
    }

    public ResearchStack(IResearch research, Entity giver) {
        this.research = research;
        if (giver != null) {
            this.giverUniqueID = giver.func_110124_au();
        }
        this.giver = giver;
    }

    public ResearchStack(IResearch research) {
        this.research = research;
    }

    public static ResearchStack loadFromNBT(NBTTagCompound tagCompound) {
        if (tagCompound != null) {
            ResearchStack researchStack = new ResearchStack();
            researchStack.readFromNBT(tagCompound);
            return researchStack;
        }
        return null;
    }

    public static boolean canComplete(EntityPlayer entityPlayer, ResearchStack researchStack) {
        for (int i = 0; i < researchStack.getObjectivesCount(entityPlayer); ++i) {
            if (researchStack.isObjectiveCompleted(entityPlayer, i)) continue;
            return false;
        }
        return true;
    }

    public void writeToNBT(NBTTagCompound tagCompound) {
        if (this.tagCompound != null) {
            tagCompound.func_74782_a("Data", (NBTBase)this.tagCompound);
        }
        if (this.giverUniqueID != null) {
            tagCompound.func_74772_a("giveIdLow", this.giverUniqueID.getLeastSignificantBits());
            tagCompound.func_74772_a("giveIdHigh", this.giverUniqueID.getMostSignificantBits());
        }
        tagCompound.func_74777_a("Research", (short)0);
        tagCompound.func_74757_a("Completed", this.completed);
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
        if (tagCompound.func_150297_b("Data", 10)) {
            this.tagCompound = tagCompound.func_74775_l("Data");
        }
        if (tagCompound.func_150297_b("giveIdLow", 4) && tagCompound.func_150297_b("giveIdHigh", 4)) {
            this.giverUniqueID = new UUID(tagCompound.func_74763_f("giveIdLow"), tagCompound.func_74763_f("giveIdHigh"));
        }
        if (tagCompound.func_150297_b("Research", 2)) {
            // empty if block
        }
        this.completed = tagCompound.func_74767_n("Completed");
    }

    public String getTitle() {
        return this.research.getTitle(this);
    }

    public int getXP(EntityPlayer entityPlayer) {
        return this.research.getXpReward(this, entityPlayer);
    }

    public String getTitle(EntityPlayer entityPlayer) {
        return this.research.getTitle(this, entityPlayer);
    }

    public String getInfo(EntityPlayer entityPlayer) {
        return this.research.getInfo(this, entityPlayer);
    }

    public String getObjective(EntityPlayer entityPlayer, int objectiveIndex) {
        return this.research.getObjective(this, entityPlayer, objectiveIndex);
    }

    public int getObjectivesCount(EntityPlayer entityPlayer) {
        return this.research.getObjectivesCount(this, entityPlayer);
    }

    public boolean isObjectiveCompleted(EntityPlayer entityPlayer, int objectiveID) {
        return this.research.isObjectiveCompleted(this, entityPlayer, objectiveID);
    }

    public Entity getGiver() {
        return this.giver;
    }

    public void setGiver(Entity entity) {
        this.giver = entity;
        this.giverUniqueID = this.giver.func_110124_au();
    }

    public boolean isGiver(Entity entity) {
        if (this.giver != null && this.giver == entity) {
            return true;
        }
        return this.giverUniqueID != null && entity.func_110124_au().equals(this.giverUniqueID);
    }

    public boolean hasGiver() {
        if (this.getGiver() != null) {
            return true;
        }
        return this.giverUniqueID != null;
    }

    public void addRewards(List<IResearchReward> rewards, EntityPlayer entityPlayer) {
        this.research.addToRewards(this, entityPlayer, rewards);
    }

    public IResearch getResearch() {
        return this.research;
    }

    public NBTTagCompound getTagCompound() {
        return this.tagCompound;
    }

    public void setTagCompound(NBTTagCompound tagCompound) {
        this.tagCompound = tagCompound;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public void markCompleted(EntityPlayer entityPlayer, boolean force) {
        if (force) {
            this.completed = true;
        } else {
            this.research.setCompleted(this, entityPlayer);
        }
    }

    public ResearchStack copy() {
        ResearchStack researchStack = new ResearchStack(this.research);
        researchStack.giverUniqueID = this.giverUniqueID;
        researchStack.giver = this.giver;
        if (this.getTagCompound() != null) {
            researchStack.setTagCompound(this.getTagCompound().func_74737_b());
        }
        return researchStack;
    }

    public ItemStack getResearchPaper() {
        ItemStack researchPaper = null;
        NBTTagCompound researchTag = new NBTTagCompound();
        this.writeToNBT(researchTag);
        researchPaper.func_77982_d(researchTag);
        return researchPaper;
    }

    public boolean canAccept(EntityPlayer entityPlayer, ResearchStack researchStack) {
        return this.research.canBeAccepted(researchStack, entityPlayer);
    }
}

