/*
 * Decompiled with CFR 0.152.
 */
package net.rom.api.research;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.rom.api.research.IResearch;
import net.rom.api.research.IResearchReward;
import net.rom.api.research.ResearchStack;
import net.rom.exoplanets.research.utils.JsonUtil;

public abstract class Research
implements IResearch {
    protected String title;
    protected int xpReward;
    protected List<IResearchReward> researchRewards;
    public Random random;

    public Research(String title, JsonObject jsonObject) {
        this.title = title;
        this.xpReward = JsonUtil.getInt(jsonObject, "xp", 0);
        this.researchRewards = new ArrayList<IResearchReward>();
    }

    public Research(String title, int xpReward) {
        this.title = title;
        this.xpReward = xpReward;
        this.researchRewards = new ArrayList<IResearchReward>();
    }

    public static IResearch getResearchFromName(String name) {
        return null;
    }

    @Override
    public String getName() {
        return this.title;
    }

    @Override
    public String getTitle(ResearchStack researchStack) {
        return this.title;
    }

    @Override
    public String getTitle(ResearchStack researchStack, EntityPlayer entityPlayer) {
        return this.getTitle(researchStack);
    }

    public Research addResearchRewards(IResearchReward ... researchRewards) {
        Collections.addAll(this.researchRewards, researchRewards);
        return this;
    }

    public Research addResearchRewards(List<IResearchReward> rewards) {
        this.researchRewards.addAll(rewards);
        return this;
    }

    @Override
    public void setCompleted(ResearchStack researchStack, EntityPlayer entityPlayer) {
        researchStack.completed = true;
    }

    public abstract IResearch getResearchByName(String var1);
}

