/*
 * Decompiled with CFR 0.152.
 */
package net.rom.api.crafting.recipe.alloyrefinery;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.rom.exoplanets.internal.StackHelper;

public class AlloyRefineryRecipeObject {
    public static final String ITEM_KEY_SPLITTER = "\\*";
    private List<String> itemKeys = Lists.newArrayList();
    private List<ItemStack> possibleStacks = Lists.newArrayList();

    public static AlloyRefineryRecipeObject[] getFromObjectArray(Object ... objects) {
        ArrayList list = Lists.newArrayList();
        for (Object obj : objects) {
            list.add(AlloyRefineryRecipeObject.from(obj));
        }
        return list.toArray(new AlloyRefineryRecipeObject[0]);
    }

    public AlloyRefineryRecipeObject(String oreName, int count) {
        this(oreName + "*" + count);
    }

    public AlloyRefineryRecipeObject(String ... itemKeys) {
        for (String itemKey : itemKeys) {
            this.itemKeys.add(itemKey);
            this.possibleStacks.addAll(this.getStacksFromKey(itemKey));
        }
    }

    public AlloyRefineryRecipeObject(ItemStack ... stacks) {
        this.possibleStacks.addAll(Arrays.asList(stacks));
    }

    public static AlloyRefineryRecipeObject from(Object obj) {
        if (obj instanceof String) {
            return new AlloyRefineryRecipeObject((String)obj);
        }
        if (obj instanceof ItemStack) {
            return new AlloyRefineryRecipeObject((ItemStack)obj);
        }
        if (obj instanceof AlloyRefineryRecipeObject) {
            return (AlloyRefineryRecipeObject)obj;
        }
        throw new IllegalArgumentException("AlloyRefineryRecipeObject: don't know how to use object of type " + obj.getClass());
    }

    public boolean matches(ItemStack inputStack) {
        return this.getMatchingStack(inputStack) != null;
    }

    public ItemStack getMatchingStack(ItemStack inputStack) {
        if (inputStack.func_190926_b()) {
            return null;
        }
        for (ItemStack recipeStack : this.possibleStacks) {
            if (recipeStack.func_190926_b() || !inputStack.func_77969_a(recipeStack) || inputStack.func_190916_E() < recipeStack.func_190916_E()) continue;
            return recipeStack.func_77946_l();
        }
        return null;
    }

    public List<String> getItemKeys() {
        return Lists.newArrayList(this.itemKeys);
    }

    public List<ItemStack> getPossibleItemStacks() {
        return Lists.newArrayList(this.possibleStacks);
    }

    private List<ItemStack> getStacksFromKey(String key) {
        String[] parts = key.split(ITEM_KEY_SPLITTER);
        if (parts.length != 2) {
            throw new IllegalArgumentException("Item key must be in the format \"oreName*count\".");
        }
        String oreName = parts[0];
        int stackSize = Integer.parseInt(parts[1]);
        if (stackSize < 0) {
            throw new IllegalArgumentException("Item count must greater than zero!");
        }
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (ItemStack stack : StackHelper.getOres(oreName)) {
            ItemStack copy = stack.func_77946_l();
            copy.func_190920_e(stackSize);
            result.add(copy);
        }
        return result;
    }
}

