/*
 * Decompiled with CFR 0.152.
 */
package net.rom.api.crafting.recipe.alloyrefinery;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.rom.api.crafting.recipe.alloyrefinery.AlloyRefineryRecipeObject;

public class AlloyRefineryRecipe {
    public static final List<AlloyRefineryRecipe> ALL_RECIPES = new ArrayList<AlloyRefineryRecipe>();
    private static final Set<AlloyRefineryRecipeObject> ALL_INGREDIENTS = new HashSet<AlloyRefineryRecipeObject>();
    private static final int MAX_INPUTS = 4;
    private final AlloyRefineryRecipeObject[] inputs;
    private final ItemStack output;
    private final int cookTime;
    private final float experience;

    private AlloyRefineryRecipe(ItemStack output, int cookTime, float experience, Object ... inputs) {
        this.inputs = AlloyRefineryRecipeObject.getFromObjectArray(inputs);
        this.output = output;
        this.cookTime = cookTime;
        this.experience = experience;
    }

    public static void addRecipe(ItemStack output, int cookTime, float experience, Object ... inputs) {
        AlloyRefineryRecipe newRecipe = new AlloyRefineryRecipe(output, cookTime, experience, inputs);
        Collections.addAll(ALL_INGREDIENTS, newRecipe.getInputs());
        ALL_RECIPES.add(newRecipe);
    }

    @Nullable
    public static AlloyRefineryRecipe getMatchingRecipe(List<ItemStack> inputList) {
        for (AlloyRefineryRecipe recipe : ALL_RECIPES) {
            if (!recipe.matches(inputList)) continue;
            return recipe;
        }
        return null;
    }

    @Nullable
    public static AlloyRefineryRecipe getRecipeByOutput(ItemStack stack) {
        for (AlloyRefineryRecipe recipe : ALL_RECIPES) {
            if (!recipe.getOutput().func_77969_a(stack)) continue;
            return recipe;
        }
        return null;
    }

    public static boolean isValidIngredient(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        ItemStack copy = stack.func_77946_l();
        copy.func_190920_e(64);
        for (AlloyRefineryRecipeObject recipeObject : ALL_INGREDIENTS) {
            if (!recipeObject.matches(copy)) continue;
            return true;
        }
        return false;
    }

    public boolean matches(List<ItemStack> inputList) {
        int i;
        if (this.inputs.length == 0 || this.output.func_190926_b()) {
            return false;
        }
        boolean[] matches = new boolean[4];
        for (ItemStack inputStack : inputList) {
            for (i = 0; i < this.inputs.length; ++i) {
                if (this.inputs[i] == null) {
                    matches[i] = true;
                    continue;
                }
                if (!this.inputs[i].matches(inputStack)) continue;
                matches[i] = true;
            }
        }
        for (i = this.inputs.length; i < 4; ++i) {
            matches[i] = true;
        }
        for (i = 0; i < 4; ++i) {
            if (matches[i]) continue;
            return false;
        }
        return true;
    }

    public int getCookTime() {
        return this.cookTime;
    }

    public float getExperience() {
        return this.experience;
    }

    public AlloyRefineryRecipeObject[] getInputs() {
        return (AlloyRefineryRecipeObject[])this.inputs.clone();
    }

    public ItemStack getOutput() {
        return this.output.func_77946_l();
    }
}

