/*
 * Decompiled with CFR 0.152.
 */
package net.rom.api;

import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.oredict.OreDictionary;

public class ApiUtil {
    public static boolean compareToOreName(ItemStack stack, String oreName) {
        if (!ApiUtil.isExistingOreName(oreName)) {
            return false;
        }
        NonNullList s = OreDictionary.getOres((String)oreName);
        for (ItemStack st : s) {
            if (!OreDictionary.itemMatches((ItemStack)st, (ItemStack)stack, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    public static boolean isExistingOreName(String name) {
        if (!OreDictionary.doesOreNameExist((String)name)) {
            return false;
        }
        return !OreDictionary.getOres((String)name).isEmpty();
    }

    public static boolean isMetalComponent(ItemStack stack, String componentType) {
        return ApiUtil.getMetalComponentType(stack, componentType) != null;
    }

    public static String getMetalComponentType(ItemStack stack, String ... componentTypes) {
        int[] ids = OreDictionary.getOreIDs((ItemStack)stack);
        String[] oreNames = OreDictionary.getOreNames();
        for (int id : ids) {
            String oreName = oreNames[id];
            for (String componentType : componentTypes) {
                if (!oreName.startsWith(componentType)) continue;
                return componentType;
            }
        }
        return null;
    }

    public static String[] getMetalComponentTypeAndMetal(ItemStack stack, String ... componentTypes) {
        int[] ids = OreDictionary.getOreIDs((ItemStack)stack);
        String[] oreNames = OreDictionary.getOreNames();
        for (int id : ids) {
            String oreName = oreNames[id];
            for (String componentType : componentTypes) {
                if (!oreName.startsWith(componentType)) continue;
                return new String[]{componentType, oreName.substring(componentType.length())};
            }
        }
        return null;
    }

    public static boolean isIngot(ItemStack stack) {
        return ApiUtil.isMetalComponent(stack, "ingot");
    }

    public static boolean isSheet(ItemStack stack) {
        return ApiUtil.isMetalComponent(stack, "sheet");
    }

    public static BlockPos toBlockPos(Object object) {
        if (object instanceof BlockPos) {
            return (BlockPos)object;
        }
        if (object instanceof TileEntity) {
            return ((TileEntity)object).func_174877_v();
        }
        return null;
    }

    public static Ingredient createIngredientFromList(List<ItemStack> list) {
        return Ingredient.func_193369_a((ItemStack[])list.toArray(new ItemStack[list.size()]));
    }

    public static ItemStack copyStackWithAmount(ItemStack stack, int amount) {
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack s2 = stack.func_77946_l();
        s2.func_190920_e(amount);
        return s2;
    }
}

