/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.eplus.gui;

import net.darkhax.bookshelf.lib.EnchantData;
import net.darkhax.bookshelf.util.ModUtils;
import net.darkhax.eplus.EnchantingPlus;
import net.darkhax.eplus.block.tileentity.EnchantmentLogicController;
import net.darkhax.eplus.gui.GuiAdvancedTable;
import net.darkhax.eplus.network.messages.MessageSliderUpdate;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class GuiEnchantmentLabel
extends Gui {
    protected static final ResourceLocation TEXTURE = new ResourceLocation("eplus", "textures/gui/enchant.png");
    private static final int HEIGHT = 18;
    private static final int WIDTH = 143;
    private static final int COLOR_BACKGROUND_LOCKED = 1154549825;
    private static final int COLOR_BACKGROUND_AVAILABLE = 1146793646;
    private final EnchantmentLogicController logic;
    private final Enchantment enchantment;
    private final int initialLevel;
    private int currentLevel;
    private int startingXPos;
    private int startingYPos;
    private int xPos;
    private int yPos;
    private int sliderX;
    private boolean dragging = false;
    private boolean visible = true;
    private boolean locked = false;
    public final GuiAdvancedTable parent;

    public GuiEnchantmentLabel(GuiAdvancedTable parent, EnchantmentLogicController logic, Enchantment enchant, int level, int x, int y) {
        this.logic = logic;
        this.parent = parent;
        this.enchantment = enchant;
        this.currentLevel = level;
        this.initialLevel = level;
        this.xPos = this.startingXPos = x;
        this.yPos = this.startingYPos = y;
        this.sliderX = this.xPos + 1;
        if (this.currentLevel > this.enchantment.func_77325_b()) {
            this.locked = true;
        }
    }

    public void draw(FontRenderer font) {
        if (!this.visible) {
            return;
        }
        int indexX = this.dragging ? this.sliderX : (this.currentLevel <= this.enchantment.func_77325_b() ? (int)((double)(this.xPos + 1) + 137.0 * ((double)this.currentLevel / (double)this.enchantment.func_77325_b())) : this.xPos + 1 + 143 - 6);
        GuiEnchantmentLabel.func_73734_a((int)(this.xPos + 1), (int)(this.yPos + 2), (int)(this.xPos + 143), (int)(this.yPos + 18), (int)(this.locked ? 1154549825 : 1146793646));
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.parent.field_146297_k.func_110434_K().func_110577_a(TEXTURE);
        this.func_73729_b(indexX, this.yPos + 2, this.isSelected() ? 5 : 0, 197, 5, 16);
        font.func_78276_b(this.getDisplayName(), this.xPos + 7, this.yPos + 6, 1437269760);
    }

    public boolean isSelected() {
        return this.parent.selected != null && this.parent.selected.enchantment == this.enchantment;
    }

    public String getDisplayName() {
        String s = I18n.func_135052_a((String)this.enchantment.func_77320_a(), (Object[])new Object[0]);
        if (this.enchantment.func_190936_d()) {
            s = TextFormatting.RED + s;
        }
        return this.currentLevel <= 0 ? s : s + " " + I18n.func_135052_a((String)("enchantment.level." + this.currentLevel), (Object[])new Object[0]);
    }

    public void updateSlider(int xPos) {
        if (this.locked) {
            return;
        }
        int min = this.xPos + 1;
        int max = min + 143 - 6;
        this.sliderX = min + xPos - 2;
        if (this.sliderX < min) {
            this.sliderX = min;
        } else if (this.sliderX > max) {
            this.sliderX = max;
        }
        float index = (float)xPos / 133.0f;
        int updatedLevel = Math.round(this.initialLevel > this.enchantment.func_77325_b() ? (float)this.initialLevel * index : (float)this.enchantment.func_77325_b() * index);
        if (updatedLevel > this.initialLevel || !this.logic.getInventory().getEnchantingStack().func_77951_h()) {
            this.currentLevel = updatedLevel;
        }
        if (this.currentLevel < 0) {
            this.currentLevel = 0;
        } else if (this.currentLevel > this.enchantment.func_77325_b()) {
            this.currentLevel = this.enchantment.func_77325_b();
        }
        EnchantingPlus.NETWORK.sendToServer((IMessage)new MessageSliderUpdate(new EnchantData(this.enchantment, this.currentLevel)));
        this.logic.updateEnchantment(this.enchantment, this.currentLevel);
    }

    public int getCurrentLevel() {
        return this.currentLevel;
    }

    public void setCurrentLevel(int currentLevel) {
        this.currentLevel = currentLevel;
    }

    public int getStartingXPos() {
        return this.startingXPos;
    }

    public void setStartingXPos(int startingXPos) {
        this.startingXPos = startingXPos;
    }

    public int getStartingYPos() {
        return this.startingYPos;
    }

    public void setStartingYPos(int startingYPos) {
        this.startingYPos = startingYPos;
    }

    public int getxPos() {
        return this.xPos;
    }

    public void setxPos(int xPos) {
        this.xPos = xPos;
    }

    public int getyPos() {
        return this.yPos;
    }

    public void setyPos(int yPos) {
        this.yPos = yPos;
    }

    public int getSliderX() {
        return this.sliderX;
    }

    public void setSliderX(int sliderX) {
        this.sliderX = sliderX;
    }

    public boolean isDragging() {
        return this.dragging;
    }

    public void setDragging(boolean dragging) {
        this.dragging = dragging;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public int getWidth() {
        return 143;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public GuiAdvancedTable getParent() {
        return this.parent;
    }

    public void setVisible(boolean isVisible) {
        this.visible = isVisible;
    }

    public int getHeight() {
        return 18;
    }

    public Enchantment getEnchantment() {
        return this.enchantment;
    }

    public int getInitialLevel() {
        return this.initialLevel;
    }

    public boolean isMouseOver(int mouseX, int mouseY) {
        return this.getxPos() <= mouseX && this.getxPos() + this.getWidth() >= mouseX && this.getyPos() <= mouseY && this.getyPos() + this.getHeight() >= mouseY;
    }

    public String getDescription() {
        String key = GuiEnchantmentLabel.getTranslationKey(this.enchantment);
        String description = I18n.func_135052_a((String)key, (Object[])new Object[0]);
        if (description.startsWith("enchantment.")) {
            description = I18n.func_135052_a((String)"tooltip.eplus.missing", (Object[])new Object[]{ModUtils.getModName((IForgeRegistryEntry.Impl)this.enchantment), key});
        }
        return description;
    }

    private static String getTranslationKey(Enchantment enchant) {
        if (enchant != null && enchant.getRegistryName() != null) {
            return String.format("enchantment.%s.%s.desc", enchant.getRegistryName().func_110624_b(), enchant.getRegistryName().func_110623_a());
        }
        return "NULL";
    }
}

