/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.eplus;

import java.util.ArrayList;
import java.util.List;
import net.darkhax.eplus.ConfigurationHandler;
import net.darkhax.eplus.api.Blacklist;
import net.darkhax.eplus.api.event.EnchantmentCostEvent;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public final class EnchLogic {
    public static int EnchantmentSeed;

    public static int calculateNewEnchCost(Enchantment enchantment, int level) {
        int cost = ConfigurationHandler.baseCost;
        cost *= Math.max(11 - enchantment.func_77324_c().func_185270_a(), 1);
        cost *= level;
        cost = (int)((float)cost * ConfigurationHandler.costFactor);
        if (enchantment.func_190936_d()) {
            cost = (int)((float)cost * ConfigurationHandler.curseFactor);
        } else if (enchantment.func_185261_e()) {
            cost = (int)((float)cost * ConfigurationHandler.treasureFactor);
        }
        EnchantmentCostEvent event = new EnchantmentCostEvent(cost, enchantment, level);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getCost();
    }

    public static List<Enchantment> getValidEnchantments(ItemStack stack, World world, BlockPos pos) {
        ArrayList<Enchantment> enchList = new ArrayList<Enchantment>();
        if (!stack.func_190926_b() && (stack.func_77956_u() || stack.func_77948_v())) {
            for (Enchantment enchantment : Enchantment.field_185264_b) {
                if (Blacklist.isEnchantmentBlacklisted(enchantment) || !enchantment.func_92089_a(stack) || enchantment.func_185261_e() && !EnchLogic.isCurse(world, enchantment) && !EnchLogic.isTreasuresAvailable(enchantment, world, pos, pos.func_177977_b())) continue;
                enchList.add(enchantment);
            }
        }
        return enchList;
    }

    public static boolean isCurse(World world, Enchantment enchantment) {
        return enchantment.func_190936_d() && EnchLogic.isWikedNight(world);
    }

    public static boolean isTreasuresAvailable(Enchantment enchantment, World world, BlockPos pos, BlockPos down) {
        if (enchantment.func_190936_d() || !enchantment.func_185261_e() || !world.func_72935_r()) {
            return false;
        }
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                BlockPos currentPos = down.func_177982_a(x, 0, z);
                Block block = world.func_180495_p(currentPos).func_177230_c();
                if (block.isBeaconBase((IBlockAccess)world, currentPos, pos)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isWikedNight(World world) {
        float skyAngle = world.func_72826_c(1.0f);
        boolean isNightRange = (double)skyAngle > 0.4 && (double)skyAngle < 0.6;
        return world.field_73011_w.func_76559_b(world.func_72820_D()) == 0 && isNightRange;
    }

    public static int getExperience(EntityPlayer player) {
        return (int)((float)EnchLogic.getExperienceForLevels(player.field_71068_ca) + player.field_71106_cc * (float)player.func_71050_bK());
    }

    public static void removeExperience(EntityPlayer player, int amount) {
        EnchLogic.addExperience(player, -amount);
    }

    public static void addExperience(EntityPlayer player, int amount) {
        int experience;
        player.field_71067_cb = experience = EnchLogic.getExperience(player) + amount;
        player.field_71068_ca = EnchLogic.getLevelForExperience(experience);
        int expForLevel = EnchLogic.getExperienceForLevels(player.field_71068_ca);
        player.field_71106_cc = (float)(experience - expForLevel) / (float)player.func_71050_bK();
    }

    public static int getExperienceForLevels(int level) {
        if (level == 0) {
            return 0;
        }
        if (level > 0 && level < 17) {
            return level * level + 6 * level;
        }
        if (level > 16 && level < 32) {
            return (int)(2.5 * (double)level * (double)level - 40.5 * (double)level + 360.0);
        }
        return (int)(4.5 * (double)level * (double)level - 162.5 * (double)level + 2220.0);
    }

    public static int getLevelForExperience(int experience) {
        int level = 0;
        while (EnchLogic.getExperienceForLevels(level) <= experience) {
            ++level;
        }
        return level - 1;
    }
}

