/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.nee.utils;

import com.github.vfyjxf.nee.NotEnoughEnergistics;
import com.github.vfyjxf.nee.config.NEEConfig;
import com.github.vfyjxf.nee.utils.StackProcessor;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.gui.IGuiIngredient;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameRegistry;

public final class ItemUtils {
    private static List<StackProcessor> getTransformItemBlacklist() {
        ArrayList<StackProcessor> transformItemBlacklist = new ArrayList<StackProcessor>();
        for (String itemJsonString : NEEConfig.itemBlacklist) {
            String itemName;
            JsonObject jsonObject;
            try {
                jsonObject = new JsonParser().parse(itemJsonString).getAsJsonObject();
            }
            catch (JsonSyntaxException e) {
                NotEnoughEnergistics.logger.error("Found a error item json in transform blacklist : " + itemJsonString);
                continue;
            }
            if (jsonObject == null || (itemName = jsonObject.get("itemName").getAsString()) == null || itemName.isEmpty()) continue;
            int meta = itemJsonString.contains("meta") ? Integer.parseInt(jsonObject.get("meta").getAsString()) : 0;
            String nbtJsonString = itemJsonString.contains("nbt") ? jsonObject.get("nbt").getAsString() : "";
            ItemStack currentStack = GameRegistry.makeItemStack((String)itemName, (int)meta, (int)1, (String)nbtJsonString);
            String recipeType = itemJsonString.contains("recipeType") ? jsonObject.get("name").getAsString() : "";
            transformItemBlacklist.add(new StackProcessor(currentStack, recipeType));
        }
        return transformItemBlacklist;
    }

    private static List<StackProcessor> getTransformItemPriorityList() {
        ArrayList<StackProcessor> transformItemPriorityList = new ArrayList<StackProcessor>();
        for (String itemJsonString : NEEConfig.itemPriorityList) {
            String itemName;
            JsonObject jsonObject;
            try {
                jsonObject = new JsonParser().parse(itemJsonString).getAsJsonObject();
            }
            catch (JsonSyntaxException e) {
                NotEnoughEnergistics.logger.error("Found a error item json in item priority list: " + itemJsonString);
                continue;
            }
            if (jsonObject == null || (itemName = jsonObject.get("itemName").getAsString()) == null || itemName.isEmpty()) continue;
            int meta = itemJsonString.contains("meta") ? Integer.parseInt(jsonObject.get("meta").getAsString()) : 0;
            String nbtJsonString = itemJsonString.contains("nbt") ? jsonObject.get("nbt").getAsString() : "";
            ItemStack currentStack = GameRegistry.makeItemStack((String)itemName, (int)meta, (int)1, (String)nbtJsonString);
            String recipeType = itemJsonString.contains("recipeType") ? jsonObject.get("name").getAsString() : "";
            transformItemPriorityList.add(new StackProcessor(currentStack, recipeType));
        }
        return transformItemPriorityList;
    }

    public static boolean isPreferItems(ItemStack itemStack, String recipeType) {
        if (itemStack == null || itemStack.func_190926_b()) {
            return false;
        }
        ItemStack stack = itemStack.func_77946_l();
        stack.func_190920_e(1);
        for (StackProcessor stackProcessor : ItemUtils.getTransformItemPriorityList()) {
            if (!ItemStack.func_77989_b((ItemStack)stack, (ItemStack)stackProcessor.getCurrentStack())) continue;
            String currentRecipeType = stackProcessor.getRecipeType();
            if (currentRecipeType == null || currentRecipeType.isEmpty()) {
                return true;
            }
            if (!recipeType.equals(currentRecipeType)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPreferItems(ItemStack itemStack) {
        ItemStack stack = itemStack.func_77946_l();
        stack.func_190920_e(1);
        for (StackProcessor stackProcessor : ItemUtils.getTransformItemPriorityList()) {
            if (!ItemStack.func_77989_b((ItemStack)stack, (ItemStack)stackProcessor.getCurrentStack())) continue;
            return true;
        }
        return false;
    }

    public static boolean isInBlackList(ItemStack itemStack, String recipeType) {
        ItemStack stack = itemStack.func_77946_l();
        stack.func_190920_e(1);
        for (StackProcessor stackProcessor : ItemUtils.getTransformItemBlacklist()) {
            if (!ItemStack.func_77989_b((ItemStack)stack, (ItemStack)stackProcessor.getCurrentStack())) continue;
            String currentRecipeType = stackProcessor.getRecipeType();
            if (currentRecipeType == null || currentRecipeType.isEmpty()) {
                return true;
            }
            if (!recipeType.equals(currentRecipeType)) continue;
            return true;
        }
        return false;
    }

    public static ItemStack getPreferModItem(IGuiIngredient<ItemStack> ingredient) {
        for (String currentId : NEEConfig.modPriorityList) {
            for (ItemStack currentIngredient : ingredient.getAllIngredients()) {
                String itemModid = currentIngredient.func_77973_b().getRegistryName().func_110624_b();
                if (!itemModid.equals(currentId)) continue;
                return currentIngredient;
            }
        }
        return ItemStack.field_190927_a;
    }

    public static boolean isPreferModItem(ItemStack stack) {
        for (String currentId : NEEConfig.modPriorityList) {
            String itemModid = stack.func_77973_b().getRegistryName().func_110624_b();
            if (!itemModid.equals(currentId)) continue;
            return true;
        }
        return false;
    }

    public static int getIngredientIndex(ItemStack stack, List<ItemStack> currentIngredients) {
        for (int i = 0; i < currentIngredients.size(); ++i) {
            if (currentIngredients.get(i) == null || !ItemUtils.areItemStacksEqual(stack, currentIngredients.get(i))) continue;
            return i;
        }
        return -1;
    }

    public static boolean areItemStacksEqual(ItemStack stack1, ItemStack stack2) {
        if (stack1 == null && stack2 == null) {
            return true;
        }
        if (stack1 != null && stack2 != null) {
            ItemStack copyStack1 = stack1.func_77946_l();
            ItemStack copyStack2 = stack2.func_77946_l();
            copyStack1.func_190920_e(1);
            copyStack2.func_190920_e(1);
            return ItemStack.func_77989_b((ItemStack)copyStack1, (ItemStack)copyStack2);
        }
        return false;
    }

    public static String toItemJsonString(ItemStack currentStack) {
        String nbtString = currentStack.func_77942_o() ? ",\"nbt\":\"" + currentStack.func_77978_p().toString() + "\"" : "";
        ResourceLocation registryName = currentStack.func_77973_b().getRegistryName();
        int meta = currentStack.func_77952_i();
        return "{\"itemName\":\"" + registryName.toString() + "\",\"meta\":\"" + meta + "\"" + nbtString + "}";
    }

    public static boolean hasModId(String modid) {
        for (String currentId : NEEConfig.modPriorityList) {
            if (!currentId.equals(modid)) continue;
            return true;
        }
        return false;
    }
}

