/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.nee.network.packet;

import appeng.container.AEBaseContainer;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketSlotStackChange
implements IMessage,
IMessageHandler<PacketSlotStackChange, IMessage> {
    private ItemStack stack;
    private List<Integer> slots;

    public PacketSlotStackChange() {
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public List<Integer> getSlots() {
        return this.slots;
    }

    public PacketSlotStackChange(ItemStack stack, List<Integer> craftingSlots) {
        this.stack = stack;
        this.slots = craftingSlots;
    }

    public void fromBytes(ByteBuf buf) {
        this.stack = ByteBufUtils.readItemStack((ByteBuf)buf);
        int craftingSlotsSize = buf.readInt();
        this.slots = new ArrayList<Integer>(craftingSlotsSize);
        for (int i = 0; i < craftingSlotsSize; ++i) {
            int slotNumber = buf.readInt();
            this.slots.add(slotNumber);
        }
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.stack);
        buf.writeInt(this.slots.size());
        for (Integer craftingSlot : this.slots) {
            buf.writeInt(craftingSlot.intValue());
        }
    }

    public IMessage onMessage(PacketSlotStackChange message, MessageContext ctx) {
        EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
        Container container = player.field_71070_bA;
        player.func_71121_q().func_152344_a(() -> {
            ItemStack nextStack;
            if (container instanceof AEBaseContainer && (nextStack = message.getStack()) != null) {
                for (Integer craftingSlot : message.getSlots()) {
                    Slot currentSlot = container.func_75139_a(craftingSlot.intValue());
                    currentSlot.func_75215_d(nextStack);
                }
            }
        });
        return null;
    }
}

