/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.nee.jei;

import appeng.container.implementations.ContainerPatternTerm;
import com.github.vfyjxf.nee.NotEnoughEnergistics;
import com.github.vfyjxf.nee.config.ItemCombination;
import com.github.vfyjxf.nee.config.NEEConfig;
import com.github.vfyjxf.nee.jei.CraftingHelperTooltipError;
import com.github.vfyjxf.nee.network.NEENetworkHandler;
import com.github.vfyjxf.nee.network.packet.PacketRecipeTransfer;
import com.github.vfyjxf.nee.utils.IngredientTracker;
import com.github.vfyjxf.nee.utils.ItemUtils;
import com.github.vfyjxf.nee.utils.StackProcessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.gui.IGuiIngredient;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.gui.recipes.RecipesGui;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PatternRecipeTransferHandler
implements IRecipeTransferHandler<ContainerPatternTerm> {
    public static final String OUTPUT_KEY = "Outputs";
    public static final String INPUT_KEY = "#";
    public static Map<String, List<ItemStack>> ingredients = new HashMap<String, List<ItemStack>>();

    @Nonnull
    public Class<ContainerPatternTerm> getContainerClass() {
        return ContainerPatternTerm.class;
    }

    @Nullable
    public IRecipeTransferError transferRecipe(@Nonnull ContainerPatternTerm container, IRecipeLayout recipeLayout, @Nonnull EntityPlayer player, boolean maxTransfer, boolean doTransfer) {
        String recipeType = recipeLayout.getRecipeCategory().getUid();
        boolean isCraftingRecipe = this.isCraftingRecipe(recipeType);
        if (doTransfer) {
            Map ingredients = recipeLayout.getItemStacks().getGuiIngredients();
            NBTTagCompound recipeInputs = new NBTTagCompound();
            NBTTagCompound recipeOutputs = new NBTTagCompound();
            int inputIndex = 0;
            int outputIndex = 0;
            ArrayList<StackProcessor> tInputs = new ArrayList<StackProcessor>();
            for (Map.Entry entry : ingredients.entrySet()) {
                ItemStack currentStack;
                IGuiIngredient ingredient = (IGuiIngredient)entry.getValue();
                if (ingredient == null) continue;
                ItemStack displayedIngredient = ingredient.getDisplayedIngredient() == null ? ItemStack.field_190927_a : ((ItemStack)ingredient.getDisplayedIngredient()).func_77946_l();
                ItemStack firstIngredient = this.getFirstStack((IGuiIngredient<ItemStack>)ingredient);
                Object object = currentStack = NEEConfig.useDisplayedIngredient && !displayedIngredient.func_190926_b() ? displayedIngredient : firstIngredient;
                if (ingredient.isInput()) {
                    if (isCraftingRecipe) {
                        tInputs.add(new StackProcessor((IGuiIngredient<ItemStack>)ingredient, currentStack, currentStack.func_190916_E()));
                        continue;
                    }
                    boolean find = false;
                    if (currentStack.func_190926_b()) continue;
                    ItemCombination currentValue = ItemCombination.valueOf(NEEConfig.itemCombinationMode);
                    if (currentValue != ItemCombination.DISABLED) {
                        boolean isWhitelist;
                        boolean bl = isWhitelist = currentValue == ItemCombination.WHITELIST && Arrays.asList(NEEConfig.itemCombinationWhitelist).contains(recipeType);
                        if (currentValue == ItemCombination.ENABLED || isWhitelist) {
                            for (StackProcessor storedIngredient : tInputs) {
                                ItemStack storedStack = (ItemStack)storedIngredient.getIngredient().getDisplayedIngredient();
                                if (storedStack == null || !currentStack.func_77969_a(storedStack) || !ItemStack.func_77970_a((ItemStack)currentStack, (ItemStack)storedStack) || currentStack.func_190916_E() + storedIngredient.getStackSize() > storedStack.func_77976_d()) continue;
                                find = true;
                                storedIngredient.setStackSize(currentStack.func_190916_E() + storedIngredient.getStackSize());
                            }
                        }
                    }
                    if (find) continue;
                    tInputs.add(new StackProcessor((IGuiIngredient<ItemStack>)ingredient, currentStack, currentStack.func_190916_E()));
                    continue;
                }
                if (outputIndex >= 3 || currentStack.func_190926_b() || container.isCraftingMode()) continue;
                recipeOutputs.func_74782_a(OUTPUT_KEY + outputIndex, (NBTBase)currentStack.func_77955_b(new NBTTagCompound()));
                ++outputIndex;
            }
            PatternRecipeTransferHandler.ingredients.clear();
            for (StackProcessor currentIngredient : tInputs) {
                ItemStack preferModItem;
                ItemStack currentStack = currentIngredient.getCurrentStack();
                ItemStack itemStack = preferModItem = ItemUtils.isPreferModItem(currentStack) ? currentStack : ItemUtils.getPreferModItem(currentIngredient.getIngredient());
                if (!currentStack.func_190926_b()) {
                    currentStack.func_190920_e(currentIngredient.getStackSize());
                }
                if (!currentStack.func_190926_b() && preferModItem != null && !preferModItem.func_190926_b()) {
                    currentStack = preferModItem.func_77946_l();
                    currentStack.func_190920_e(currentIngredient.getStackSize());
                }
                for (ItemStack stack2 : currentIngredient.getIngredient().getAllIngredients()) {
                    if (!ItemUtils.isPreferItems(stack2, recipeType) || currentStack.func_190926_b()) continue;
                    currentStack = stack2.func_77946_l();
                    currentStack.func_190920_e(currentIngredient.getStackSize());
                }
                if (!currentStack.func_190926_b() && ItemUtils.isInBlackList(currentStack, recipeType) && !isCraftingRecipe) continue;
                recipeInputs.func_74782_a(INPUT_KEY + inputIndex, (NBTBase)currentStack.func_77955_b(new NBTTagCompound()));
                ArrayList<ItemStack> ingredientList = new ArrayList<ItemStack>(currentIngredient.getIngredient().getAllIngredients());
                ingredientList.removeIf(stack -> stack == null || stack.func_190926_b());
                PatternRecipeTransferHandler.ingredients.put(INPUT_KEY + inputIndex, ingredientList);
                ++inputIndex;
            }
            NEENetworkHandler.getInstance().sendToServer((IMessage)new PacketRecipeTransfer(recipeInputs, recipeOutputs, isCraftingRecipe));
            if (NEEConfig.allowPrintRecipeType) {
                NotEnoughEnergistics.logger.info(recipeType);
            }
        } else if (Minecraft.func_71410_x().field_71462_r instanceof RecipesGui) {
            return new CraftingHelperTooltipError(new IngredientTracker(recipeLayout, (RecipesGui)Minecraft.func_71410_x().field_71462_r), false);
        }
        return null;
    }

    private boolean isCraftingRecipe(String recipeType) {
        if (!recipeType.equals("jei.information") && !recipeType.equals("minecraft.fuel")) {
            return recipeType.equals("minecraft.crafting");
        }
        return false;
    }

    private ItemStack getFirstStack(IGuiIngredient<ItemStack> ingredient) {
        if (!ingredient.getAllIngredients().isEmpty()) {
            return ingredient.getAllIngredients().stream().filter(stack -> stack != null && !stack.func_190926_b()).findFirst().map(ItemStack::func_77946_l).orElse(ItemStack.field_190927_a);
        }
        return ItemStack.field_190927_a;
    }
}

