/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.nee.jei;

import appeng.api.storage.data.IAEFluidStack;
import appeng.client.gui.AEBaseGui;
import appeng.client.gui.implementations.GuiPatternTerm;
import appeng.client.gui.widgets.GuiCustomSlot;
import appeng.container.slot.AppEngSlot;
import appeng.container.slot.SlotFake;
import appeng.fluids.client.gui.widgets.GuiFluidSlot;
import appeng.fluids.util.AEFluidStack;
import com.github.vfyjxf.nee.network.NEENetworkHandler;
import com.github.vfyjxf.nee.network.packet.PacketSlotStackChange;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mezz.jei.api.gui.IGhostIngredientHandler;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class NEEGhostIngredientHandler
implements IGhostIngredientHandler<AEBaseGui> {
    public <I> List<IGhostIngredientHandler.Target<I>> getTargets(AEBaseGui gui, I ingredient, boolean doStart) {
        ArrayList<IGhostIngredientHandler.Target<I>> targets = new ArrayList<IGhostIngredientHandler.Target<I>>();
        if (ingredient instanceof ItemStack) {
            if (gui instanceof GuiPatternTerm) {
                if (GuiContainer.func_146272_n()) {
                    NEEGhostIngredientHandler.addItemStackTargets(gui, targets);
                }
            } else {
                NEEGhostIngredientHandler.addItemStackTargets(gui, targets);
            }
        }
        if (ingredient instanceof FluidStack) {
            NEEGhostIngredientHandler.addFluidStackTargets(gui, targets);
        }
        return targets;
    }

    public void onComplete() {
    }

    private static <I> void addItemStackTargets(AEBaseGui gui, List<IGhostIngredientHandler.Target<I>> targets) {
        for (Slot slot : gui.field_147002_h.field_75151_b) {
            AppEngSlot aeSlot;
            if (!(slot instanceof AppEngSlot) || !(aeSlot = (AppEngSlot)slot).isSlotEnabled() || !(aeSlot instanceof SlotFake)) continue;
            targets.add(new ItemSlotTarget(gui, aeSlot));
        }
    }

    private static <I> void addFluidStackTargets(AEBaseGui gui, List<IGhostIngredientHandler.Target<I>> targets) {
        for (GuiCustomSlot slot : NEEGhostIngredientHandler.getGuiSlots(gui)) {
            if (!slot.isSlotEnabled() || !(slot instanceof GuiFluidSlot)) continue;
            targets.add(new FluidSlotTarget(gui, (GuiFluidSlot)slot));
        }
    }

    private static List<GuiCustomSlot> getGuiSlots(AEBaseGui gui) {
        return new ArrayList<GuiCustomSlot>((Collection)ObfuscationReflectionHelper.getPrivateValue(AEBaseGui.class, (Object)gui, (String)"guiSlots"));
    }

    private static class FluidSlotTarget
    implements IGhostIngredientHandler.Target<FluidStack> {
        private final GuiFluidSlot slot;
        private final Rectangle rectangle;

        private FluidSlotTarget(AEBaseGui gui, GuiFluidSlot slot) {
            this.slot = slot;
            this.rectangle = new Rectangle(slot.xPos() + gui.getGuiLeft(), slot.yPos() + gui.getGuiTop(), slot.getWidth(), slot.getHeight());
        }

        public Rectangle getArea() {
            return this.rectangle;
        }

        public void accept(FluidStack ingredient) {
            this.slot.setFluidStack((IAEFluidStack)AEFluidStack.fromFluidStack((FluidStack)ingredient));
        }
    }

    private static class ItemSlotTarget
    implements IGhostIngredientHandler.Target<ItemStack> {
        private final AppEngSlot slot;
        private final Rectangle rectangle;

        public ItemSlotTarget(AEBaseGui gui, AppEngSlot slot) {
            this.slot = slot;
            this.rectangle = new Rectangle(gui.getGuiLeft() + slot.field_75223_e, gui.getGuiTop() + slot.field_75221_f, 16, 16);
        }

        public Rectangle getArea() {
            return this.rectangle;
        }

        public void accept(ItemStack ingredient) {
            ArrayList<Integer> slots = new ArrayList<Integer>();
            slots.add(this.slot.field_75222_d);
            NEENetworkHandler.getInstance().sendToServer((IMessage)new PacketSlotStackChange(ingredient, slots));
        }
    }
}

