/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.nee.event;

import appeng.client.gui.AEBaseGui;
import appeng.client.gui.implementations.GuiCraftConfirm;
import appeng.client.gui.implementations.GuiInterface;
import appeng.client.gui.implementations.GuiPatternTerm;
import appeng.container.implementations.ContainerCraftConfirm;
import appeng.container.implementations.ContainerPatternTerm;
import appeng.container.slot.SlotFake;
import com.github.vfyjxf.nee.client.KeyBindings;
import com.github.vfyjxf.nee.client.gui.widgets.GuiImgButtonEnableCombination;
import com.github.vfyjxf.nee.config.ItemCombination;
import com.github.vfyjxf.nee.config.NEEConfig;
import com.github.vfyjxf.nee.container.ContainerCraftingConfirm;
import com.github.vfyjxf.nee.jei.CraftingHelperTransferHandler;
import com.github.vfyjxf.nee.jei.PatternRecipeTransferHandler;
import com.github.vfyjxf.nee.network.NEENetworkHandler;
import com.github.vfyjxf.nee.network.packet.PacketSlotStackChange;
import com.github.vfyjxf.nee.network.packet.PacketStackSizeChange;
import com.github.vfyjxf.nee.utils.GuiUtils;
import com.github.vfyjxf.nee.utils.ItemUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class GuiEventHandler {
    private GuiImgButtonEnableCombination buttonCombination;

    @SubscribeEvent
    public void onGuiOpen(GuiOpenEvent event) {
        GuiScreen old = Minecraft.func_71410_x().field_71462_r;
        GuiScreen next = event.getGui();
        if (old != null && GuiUtils.isGuiCraftConfirm(old) && this.isContainerCraftConfirm(((GuiContainer)old).field_147002_h) && CraftingHelperTransferHandler.tracker != null) {
            if (GuiUtils.isGuiCraftingTerm(next)) {
                if (CraftingHelperTransferHandler.tracker.hasNext()) {
                    CraftingHelperTransferHandler.tracker.requestNextIngredient();
                } else {
                    CraftingHelperTransferHandler.tracker = null;
                }
            } else if (CraftingHelperTransferHandler.tracker != null) {
                CraftingHelperTransferHandler.tracker = null;
            }
        }
    }

    @SubscribeEvent
    public void onCraftConfirmActionPerformed(GuiScreenEvent.ActionPerformedEvent.Post event) {
        if (CraftingHelperTransferHandler.tracker != null) {
            if (event.getGui() instanceof GuiCraftConfirm && this.getCancelButton((GuiCraftConfirm)event.getGui()) == event.getButton()) {
                CraftingHelperTransferHandler.tracker = null;
            }
            if (GuiUtils.isWirelessGuiCraftConfirm(event.getGui()) && this.getCancelButton((p455w0rd.wct.client.gui.GuiCraftConfirm)event.getGui()) == event.getButton()) {
                CraftingHelperTransferHandler.tracker = null;
            }
        }
    }

    @SubscribeEvent
    public void onMouseInput(GuiScreenEvent.MouseInputEvent.Pre event) {
        AEBaseGui aeBaseGui;
        Slot currentSlot;
        int dWheel;
        boolean isSupportedGui;
        Minecraft mc = Minecraft.func_71410_x();
        boolean bl = isSupportedGui = mc.field_71462_r instanceof GuiPatternTerm || mc.field_71462_r instanceof GuiInterface;
        if (isSupportedGui && (dWheel = Mouse.getEventDWheel()) != 0 && (currentSlot = (aeBaseGui = (AEBaseGui)mc.field_71462_r).getSlotUnderMouse()) != null && currentSlot.func_75216_d() && currentSlot instanceof SlotFake) {
            if (Keyboard.isKeyDown((int)KeyBindings.recipeIngredientChange.func_151463_i()) && GuiUtils.isCraftingSlot(currentSlot)) {
                this.handleRecipeIngredientChange((GuiContainer)mc.field_71462_r, currentSlot, dWheel);
                event.setCanceled(true);
            } else if (Keyboard.isKeyDown((int)KeyBindings.stackCountChange.func_151463_i())) {
                int changeCount = dWheel / 120;
                NEENetworkHandler.getInstance().sendToServer((IMessage)new PacketStackSizeChange(currentSlot.field_75222_d, changeCount));
                event.setCanceled(true);
            }
        }
    }

    private void handleRecipeIngredientChange(GuiContainer gui, Slot currentSlot, int dWheel) {
        int currentStackIndex;
        List<ItemStack> currentIngredients = PatternRecipeTransferHandler.ingredients.get("#" + currentSlot.getSlotIndex());
        ArrayList<Integer> craftingSlots = new ArrayList<Integer>();
        if (currentIngredients != null && !currentIngredients.isEmpty() && (currentStackIndex = ItemUtils.getIngredientIndex(currentSlot.func_75211_c(), currentIngredients)) >= 0) {
            int nextStackIndex = dWheel / 120;
            for (int i = 0; i < Math.abs(nextStackIndex); ++i) {
                int n = currentStackIndex = nextStackIndex > 0 ? currentStackIndex + 1 : currentStackIndex - 1;
                if (currentStackIndex >= currentIngredients.size()) {
                    currentStackIndex = 0;
                } else if (currentStackIndex < 0) {
                    currentStackIndex = currentIngredients.size() - 1;
                }
                ItemStack currentIngredientStack = currentIngredients.get(currentStackIndex).func_77946_l();
                currentIngredientStack.func_190920_e(currentSlot.func_75211_c().func_190916_E());
                if (NEEConfig.allowSynchronousSwitchIngredient) {
                    for (Slot slot : this.getCraftingSlots(gui)) {
                        boolean areIngredientEqual;
                        List<ItemStack> slotIngredients = PatternRecipeTransferHandler.ingredients.get("#" + slot.getSlotIndex());
                        boolean areItemStackEqual = currentSlot.func_75216_d() && slot.func_75216_d() && currentSlot.func_75211_c().func_77969_a(slot.func_75211_c()) && ItemStack.func_77970_a((ItemStack)currentSlot.func_75211_c(), (ItemStack)slot.func_75211_c());
                        boolean bl = areIngredientEqual = slotIngredients != null && !slotIngredients.isEmpty() && ItemUtils.getIngredientIndex(slotIngredients.get(0), currentIngredients) >= 0;
                        if (!areItemStackEqual || !areIngredientEqual) continue;
                        craftingSlots.add(slot.field_75222_d);
                    }
                } else {
                    craftingSlots.add(currentSlot.field_75222_d);
                }
                NEENetworkHandler.getInstance().sendToServer((IMessage)new PacketSlotStackChange(currentIngredientStack, craftingSlots));
            }
        }
    }

    private List<Slot> getCraftingSlots(GuiContainer gui) {
        ArrayList<Slot> craftingSlots = new ArrayList<Slot>();
        for (Slot slot : gui.field_147002_h.field_75151_b) {
            if (!GuiUtils.isCraftingSlot(slot)) continue;
            craftingSlots.add(slot);
        }
        return craftingSlots;
    }

    @SubscribeEvent
    public void onInitGui(GuiScreenEvent.InitGuiEvent.Post event) {
        if (event.getGui() instanceof GuiPatternTerm) {
            GuiPatternTerm gui = (GuiPatternTerm)event.getGui();
            this.buttonCombination = new GuiImgButtonEnableCombination(gui.field_147003_i + 84, gui.field_147009_r + gui.field_147000_g - 163, ItemCombination.valueOf(NEEConfig.itemCombinationMode));
            event.getButtonList().add(this.buttonCombination);
        }
    }

    @SubscribeEvent
    public void onActionPerformed(GuiScreenEvent.ActionPerformedEvent.Pre event) {
        if (event.getButton() instanceof GuiImgButtonEnableCombination) {
            int ordinal;
            GuiImgButtonEnableCombination button = (GuiImgButtonEnableCombination)event.getButton();
            int n = ordinal = Mouse.getEventButton() != 2 ? button.getCurrentValue().ordinal() + 1 : button.getCurrentValue().ordinal() - 1;
            if (ordinal >= ItemCombination.values().length) {
                ordinal = 0;
            }
            if (ordinal < 0) {
                ordinal = ItemCombination.values().length - 1;
            }
            button.setValue(ItemCombination.values()[ordinal]);
            NEEConfig.setItemCombinationMode(ItemCombination.values()[ordinal].name());
        }
    }

    @SubscribeEvent
    public void onDrawScreen(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (event.getGui() instanceof GuiPatternTerm) {
            ContainerPatternTerm container = (ContainerPatternTerm)((GuiPatternTerm)event.getGui()).field_147002_h;
            if (container.isCraftingMode()) {
                this.buttonCombination.field_146124_l = false;
                this.buttonCombination.field_146125_m = false;
            } else {
                this.buttonCombination.field_146124_l = true;
                this.buttonCombination.field_146125_m = true;
            }
        }
    }

    private boolean isContainerCraftConfirm(Container container) {
        return (container instanceof ContainerCraftConfirm || GuiUtils.isContainerWirelessCraftingConfirm(container)) && !(container instanceof ContainerCraftingConfirm) && !GuiUtils.isWCTContainerCraftingConfirm(container);
    }

    private GuiButton getCancelButton(GuiCraftConfirm gui) {
        return (GuiButton)ObfuscationReflectionHelper.getPrivateValue(GuiCraftConfirm.class, (Object)gui, (String)"cancel");
    }

    @Optional.Method(modid="wct")
    private GuiButton getCancelButton(p455w0rd.wct.client.gui.GuiCraftConfirm gui) {
        return (GuiButton)ObfuscationReflectionHelper.getPrivateValue(p455w0rd.wct.client.gui.GuiCraftConfirm.class, (Object)gui, (String)"cancel");
    }
}

