/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.nee.config;

import java.io.File;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class NEEConfig {
    public static final NEEConfig INSTANCE = new NEEConfig();
    public static Configuration config;
    public static final String CATEGORY_PATTERN_TRANSFER = "transfer";
    public static final String CATEGORY_CRAFTING_HELPER = "helper";
    public static final String CATEGORY_OTHER_SETTINGS = "other";
    public static boolean allowPrintRecipeType;
    public static boolean useDisplayedIngredient;
    public static String[] modPriorityList;
    public static String[] itemBlacklist;
    public static String[] itemPriorityList;
    public static String itemCombinationMode;
    public static String[] itemCombinationWhitelist;
    public static boolean matchOtherItems;
    public static boolean allowSynchronousSwitchIngredient;

    private NEEConfig() {
    }

    public static void initConfig(File configFile) {
        config = new Configuration(configFile);
        config.load();
        allowPrintRecipeType = config.getBoolean("allowPrintRecipeType", CATEGORY_PATTERN_TRANSFER, allowPrintRecipeType, "If true, print current recipe type in log.Default:false");
        useDisplayedIngredient = config.getBoolean("useDisplayedIngredient", CATEGORY_PATTERN_TRANSFER, useDisplayedIngredient, "If true, the ingredient currently displayed by JEI will be transferred.Default:false");
        itemCombinationMode = config.getString("itemCombinationMode", CATEGORY_PATTERN_TRANSFER, itemCombinationMode, "Item Combination Mode Setting, here are all the modes. \n\"ENABLED\" \"DISABLED\" WHITELIST");
        itemCombinationWhitelist = config.getStringList("itemCombinationWhitelist", CATEGORY_PATTERN_TRANSFER, itemCombinationWhitelist, "Whitelist for item combination");
        itemPriorityList = config.getStringList("itemPriorityList", CATEGORY_PATTERN_TRANSFER, itemPriorityList, "If item in tne priority list, it will be transferred first.\nexample:{\"itemName\":\"gregtech:meta_item_2\",\"meta\":\"32492\"}");
        itemBlacklist = config.getStringList("itemBlacklist", CATEGORY_PATTERN_TRANSFER, itemBlacklist, "If item in the blacklist, it will not be transferred.\nexample:{\"itemName\":\"gregtech:meta_item_2\",\"meta\":\"32492\"}");
        modPriorityList = config.getStringList("modPriorityList", CATEGORY_PATTERN_TRANSFER, modPriorityList, "If oredict has this mod's item, use it first.");
        matchOtherItems = config.getBoolean("matchOtherItems", CATEGORY_CRAFTING_HELPER, matchOtherItems, "If true, Crafting Helper will match other items even they can't auto-crafting");
        allowSynchronousSwitchIngredient = config.getBoolean("allowSynchronousSwitchIngredient", CATEGORY_OTHER_SETTINGS, allowSynchronousSwitchIngredient, "If true, it will make all similar ingredient switch at the same time.");
        if (config.hasChanged()) {
            config.save();
        }
    }

    public static void setModPriorityList(String[] modPriorityList) {
        NEEConfig.modPriorityList = modPriorityList;
        config.get(CATEGORY_PATTERN_TRANSFER, "modPriorityList", modPriorityList, "If oredict has this mod's item, use it first.").set(modPriorityList);
        config.save();
    }

    public static void setItemBlacklist(String[] itemBlacklist) {
        NEEConfig.itemBlacklist = itemBlacklist;
        config.get(CATEGORY_PATTERN_TRANSFER, "itemBlacklist", itemBlacklist, "If item in the blacklist, it will not be transferred.\nexample:{\"itemName\":\"gregtech:meta_item_2\",\"meta\":\"32492\"}").set(itemBlacklist);
        config.save();
    }

    public static void setItemPriorityList(String[] itemPriorityList) {
        NEEConfig.itemPriorityList = itemPriorityList;
        config.get(CATEGORY_PATTERN_TRANSFER, "itemPriorityList", itemPriorityList, "If item in tne priority list, it will be transferred first.\nexample:{\"itemName\":\"gregtech:meta_item_2\",\"meta\":\"32492\"}").set(itemPriorityList);
        config.save();
    }

    public static void setItemCombinationMode(String itemCombinationMode) {
        NEEConfig.itemCombinationMode = itemCombinationMode;
        config.get(CATEGORY_PATTERN_TRANSFER, "itemCombinationMode", itemCombinationMode, "Item Combination Mode Setting, here are all the modes. \n\"ENABLED\" \"DISABLED\" WHITELIST").set(itemCombinationMode);
        config.save();
    }

    public static void setItemCombinationWhitelist(String[] itemCombinationWhitelist) {
        NEEConfig.itemCombinationWhitelist = itemCombinationWhitelist;
        config.get(CATEGORY_PATTERN_TRANSFER, "itemCombinationWhitelist", itemCombinationWhitelist, "Whitelist for item combination").set(itemCombinationWhitelist);
        config.save();
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if ("neenergistics".equals(event.getModID())) {
            ConfigManager.sync((String)"neenergistics", (Config.Type)Config.Type.INSTANCE);
        }
    }

    static {
        allowPrintRecipeType = false;
        useDisplayedIngredient = false;
        modPriorityList = new String[0];
        itemBlacklist = new String[0];
        itemPriorityList = new String[0];
        itemCombinationMode = "ENABLED";
        itemCombinationWhitelist = new String[0];
        matchOtherItems = true;
        allowSynchronousSwitchIngredient = true;
    }
}

