/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.nee.block.tile;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.implementations.ICraftingPatternItem;
import appeng.api.implementations.tiles.ICraftingMachine;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.CraftingItemList;
import appeng.api.networking.crafting.ICraftingCPU;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.crafting.ICraftingMedium;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.crafting.ICraftingProviderHelper;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkCraftingPatternChange;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.core.settings.TickRates;
import appeng.helpers.IInterfaceHost;
import appeng.me.GridAccessException;
import appeng.me.cluster.implementations.CraftingCPUCluster;
import appeng.me.helpers.MachineSource;
import appeng.tile.grid.AENetworkInvTile;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.inv.AdaptorItemHandler;
import appeng.util.inv.IAEAppEngInventory;
import appeng.util.inv.IInventoryDestination;
import appeng.util.inv.InvOperation;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.RangedWrapper;

public class TilePatternInterface
extends AENetworkInvTile
implements IGridTickable,
ICraftingProvider,
IInventoryDestination {
    private final AppEngInternalInventory gridInv;
    private final AppEngInternalInventory patterns;
    private final AppEngInternalInventory ejectInv;
    private final List<ICraftingPatternDetails> craftingList;
    private List<ItemStack> waitingToSend;
    private final MachineSource source;
    private final boolean[] workStarted = new boolean[9];

    public TilePatternInterface() {
        this.gridInv = new AppEngInternalInventory((IAEAppEngInventory)this, 10, 1);
        this.patterns = new AppEngInternalInventory((IAEAppEngInventory)this, 9);
        this.ejectInv = new AppEngInternalInventory((IAEAppEngInventory)this, 9);
        this.craftingList = new ArrayList<ICraftingPatternDetails>();
        this.source = new MachineSource((IActionHost)this);
        this.getProxy().setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL});
        this.getProxy().setIdlePowerUsage(30.0);
    }

    @MENetworkEventSubscribe
    public void stateChange(MENetworkChannelsChanged c) {
        this.notifyNeighbors();
    }

    @MENetworkEventSubscribe
    public void stateChange(MENetworkPowerStatusChange c) {
        this.notifyNeighbors();
    }

    private void notifyNeighbors() {
        if (this.getProxy().isActive()) {
            try {
                this.getProxy().getGrid().postEvent((MENetworkEvent)new MENetworkCraftingPatternChange((ICraftingProvider)this, this.getProxy().getNode()));
                this.getProxy().getTick().wakeDevice(this.getProxy().getNode());
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
            Platform.notifyBlocksOfNeighbors((World)this.func_145831_w(), (BlockPos)this.func_174877_v());
        }
    }

    @Nonnull
    public TickingRequest getTickingRequest(@Nonnull IGridNode node) {
        return new TickingRequest(TickRates.Interface.getMin(), TickRates.Interface.getMax(), !this.hasItemToSend(), true);
    }

    @Nonnull
    public TickRateModulation tickingRequest(@Nonnull IGridNode node, int ticksSinceLastCall) {
        if (!this.getProxy().isActive()) {
            return TickRateModulation.SLEEP;
        }
        if (this.hasItemToSend()) {
            this.ejectItems();
        }
        if (this.hasItemsToPush()) {
            this.pushItemsOut(EnumSet.allOf(EnumFacing.class));
        }
        if (this.hasWorkFinished()) {
            this.updateWorks();
        }
        if (this.hasWorks()) {
            return TickRateModulation.URGENT;
        }
        return TickRateModulation.SLEEP;
    }

    @Nonnull
    public IItemHandler getInternalInventory() {
        return new AppEngInternalInventory((IAEAppEngInventory)this, 0);
    }

    public void provideCrafting(ICraftingProviderHelper craftingTracker) {
        if (this.getProxy().isActive()) {
            if (this.craftingList.isEmpty()) {
                for (int i = 0; i < this.patterns.getSlots(); ++i) {
                    ICraftingPatternDetails pattern;
                    ItemStack stack = this.patterns.getStackInSlot(i);
                    if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ICraftingPatternItem) || (pattern = ((ICraftingPatternItem)stack.func_77973_b()).getPatternForItem(stack, this.field_145850_b)) == null || !pattern.isCraftable()) continue;
                    this.craftingList.add(pattern);
                }
            }
            for (ICraftingPatternDetails details : this.craftingList) {
                craftingTracker.addCraftingOption((ICraftingMedium)this, details);
            }
        }
    }

    public boolean pushPattern(ICraftingPatternDetails patternDetails, InventoryCrafting table) {
        if (!this.isBusy() && this.getProxy().isActive() && this.craftingList.contains(patternDetails) && !this.hasItemsToPush()) {
            EnumSet<EnumFacing> possibleDirections = EnumSet.allOf(EnumFacing.class);
            for (EnumFacing facing : possibleDirections) {
                ICraftingMachine cm;
                TileEntity te = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(facing));
                if (te instanceof IInterfaceHost) {
                    try {
                        if (te instanceof AENetworkInvTile && this.sameGrid(((AENetworkInvTile)te).getProxy().getGrid())) {
                        }
                    }
                    catch (GridAccessException e) {}
                    continue;
                }
                if (te instanceof ICraftingMachine && (cm = (ICraftingMachine)te).acceptsPlans()) {
                    if (!cm.pushPattern(patternDetails, table, facing.func_176734_d())) continue;
                    this.setWorkStart(patternDetails);
                    return true;
                }
                InventoryAdaptor ad = InventoryAdaptor.getAdaptor((TileEntity)te, (EnumFacing)facing.func_176734_d());
                if (ad == null || !this.acceptsItems(ad, table)) continue;
                for (int x = 0; x < table.func_70302_i_(); ++x) {
                    ItemStack is = table.func_70301_a(x);
                    if (is.func_190926_b()) continue;
                    ItemStack added = ad.addItems(is);
                    this.addToSendList(added);
                }
                this.pushItemsOut(possibleDirections);
                this.setWorkStart(patternDetails);
                return true;
            }
        }
        return false;
    }

    public boolean isBusy() {
        return this.hasItemsToPush();
    }

    public void onChangeInventory(IItemHandler inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
        if (inv == this.ejectInv || inv == this.patterns) {
            try {
                this.getProxy().getTick().alertDevice(this.getProxy().getNode());
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
    }

    public void getDrops(World w, BlockPos pos, List<ItemStack> drops) {
        if (this.hasItemsToPush()) {
            for (ItemStack stack : this.waitingToSend) {
                if (stack.func_190926_b()) continue;
                drops.add(stack);
            }
        }
        for (int i = 0; i < this.ejectInv.getSlots(); ++i) {
            ItemStack stack;
            stack = this.ejectInv.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            drops.add(stack);
        }
    }

    public AppEngInternalInventory getGirdInventory() {
        return this.gridInv;
    }

    public AppEngInternalInventory getPatternInventory() {
        return this.patterns;
    }

    public DimensionalCoord getLocation() {
        return new DimensionalCoord((TileEntity)this);
    }

    @Nonnull
    public AECableType getCableConnectionType(@Nonnull AEPartLocation dir) {
        return AECableType.SMART;
    }

    public boolean canInsert(ItemStack stack) {
        if (stack.func_190926_b() || stack.func_77973_b() == Items.field_190931_a) {
            return false;
        }
        try {
            IMEMonitor inv = this.getProxy().getStorage().getInventory(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class));
            IAEItemStack out = (IAEItemStack)inv.injectItems(((IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)).createStack((Object)stack), Actionable.SIMULATE, (IActionSource)this.source);
            if (out == null) {
                return true;
            }
            return out.getStackSize() != (long)stack.func_190916_E();
        }
        catch (GridAccessException ex) {
            return false;
        }
    }

    public <T> T getCapability(Capability<T> capabilityClass, EnumFacing facing) {
        if (capabilityClass == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.ejectInv;
        }
        return null;
    }

    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.waitingToSend = null;
        NBTTagList waitingList = data.func_150295_c("waitingToSend", 10);
        if (!waitingList.func_82582_d()) {
            for (int x = 0; x < waitingList.func_74745_c(); ++x) {
                NBTTagCompound c = waitingList.func_150305_b(x);
                if (c.func_82582_d()) continue;
                ItemStack is = new ItemStack(c);
                this.addToSendList(is);
            }
        }
        this.patterns.readFromNBT(data, "patterns");
        this.ejectInv.readFromNBT(data, "ejectInv");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound data) {
        super.func_189515_b(data);
        this.patterns.writeToNBT(data, "patterns");
        this.ejectInv.writeToNBT(data, "ejectInv");
        NBTTagList waitingToSend = new NBTTagList();
        if (this.waitingToSend != null) {
            for (ItemStack is : this.waitingToSend) {
                NBTTagCompound item = new NBTTagCompound();
                is.func_77955_b(item);
                waitingToSend.func_74742_a((NBTBase)item);
            }
        }
        data.func_74782_a("waitingToSend", (NBTBase)waitingToSend);
        return data;
    }

    private boolean hasItemsToPush() {
        return this.waitingToSend != null && !this.waitingToSend.isEmpty();
    }

    public boolean canPutPattern(ItemStack result) {
        if (result == null || result.func_190926_b()) {
            return false;
        }
        for (int i = 0; i < this.patterns.getSlots(); ++i) {
            ICraftingPatternDetails pattern;
            ItemStack stack = this.patterns.getStackInSlot(i);
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ICraftingPatternItem) || !result.func_77969_a((pattern = ((ICraftingPatternItem)stack.func_77973_b()).getPatternForItem(stack, this.field_145850_b)).getOutputs()[0].asItemStackRepresentation())) continue;
            return false;
        }
        return IntStream.range(0, this.patterns.getSlots()).anyMatch(slot -> this.patterns.getStackInSlot(slot).func_190926_b());
    }

    public int putPattern(ItemStack pattern) {
        for (int i = 0; i < this.patterns.getSlots(); ++i) {
            ItemStack stack = this.patterns.getStackInSlot(i);
            if (!stack.func_190926_b()) continue;
            this.patterns.setStackInSlot(i, pattern);
            this.updateCraftingList();
            return i;
        }
        return -1;
    }

    public void updateCraftingList() {
        Boolean[] accountedFor = new Boolean[]{false, false, false, false, false, false, false, false, false};
        assert (accountedFor.length == this.patterns.getSlots());
        if (!this.getProxy().isReady()) {
            return;
        }
        if (this.craftingList != null) {
            Iterator<ICraftingPatternDetails> i = this.craftingList.iterator();
            while (i.hasNext()) {
                ICraftingPatternDetails details = i.next();
                boolean found = false;
                for (int x = 0; x < accountedFor.length; ++x) {
                    ItemStack is = this.patterns.getStackInSlot(x);
                    if (details.getPattern() != is) continue;
                    found = true;
                    accountedFor[x] = true;
                }
                if (found) continue;
                i.remove();
            }
        }
        for (int x = 0; x < accountedFor.length; ++x) {
            if (accountedFor[x].booleanValue()) continue;
            this.addToCraftingList(this.patterns.getStackInSlot(x));
        }
        try {
            this.getProxy().getGrid().postEvent((MENetworkEvent)new MENetworkCraftingPatternChange((ICraftingProvider)this, this.getProxy().getNode()));
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    public void cancelWork(int recipeIndex) {
        IAEItemStack result = this.getResultStack(recipeIndex);
        if (result != null) {
            this.workStarted[recipeIndex] = false;
            try {
                ICraftingGrid cg = this.getProxy().getCrafting();
                ImmutableSet cpuSet = cg.getCpus();
                block2: for (ICraftingCPU cpu : cpuSet) {
                    if (!(cpu instanceof CraftingCPUCluster)) continue;
                    CraftingCPUCluster cluster = (CraftingCPUCluster)cpu;
                    IItemList pendingList = ((IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)).createList();
                    cluster.getListOfItem(pendingList, CraftingItemList.PENDING);
                    for (IAEItemStack pendingStack : pendingList) {
                        if (!pendingStack.isSameType(result)) continue;
                        cluster.cancel();
                        continue block2;
                    }
                }
            }
            catch (GridAccessException e) {
                e.printStackTrace();
            }
        }
    }

    private void addToCraftingList(ItemStack is) {
        ICraftingPatternItem cpi;
        ICraftingPatternDetails details;
        if (is.func_190926_b()) {
            return;
        }
        if (is.func_77973_b() instanceof ICraftingPatternItem && (details = (cpi = (ICraftingPatternItem)is.func_77973_b()).getPatternForItem(is, this.func_145831_w())) != null && this.craftingList != null) {
            this.craftingList.add(details);
        }
    }

    private void addToSendList(ItemStack is) {
        if (is.func_190926_b()) {
            return;
        }
        if (this.waitingToSend == null) {
            this.waitingToSend = new ArrayList<ItemStack>();
        }
        this.waitingToSend.add(is);
        try {
            this.getProxy().getTick().wakeDevice(this.getProxy().getNode());
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    private boolean acceptsItems(InventoryAdaptor ad, InventoryCrafting table) {
        for (int x = 0; x < table.func_70302_i_(); ++x) {
            ItemStack is = table.func_70301_a(x);
            if (is.func_190926_b() || ad.simulateAdd(is.func_77946_l()).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    private void pushItemsOut(EnumSet<EnumFacing> possibleDirections) {
        if (!this.hasItemsToPush()) {
            return;
        }
        Iterator<ItemStack> i = this.waitingToSend.iterator();
        while (i.hasNext()) {
            ItemStack whatToSend = i.next();
            for (EnumFacing s : possibleDirections) {
                InventoryAdaptor ad;
                TileEntity te = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(s));
                if (te == null || (ad = InventoryAdaptor.getAdaptor((TileEntity)te, (EnumFacing)s.func_176734_d())) == null) continue;
                ItemStack result = ad.addItems(whatToSend);
                if (result.func_190926_b()) {
                    whatToSend = ItemStack.field_190927_a;
                } else {
                    whatToSend.func_190920_e(whatToSend.func_190916_E() - (whatToSend.func_190916_E() - result.func_190916_E()));
                }
                if (!whatToSend.func_190926_b()) continue;
                break;
            }
            if (!whatToSend.func_190926_b()) continue;
            i.remove();
        }
        if (this.waitingToSend.isEmpty()) {
            this.waitingToSend = null;
        }
    }

    private boolean hasItemToSend() {
        for (int i = 0; i < this.ejectInv.getSlots(); ++i) {
            ItemStack stack = this.ejectInv.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            return true;
        }
        return false;
    }

    private void ejectItems() {
        for (int i = 0; i < this.ejectInv.getSlots(); ++i) {
            if (this.ejectInv.getStackInSlot(i).func_190926_b()) continue;
            ItemStack stack = this.ejectInv.getStackInSlot(i);
            int itemCount = stack.func_190916_E();
            InventoryAdaptor adaptor = this.getAdaptor(i);
            ItemStack canExtract = adaptor.simulateRemove(itemCount, stack, null);
            if (canExtract == null || canExtract.func_190916_E() != itemCount) continue;
            try {
                IMEMonitor inv = this.getProxy().getStorage().getInventory(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class));
                IEnergyGrid energy = this.getProxy().getEnergy();
                IAEItemStack aeStack = (IAEItemStack)((IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)).createStack((Object)stack);
                if (aeStack == null) continue;
                IAEItemStack failed = (IAEItemStack)Platform.poweredInsert((IEnergySource)energy, (IMEInventory)inv, (IAEStack)aeStack, (IActionSource)this.source);
                if (failed != null) {
                    itemCount = (int)((long)itemCount - failed.getStackSize());
                }
                if (itemCount == 0) continue;
                ItemStack removed = adaptor.removeItems(itemCount, ItemStack.field_190927_a, null);
                if (removed.func_190926_b()) {
                    throw new IllegalStateException("bad attempt at managing inventory. ( removeItems )");
                }
                if (removed.func_190916_E() == itemCount) continue;
                throw new IllegalStateException("bad attempt at managing inventory. ( removeItems )");
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
    }

    private InventoryAdaptor getAdaptor(int slot) {
        return new AdaptorItemHandler((IItemHandler)new RangedWrapper((IItemHandlerModifiable)this.ejectInv, slot, slot + 1));
    }

    private boolean hasWorks() {
        for (int i = 0; i < this.patterns.getSlots(); ++i) {
            if (this.patterns.getStackInSlot(i).func_190926_b()) continue;
            return true;
        }
        return false;
    }

    private void setWorkStart(ICraftingPatternDetails pattern) {
        for (int i = 0; i < this.patterns.getSlots(); ++i) {
            ICraftingPatternDetails currentPattern;
            ItemStack stack = this.patterns.getStackInSlot(i);
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ICraftingPatternItem) || (currentPattern = ((ICraftingPatternItem)stack.func_77973_b()).getPatternForItem(stack, this.field_145850_b)) == null || !currentPattern.equals(pattern)) continue;
            this.workStarted[i] = true;
        }
    }

    private boolean hasWorkFinished() {
        for (int i = 0; i < this.patterns.getSlots(); ++i) {
            IAEItemStack what;
            ICraftingPatternDetails currentPattern;
            ItemStack stack = this.patterns.getStackInSlot(i);
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ICraftingPatternItem) || (currentPattern = ((ICraftingPatternItem)stack.func_77973_b()).getPatternForItem(stack, this.field_145850_b)) == null) continue;
            IAEItemStack iAEItemStack = what = currentPattern.getOutputs().length > 0 ? currentPattern.getOutputs()[0] : null;
            if (!this.isNotRequesting(what) || !this.workStarted[i]) continue;
            return true;
        }
        return false;
    }

    private void updateWorks() {
        for (int i = 0; i < this.patterns.getSlots(); ++i) {
            IAEItemStack what = this.getResultStack(i);
            if (!this.isNotRequesting(what) || !this.workStarted[i]) continue;
            this.patterns.setStackInSlot(i, ItemStack.field_190927_a);
            this.workStarted[i] = false;
            this.updateCraftingList();
        }
    }

    private boolean isNotRequesting(IAEItemStack stack) {
        if (stack == null) {
            return true;
        }
        try {
            ICraftingGrid cg = this.getProxy().getCrafting();
            ImmutableSet cpuSet = cg.getCpus();
            IItemList pendingList = ((IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)).createList();
            for (ICraftingCPU cpu : cpuSet) {
                if (!(cpu instanceof CraftingCPUCluster)) continue;
                CraftingCPUCluster cluster = (CraftingCPUCluster)cpu;
                cluster.getListOfItem(pendingList, CraftingItemList.PENDING);
            }
            for (IAEItemStack pendingStack : pendingList) {
                if (!pendingStack.isSameType(stack)) continue;
                return false;
            }
        }
        catch (GridAccessException e) {
            e.printStackTrace();
        }
        return true;
    }

    private IAEItemStack getResultStack(int pattern) {
        ICraftingPatternDetails currentPattern;
        ItemStack stack = this.patterns.getStackInSlot(pattern);
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ICraftingPatternItem && (currentPattern = ((ICraftingPatternItem)stack.func_77973_b()).getPatternForItem(stack, this.field_145850_b)) != null) {
            return currentPattern.getOutputs().length > 0 ? currentPattern.getOutputs()[0] : null;
        }
        return null;
    }

    public void gridChanged() {
        this.notifyNeighbors();
    }

    private boolean sameGrid(IGrid grid) throws GridAccessException {
        return grid == this.getProxy().getGrid();
    }
}

