/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.nee.asm;

import com.github.vfyjxf.nee.NotEnoughEnergistics;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class NEEClassTransformer
implements IClassTransformer {
    private static final String TARGET_CLASS_NAME = "mezz/jei/gui/recipes/RecipeTransferButton";
    private static final String METHOD_NAME = "init";
    private static final String METHOD_TARGET = "(Lnet/minecraft/inventory/Container;Lnet/minecraft/entity/player/EntityPlayer;)V";
    private static final String HELPER_CLASS_NAME = "com/github/vfyjxf/nee/asm/JEIHelper";
    private static final String HELPER_METHOD_NAME = "setButtonEnable";
    private static final String HELPER_METHOD_TARGET = "(Lnet/minecraft/client/gui/GuiButton;)V";

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        String internalName = transformedName.replace('.', '/');
        if (internalName.equals(TARGET_CLASS_NAME)) {
            ClassNode classNode = new ClassNode();
            ClassReader classReader = new ClassReader(basicClass);
            classReader.accept((ClassVisitor)classNode, 0);
            for (MethodNode methodNode : classNode.methods) {
                if (!methodNode.name.equals(METHOD_NAME) || !methodNode.desc.equals(METHOD_TARGET)) continue;
                NotEnoughEnergistics.logger.info("Transforming : " + internalName + methodNode.name + methodNode.desc);
                InsnList insnList = new InsnList();
                for (AbstractInsnNode instruction : methodNode.instructions.toArray()) {
                    int opcode = instruction.getOpcode();
                    if (opcode != 177) continue;
                    insnList.add((AbstractInsnNode)new VarInsnNode(25, 0));
                    insnList.add((AbstractInsnNode)new FieldInsnNode(180, TARGET_CLASS_NAME, "recipeTransferError", "Lmezz/jei/api/recipe/transfer/IRecipeTransferError;"));
                    insnList.add((AbstractInsnNode)new TypeInsnNode(193, "com/github/vfyjxf/nee/jei/CraftingHelperTooltipError"));
                    LabelNode label = new LabelNode();
                    insnList.add((AbstractInsnNode)new JumpInsnNode(153, label));
                    insnList.add((AbstractInsnNode)new VarInsnNode(25, 0));
                    insnList.add((AbstractInsnNode)new MethodInsnNode(184, HELPER_CLASS_NAME, HELPER_METHOD_NAME, HELPER_METHOD_TARGET, false));
                    insnList.add((AbstractInsnNode)label);
                    methodNode.instructions.insertBefore(instruction, insnList);
                }
            }
            ClassWriter classWriter = new ClassWriter(3);
            classNode.accept((ClassVisitor)classWriter);
            return classWriter.toByteArray();
        }
        return basicClass;
    }
}

