/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.venus.world.gen;

import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.BiomeAdaptive;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.MapGenBaseMeta;
import micdoodle8.mods.galacticraft.api.world.ChunkProviderBase;
import micdoodle8.mods.galacticraft.core.perlin.generator.GradientNoise;
import micdoodle8.mods.galacticraft.planets.venus.VenusBlocks;
import micdoodle8.mods.galacticraft.planets.venus.blocks.BlockBasicVenus;
import micdoodle8.mods.galacticraft.planets.venus.world.gen.BiomeGenVenusValley;
import micdoodle8.mods.galacticraft.planets.venus.world.gen.MapGenCaveVenus;
import micdoodle8.mods.galacticraft.planets.venus.world.gen.MapGenLavaVenus;
import micdoodle8.mods.galacticraft.planets.venus.world.gen.WorldGenCrashedProbe;
import micdoodle8.mods.galacticraft.planets.venus.world.gen.WorldGenLakesVenus;
import micdoodle8.mods.galacticraft.planets.venus.world.gen.WorldGenVaporPool;
import micdoodle8.mods.galacticraft.planets.venus.world.gen.dungeon.DungeonConfigurationVenus;
import micdoodle8.mods.galacticraft.planets.venus.world.gen.dungeon.MapGenDungeonVenus;
import micdoodle8.mods.galacticraft.planets.venus.world.gen.dungeon.RoomBossVenus;
import micdoodle8.mods.galacticraft.planets.venus.world.gen.dungeon.RoomTreasureVenus;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.NoiseGenerator;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.NoiseGeneratorPerlin;

public class ChunkProviderVenus
extends ChunkProviderBase {
    public static final IBlockState BLOCK_FILL = VenusBlocks.venusBlock.func_176223_P().func_177226_a(BlockBasicVenus.BASIC_TYPE_VENUS, (Comparable)((Object)BlockBasicVenus.EnumBlockBasicVenus.ROCK_HARD));
    private Random rand;
    private NoiseGeneratorOctaves noiseGen1;
    private NoiseGeneratorOctaves noiseGen2;
    private NoiseGeneratorOctaves noiseGen3;
    private NoiseGeneratorPerlin noiseGen4;
    private NoiseGeneratorOctaves noiseGen5;
    private NoiseGeneratorOctaves noiseGen6;
    private NoiseGeneratorOctaves mobSpawnerNoise;
    private final GradientNoise noiseGenSmooth1;
    private World world;
    private WorldType worldType;
    private final double[] terrainCalcs;
    private final float[] parabolicField;
    private double[] stoneNoise = new double[256];
    private MapGenBaseMeta caveGenerator = new MapGenCaveVenus();
    private MapGenBaseMeta lavaCaveGenerator = new MapGenLavaVenus();
    private Biome[] biomesForGeneration;
    private double[] octaves1;
    private double[] octaves2;
    private double[] octaves3;
    private double[] octaves4;
    private final MapGenDungeonVenus dungeonGenerator = new MapGenDungeonVenus(new DungeonConfigurationVenus(VenusBlocks.venusBlock.func_176223_P().func_177226_a(BlockBasicVenus.BASIC_TYPE_VENUS, (Comparable)((Object)BlockBasicVenus.EnumBlockBasicVenus.DUNGEON_BRICK_1)), VenusBlocks.venusBlock.func_176223_P().func_177226_a(BlockBasicVenus.BASIC_TYPE_VENUS, (Comparable)((Object)BlockBasicVenus.EnumBlockBasicVenus.DUNGEON_BRICK_2)), 30, 8, 16, 7, 7, RoomBossVenus.class, RoomTreasureVenus.class));

    public ChunkProviderVenus(World worldIn, long seed, boolean mapFeaturesEnabled) {
        this.world = worldIn;
        this.worldType = worldIn.func_72912_H().func_76067_t();
        this.rand = new Random(seed);
        this.noiseGen1 = new NoiseGeneratorOctaves(this.rand, 16);
        this.noiseGen2 = new NoiseGeneratorOctaves(this.rand, 16);
        this.noiseGen3 = new NoiseGeneratorOctaves(this.rand, 8);
        this.noiseGen4 = new NoiseGeneratorPerlin(this.rand, 4);
        this.noiseGen5 = new NoiseGeneratorOctaves(this.rand, 10);
        this.noiseGen6 = new NoiseGeneratorOctaves(this.rand, 16);
        this.mobSpawnerNoise = new NoiseGeneratorOctaves(this.rand, 8);
        this.noiseGenSmooth1 = new GradientNoise(this.rand.nextLong(), 4, 0.25);
        this.terrainCalcs = new double[825];
        this.parabolicField = new float[25];
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                float f;
                this.parabolicField[i + 2 + (j + 2) * 5] = f = 10.0f / MathHelper.func_76129_c((float)((float)(i * i + j * j) + 0.2f));
            }
        }
        NoiseGenerator[] noiseGens = new NoiseGenerator[]{this.noiseGen1, this.noiseGen2, this.noiseGen3, this.noiseGen4, this.noiseGen5, this.noiseGen6, this.mobSpawnerNoise};
        this.noiseGen1 = (NoiseGeneratorOctaves)noiseGens[0];
        this.noiseGen2 = (NoiseGeneratorOctaves)noiseGens[1];
        this.noiseGen3 = (NoiseGeneratorOctaves)noiseGens[2];
        this.noiseGen4 = (NoiseGeneratorPerlin)noiseGens[3];
        this.noiseGen5 = (NoiseGeneratorOctaves)noiseGens[4];
        this.noiseGen6 = (NoiseGeneratorOctaves)noiseGens[5];
        this.mobSpawnerNoise = (NoiseGeneratorOctaves)noiseGens[6];
    }

    private void setBlocksInChunk(int chunkX, int chunkZ, ChunkPrimer primer) {
        this.noiseGenSmooth1.setFrequencyAll(0.015f);
        this.biomesForGeneration = this.world.func_72959_q().func_76937_a(this.biomesForGeneration, chunkX * 4 - 2, chunkZ * 4 - 2, 10, 10);
        this.createLandPerBiome(chunkX * 4, chunkZ * 4);
        for (int i = 0; i < 4; ++i) {
            int j = i * 5;
            int k = (i + 1) * 5;
            for (int l = 0; l < 4; ++l) {
                int i1 = (j + l) * 33;
                int j1 = (j + l + 1) * 33;
                int k1 = (k + l) * 33;
                int l1 = (k + l + 1) * 33;
                for (int i2 = 0; i2 < 32; ++i2) {
                    double d0 = 0.125;
                    double d1 = this.terrainCalcs[i1 + i2];
                    double d2 = this.terrainCalcs[j1 + i2];
                    double d3 = this.terrainCalcs[k1 + i2];
                    double d4 = this.terrainCalcs[l1 + i2];
                    double d5 = (this.terrainCalcs[i1 + i2 + 1] - d1) * d0;
                    double d6 = (this.terrainCalcs[j1 + i2 + 1] - d2) * d0;
                    double d7 = (this.terrainCalcs[k1 + i2 + 1] - d3) * d0;
                    double d8 = (this.terrainCalcs[l1 + i2 + 1] - d4) * d0;
                    for (int j2 = 0; j2 < 8; ++j2) {
                        double d9 = 0.25;
                        double d10 = d1;
                        double d11 = d2;
                        double d12 = (d3 - d1) * d9;
                        double d13 = (d4 - d2) * d9;
                        for (int k2 = 0; k2 < 4; ++k2) {
                            double d14 = 0.25;
                            double d16 = (d11 - d10) * d14;
                            double lvt_45_1_ = d10 - d16;
                            for (int l2 = 0; l2 < 4; ++l2) {
                                double d;
                                lvt_45_1_ += d16;
                                if (!(d > this.noiseGenSmooth1.evalNoise(chunkX * 16 + (i * 4 + k2), chunkZ * 16 + (l * 4 + l2)) * 20.0)) continue;
                                primer.func_177855_a(i * 4 + k2, i2 * 8 + j2, l * 4 + l2, BLOCK_FILL);
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        d1 += d5;
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                    }
                }
            }
        }
    }

    private void replaceBlocksForBiome(int x, int z, ChunkPrimer primer, Biome[] biomes) {
        double d0 = 0.03125;
        this.stoneNoise = this.noiseGen4.func_151599_a(this.stoneNoise, (double)(x * 16), (double)(z * 16), 16, 16, d0 * 2.0, d0 * 2.0, 1.0);
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                Biome biomegenbase = biomes[j + i * 16];
                biomegenbase.func_180622_a(this.world, this.rand, primer, x * 16 + i, z * 16 + j, this.stoneNoise[j + i * 16]);
            }
        }
    }

    public Chunk func_185932_a(int x, int z) {
        this.rand.setSeed((long)x * 341873128712L + (long)z * 132897987541L);
        ChunkPrimer chunkprimer = new ChunkPrimer();
        this.setBlocksInChunk(x, z, chunkprimer);
        this.biomesForGeneration = this.world.func_72959_q().func_76933_b(this.biomesForGeneration, x * 16, z * 16, 16, 16);
        this.caveGenerator.generate(this.world, x, z, chunkprimer);
        this.lavaCaveGenerator.generate(this.world, x, z, chunkprimer);
        this.replaceBlocksForBiome(x, z, chunkprimer, this.biomesForGeneration);
        this.dungeonGenerator.func_186125_a(this.world, x, z, chunkprimer);
        Chunk chunk = new Chunk(this.world, chunkprimer, x, z);
        byte[] abyte = chunk.func_76605_m();
        for (int i = 0; i < abyte.length; ++i) {
            abyte[i] = (byte)Biome.func_185362_a((Biome)this.biomesForGeneration[i]);
        }
        chunk.func_76603_b();
        return chunk;
    }

    private void createLandPerBiome(int x, int z) {
        this.octaves4 = this.noiseGen6.func_76305_a(this.octaves4, x, z, 5, 5, 2000.0, 2000.0, 0.5);
        this.octaves1 = this.noiseGen3.func_76304_a(this.octaves1, x, 0, z, 5, 33, 5, 8.555150000000001, 4.277575000000001, 8.555150000000001);
        this.octaves2 = this.noiseGen1.func_76304_a(this.octaves2, x, 0, z, 5, 33, 5, 684.412, 684.412, 684.412);
        this.octaves3 = this.noiseGen2.func_76304_a(this.octaves3, x, 0, z, 5, 33, 5, 684.412, 684.412, 684.412);
        int i = 0;
        int j = 0;
        for (int k = 0; k < 5; ++k) {
            for (int l = 0; l < 5; ++l) {
                float f2 = 0.0f;
                float f3 = 0.0f;
                float f4 = 0.0f;
                int i1 = 2;
                Biome biomegenbase = this.biomesForGeneration[k + 2 + (l + 2) * 10];
                for (int j1 = -i1; j1 <= i1; ++j1) {
                    for (int k1 = -i1; k1 <= i1; ++k1) {
                        Biome biomegenbase1 = this.biomesForGeneration[k + j1 + 2 + (l + k1 + 2) * 10];
                        float f5 = biomegenbase1.func_185355_j();
                        float f6 = biomegenbase1.func_185360_m();
                        if (this.worldType == WorldType.field_151360_e && f5 > 0.0f) {
                            f5 = 1.0f + f5 * 2.0f;
                            f6 = 1.0f + f6 * 4.0f;
                        }
                        float f7 = this.parabolicField[j1 + 2 + (k1 + 2) * 5] / (f5 + 2.0f);
                        if (biomegenbase1.func_185355_j() > biomegenbase.func_185355_j()) {
                            f7 /= 2.0f;
                        }
                        f2 += f6 * f7;
                        f3 += f5 * f7;
                        f4 += f7;
                    }
                }
                f2 /= f4;
                f3 /= f4;
                f2 = f2 * 0.9f + 0.1f;
                f3 = (f3 * 4.0f - 1.0f) / 8.0f;
                double d7 = this.octaves4[j] / 4000.0;
                if (d7 < 0.0) {
                    d7 = -d7 * 0.3;
                }
                if ((d7 = d7 * 3.0 - 2.0) < 0.0) {
                    if ((d7 /= 2.0) < -1.0) {
                        d7 = -1.0;
                    }
                    d7 /= 1.4;
                    d7 /= 2.0;
                } else {
                    if (d7 > 1.0) {
                        d7 = 1.0;
                    }
                    d7 /= 8.0;
                }
                ++j;
                double d8 = f3;
                double d9 = f2;
                d8 += d7 * 0.2;
                d8 = d8 * 8.5 / 8.0;
                double d0 = 8.5 + d8 * 4.0;
                for (int l1 = 0; l1 < 33; ++l1) {
                    double d1 = ((double)l1 - d0) * 12.0 * 128.0 / 256.0 / d9;
                    if (d1 < 0.0) {
                        d1 *= 4.0;
                    }
                    double d3 = this.octaves3[i] / 1024.0;
                    double d5 = d3 - d1;
                    if (l1 > 29) {
                        double d6 = (float)(l1 - 29) / 3.0f;
                        d5 = d5 * (1.0 - d6) + -10.0 * d6;
                    }
                    this.terrainCalcs[i] = d5;
                    ++i;
                }
            }
        }
    }

    public void func_185931_b(int x, int z) {
        int i2;
        BlockFalling.field_149832_M = true;
        int i = x * 16;
        int j = z * 16;
        BlockPos blockpos = new BlockPos(i, 0, j);
        Biome biomegenbase = this.world.func_180494_b(blockpos.func_177982_a(16, 0, 16));
        this.rand.setSeed(this.world.func_72905_C());
        long k = this.rand.nextLong() / 2L * 2L + 1L;
        long l = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)x * k + (long)z * l ^ this.world.func_72905_C());
        boolean isValley = biomegenbase instanceof BiomeAdaptive && ((BiomeAdaptive)biomegenbase).isInstance(BiomeGenVenusValley.class);
        if (this.rand.nextInt(isValley ? 3 : 10) == 0) {
            i2 = this.rand.nextInt(16) + 8;
            int l2 = this.rand.nextInt(this.rand.nextInt(248) + 8);
            int k3 = this.rand.nextInt(16) + 8;
            new WorldGenLakesVenus().func_180709_b(this.world, this.rand, blockpos.func_177982_a(i2, l2, k3));
        }
        if (isValley) {
            int l2;
            int k3;
            if (this.rand.nextInt(5) == 0) {
                i2 = this.rand.nextInt(16) + 8;
                k3 = this.rand.nextInt(16) + 8;
                l2 = this.world.func_175672_r(blockpos.func_177982_a(i2, 0, k3)).func_177956_o() - 10 - this.rand.nextInt(5);
                new WorldGenVaporPool().func_180709_b(this.world, this.rand, blockpos.func_177982_a(i2, l2, k3));
            } else if (this.rand.nextInt(190) == 0) {
                i2 = this.rand.nextInt(16) + 8;
                k3 = this.rand.nextInt(16) + 8;
                l2 = this.world.func_175672_r(blockpos.func_177982_a(i2, 0, k3)).func_177956_o();
                new WorldGenCrashedProbe().func_180709_b(this.world, this.rand, blockpos.func_177982_a(i2, l2, k3));
            }
        }
        this.dungeonGenerator.func_175794_a(this.world, this.rand, new ChunkPos(x, z));
        biomegenbase.func_180624_a(this.world, this.rand, new BlockPos(i, 0, j));
        WorldEntitySpawner.func_77191_a((World)this.world, (Biome)biomegenbase, (int)(i + 8), (int)(j + 8), (int)16, (int)16, (Random)this.rand);
        BlockFalling.field_149832_M = false;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        Biome biomegenbase = this.world.func_180494_b(pos);
        return biomegenbase.func_76747_a(creatureType);
    }

    public void func_180514_a(Chunk chunk, int x, int z) {
        this.dungeonGenerator.func_186125_a(this.world, x, z, null);
    }
}

