/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.util.list;

import com.google.common.base.Preconditions;
import com.google.common.collect.ObjectArrays;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Predicate;

public abstract class Immutable<E>
extends ArrayList<E>
implements Serializable {
    private static final long serialVersionUID = -3175142460104260006L;
    static final int SPLITERATOR_CHARACTERISTICS = 1296;
    static final Object[] EMPTY_ARRAY = new Object[0];

    public Immutable() {
    }

    public Immutable(Collection<E> collection) {
        super(collection);
    }

    @Override
    public abstract Iterator<E> iterator();

    @Override
    public Spliterator<E> spliterator() {
        return Spliterators.spliterator(this, 1296);
    }

    @Override
    public final Object[] toArray() {
        int size = this.size();
        if (size == 0) {
            return EMPTY_ARRAY;
        }
        Object[] result = new Object[size];
        this.copyIntoArray(result, 0);
        return result;
    }

    @Override
    public final <T> T[] toArray(T[] other) {
        Preconditions.checkNotNull(other);
        int size = this.size();
        if (other.length < size) {
            other = ObjectArrays.newArray((Object[])other, (int)size);
        } else if (other.length > size) {
            other[size] = null;
        }
        this.copyIntoArray(other, 0);
        return other;
    }

    int copyIntoArray(Object[] dst, int offset) {
        for (Object e : this) {
            dst[offset++] = e;
        }
        return offset;
    }

    @Override
    @Deprecated
    public final boolean add(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final boolean remove(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final boolean addAll(Collection<? extends E> newElements) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final boolean removeAll(Collection<?> oldElements) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final boolean removeIf(Predicate<? super E> filter) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final boolean retainAll(Collection<?> elementsToKeep) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final void clear() {
        throw new UnsupportedOperationException();
    }

    public static abstract class Iterator<E>
    implements ListIterator<E> {
        private final int size;
        private int position;

        protected abstract E get(int var1);

        protected Iterator(int size) {
            this(size, 0);
        }

        protected Iterator(int size, int position) {
            Preconditions.checkPositionIndex((int)position, (int)size);
            this.size = size;
            this.position = position;
        }

        protected Iterator() {
            this.size = 0;
            this.position = 0;
        }

        @Override
        public final boolean hasNext() {
            return this.position < this.size;
        }

        @Override
        public final E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.get(this.position++);
        }

        @Override
        public final int nextIndex() {
            return this.position;
        }

        @Override
        public final boolean hasPrevious() {
            return this.position > 0;
        }

        @Override
        public final E previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            return this.get(--this.position);
        }

        @Override
        public final int previousIndex() {
            return this.position - 1;
        }

        @Override
        @Deprecated
        public final void add(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public final void set(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public final void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

