/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialType;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.util.ASMUtil;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.util.text.translation.LanguageMap;

@ParametersAreNonnullByDefault
public class TranslateUtil {
    private static TranslateUtil instance = TranslateUtil.getInstance();
    private Map<String, String> celestialKeys = new HashMap<String, String>();

    private TranslateUtil() {
        try {
            Optional langMapInstance = ASMUtil.getStaticObject(LanguageMap.class, "instance");
            this.populateMap((Map)ASMUtil.getPrivateValue(LanguageMap.class, langMapInstance.get(), "languageList"));
        }
        catch (Exception e) {
            GalacticraftCore.logger.error(e, "An error occured when trying to retreive LanguageMap");
        }
    }

    private void populateMap(Map<String, String> map) {
        Collection<String> names = CelestialType.getAllNames();
        for (String type : names) {
            map.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(type)).collect(Collectors.toSet()).forEach(e -> this.celestialKeys.put(((String)e.getKey()).toLowerCase(), (String)e.getValue()));
        }
    }

    public static void generateMaps() {
        if (instance != null) {
            return;
        }
        instance = new TranslateUtil();
    }

    public static TranslateUtil getInstance() {
        return instance;
    }

    public String translate(String translationKey) {
        for (Map.Entry<String, String> s : this.celestialKeys.entrySet()) {
            if (!s.getKey().startsWith(translationKey)) continue;
            return s.getValue();
        }
        return I18n.func_74838_a((String)translationKey);
    }
}

