/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.BlockEnclosed;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldType;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.fml.common.Loader;

public class CompatibilityManager {
    public static final String modidIC2 = "ic2";
    public static final String modidMekanism = "mekanism";
    public static final String modidBuildcraft = "buildcraftcore";
    public static final String modBCraftTransport = "buildcrafttransport";
    public static final String modBCraftEnergy = "buildcraftenergy";
    public static boolean PlayerAPILoaded = Loader.isModLoaded((String)"PlayerAPI");
    public static boolean RenderPlayerAPILoaded = Loader.isModLoaded((String)"RenderPlayerAPI");
    public static boolean modJEILoaded = Loader.isModLoaded((String)"jei");
    private static boolean modIc2Loaded = Loader.isModLoaded((String)"ic2");
    private static boolean modICClassicLoaded;
    public static boolean modBCraftLoaded;
    private static boolean modBCraftEnergyLoaded;
    private static boolean modBCraftTransportLoaded;
    private static boolean modGTLoaded;
    private static boolean modTELoaded;
    private static boolean modMekLoaded;
    private static boolean modAetherIILoaded;
    private static boolean modBasicComponentsLoaded;
    private static boolean modAppEngLoaded;
    private static boolean modPneumaticCraftLoaded;
    private static boolean modBOPLoaded;
    private static boolean modEIOLoaded;
    public static boolean modAALoaded;
    private static boolean spongeLoaded;
    private static boolean modMatterOverdriveLoaded;
    private static boolean wailaLoaded;
    public static boolean isMFRLoaded;
    public static boolean isSmartMovingLoaded;
    public static boolean isTConstructLoaded;
    public static boolean isWitcheryLoaded;
    public static boolean isCubicChunksLoaded;
    public static Class<?> classGTOre;
    private static Method spongeOverrideSet;
    private static Method spongeOverrideGet;
    public static Class classBCTransport;
    public static Class classBCTransportPipeTile;
    public static Class classBOPWorldType;
    public static Class classBOPws;
    public static Class classBOPwcm;
    public static Class classIC2wrench;
    public static Class classIC2wrenchElectric;
    public static Class classIC2tileEventLoad;
    public static Class classIC2tileEventUnload;
    public static Field fieldIC2tickhandler;
    public static Field fieldIC2networkManager;
    public static Class classIc2ClassicNetworkManager;
    public static Class classIC2cableType;
    public static Constructor constructorIC2cableTE;
    private static Method androidPlayerGet;
    private static Method androidPlayerIsAndroid;
    public static Class classIc2ClassicTileCable;

    public static void checkForCompatibleMods() {
        if (Loader.isModLoaded((String)"gregtech") || Loader.isModLoaded((String)"gregtech_addon")) {
            modGTLoaded = true;
        }
        if (modMekLoaded) {
            GalacticraftCore.logger.info("Activating Mekanism compatibility.", new Object[0]);
        }
        if (isMFRLoaded) {
            GalacticraftCore.logger.info("Activating MFR compatibility feature.", new Object[0]);
        }
        if (modTELoaded) {
            GalacticraftCore.logger.info("Activating ThermalExpansion compatibility features.", new Object[0]);
        }
        if (isTConstructLoaded) {
            GalacticraftCore.logger.info("Activating Tinker's Construct compatibility features.", new Object[0]);
        }
        if (modIc2Loaded) {
            try {
                classIc2ClassicTileCable = Class.forName("ic2.core.block.wiring.tile.TileEntityCable");
                classIc2ClassicNetworkManager = Class.forName("ic2.core.network.NetworkManager");
                modICClassicLoaded = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (!modICClassicLoaded) {
                try {
                    classIC2cableType = Class.forName("ic2.core.block.wiring.CableType");
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
            try {
                Class<?> classIC2cable;
                try {
                    classIC2wrench = Class.forName("ic2.core.item.tool.ItemToolWrench");
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
                try {
                    classIC2wrenchElectric = Class.forName("ic2.core.item.tool.ItemToolWrenchElectric");
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
                try {
                    classIC2tileEventLoad = Class.forName("ic2.api.energy.event.EnergyTileLoadEvent");
                    classIC2tileEventUnload = Class.forName("ic2.api.energy.event.EnergyTileUnloadEvent");
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
                try {
                    Class<?> clazzIC2 = Class.forName("ic2.core.IC2");
                    fieldIC2networkManager = clazzIC2.getDeclaredField("network");
                    fieldIC2tickhandler = clazzIC2.getDeclaredField("tickHandler");
                }
                catch (Exception clazzIC2) {
                    // empty catch block
                }
                try {
                    classIC2cable = Class.forName("ic2.core.block.wiring.TileEntityCable");
                }
                catch (ClassNotFoundException e) {
                    try {
                        classIC2cable = Class.forName("ic2.core.block.wiring.tile.TileEntityCable");
                    }
                    catch (Exception e1) {
                        classIC2cable = null;
                    }
                }
                if (classIC2cable != null) {
                    Constructor<?>[] constructors;
                    try {
                        BlockEnclosed.onBlockNeighbourChangeIC2a = classIC2cable.getMethod("onNeighborChange", Block.class);
                    }
                    catch (Exception e) {
                        try {
                            BlockEnclosed.onBlockNeighbourChangeIC2b = classIC2cable.getMethod("onNeighborChange", Block.class, BlockPos.class);
                        }
                        catch (Exception e1) {
                            BlockEnclosed.onBlockNeighbourChangeIC2a = classIC2cable.getMethod("onBlockUpdate", Block.class);
                        }
                    }
                    for (Constructor<?> constructor2 : constructors = classIC2cable.getDeclaredConstructors()) {
                        if (constructor2.getGenericParameterTypes().length != 2) continue;
                        constructorIC2cableTE = constructor2;
                        break;
                    }
                }
                GalacticraftCore.logger.info("Activating IndustrialCraft2 compatibility features.", new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (Loader.isModLoaded((String)modBCraftTransport)) {
            modBCraftTransportLoaded = true;
            try {
                classBCTransport = Class.forName("buildcraft.transport.BCTransportItems");
                classBCTransportPipeTile = Class.forName("buildcraft.transport.tile.TilePipeHolder");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            BlockEnclosed.initialiseBC();
            if (classBCTransportPipeTile == null) {
                modBCraftTransportLoaded = false;
            } else {
                GalacticraftCore.logger.info("Activating BuildCraft Transport (Pipes) compatibility features.", new Object[0]);
            }
        }
        if (modBOPLoaded) {
            try {
                classBOPWorldType = Class.forName("biomesoplenty.common.world.WorldTypeBOP");
                classBOPws = Class.forName("biomesoplenty.common.world.BOPWorldSettings");
                classBOPwcm = Class.forName("biomesoplenty.common.world.BiomeProviderBOP");
                GalacticraftCore.logger.info("Activating Biomes O'Plenty compatibility feature.", new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (Loader.isModLoaded((String)"aetherii")) {
            modAetherIILoaded = true;
            GalacticraftCore.logger.info("Activating AetherII compatibility feature.", new Object[0]);
        }
        if (Loader.isModLoaded((String)"basiccomponents")) {
            modBasicComponentsLoaded = true;
        }
        if (Loader.isModLoaded((String)"appliedenergistics2")) {
            modAppEngLoaded = true;
            GalacticraftCore.logger.info("Activating AppliedEnergistics2 compatibility features.", new Object[0]);
        }
        if (Loader.isModLoaded((String)"pneumaticcraft")) {
            modPneumaticCraftLoaded = true;
            GalacticraftCore.logger.info("Activating PneumaticCraft compatibility features.", new Object[0]);
        }
        if (Loader.isModLoaded((String)"waila")) {
            wailaLoaded = true;
            GalacticraftCore.logger.info("Activating WAILA compatibility features.", new Object[0]);
        }
        if (Loader.isModLoaded((String)"sponge")) {
            try {
                Class<?> clazz = Class.forName("org.spongepowered.common.interfaces.world.gen.IMixinChunkProviderServer");
                spongeOverrideSet = clazz.getMethod("setForceChunkRequests", Boolean.TYPE);
                spongeOverrideGet = clazz.getMethod("getForceChunkRequests", new Class[0]);
                spongeLoaded = true;
            }
            catch (Exception e) {
                try {
                    Class<?> clazz = Class.forName("org.spongepowered.common.bridge.world.chunk.ChunkProviderServerBridge");
                    spongeOverrideSet = clazz.getMethod("bridge$setForceChunkRequests", Boolean.TYPE);
                    spongeOverrideGet = clazz.getMethod("bridge$getForceChunkRequests", new Class[0]);
                    spongeLoaded = true;
                }
                catch (Exception enew) {
                    enew.printStackTrace();
                }
            }
        }
        if (Loader.isModLoaded((String)"cubicchunks")) {
            isCubicChunksLoaded = true;
        }
        if (Loader.isModLoaded((String)"matteroverdrive")) {
            try {
                Class<?> androidPlayer = Class.forName("matteroverdrive.entity.android_player.AndroidPlayer");
                Class<?> androidCapability = Class.forName("matteroverdrive.entity.player.MOPlayerCapabilityProvider");
                androidPlayerGet = androidCapability.getMethod("GetAndroidCapability", Entity.class);
                androidPlayerIsAndroid = androidPlayer.getMethod("isAndroid", new Class[0]);
                modMatterOverdriveLoaded = true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean isIc2Loaded() {
        return modIc2Loaded;
    }

    public static boolean isIc2ClassicLoaded() {
        return modICClassicLoaded;
    }

    public static boolean isBCraftTransportLoaded() {
        return modBCraftTransportLoaded;
    }

    public static boolean isBCraftEnergyLoaded() {
        return modBCraftEnergyLoaded;
    }

    public static boolean isTELoaded() {
        return modTELoaded;
    }

    public static boolean isMekanismLoaded() {
        return modMekLoaded;
    }

    public static boolean isGTLoaded() {
        return modGTLoaded;
    }

    public static boolean isAIILoaded() {
        return modAetherIILoaded;
    }

    public static boolean isBCLoaded() {
        return modBasicComponentsLoaded;
    }

    public static boolean isAppEngLoaded() {
        return modAppEngLoaded;
    }

    public static boolean isBOPLoaded() {
        return modBOPLoaded;
    }

    public static boolean isBOPWorld(WorldType worldType) {
        if (modBOPLoaded && classBOPWorldType != null && classBOPws != null && classBOPwcm != null) {
            return classBOPWorldType.isInstance(worldType);
        }
        return false;
    }

    public static boolean isPneumaticCraftLoaded() {
        return modPneumaticCraftLoaded;
    }

    public static boolean isWailaLoaded() {
        return wailaLoaded;
    }

    public static void spongeOverrideStart(WorldServer w) {
    }

    public static boolean forceLoadChunks(WorldServer w) {
        Boolean spongeForceChunksPrevious = null;
        if (spongeLoaded) {
            ChunkProviderServer cps = w.func_72863_F();
            try {
                spongeForceChunksPrevious = (Boolean)spongeOverrideGet.invoke((Object)cps, new Object[0]);
                spongeOverrideSet.invoke((Object)cps, true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Boolean.TRUE.equals(spongeForceChunksPrevious);
    }

    public static void forceLoadChunksEnd(WorldServer w, boolean previous) {
        if (spongeLoaded) {
            try {
                spongeOverrideSet.invoke((Object)w.func_72863_F(), previous);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void registerMicroBlocks() {
        try {
            Class<?> clazz = Class.forName("codechicken.microblock.MicroMaterialRegistry");
            if (clazz != null) {
                Method[] methodz;
                Method registerMethod = null;
                for (Method m : methodz = clazz.getMethods()) {
                    if (!m.getName().equals("registerMaterial")) continue;
                    registerMethod = m;
                    break;
                }
                Class<?> clazzbm = Class.forName("codechicken.microblock.BlockMicroMaterial");
                registerMethod.invoke(null, clazzbm.getConstructor(Block.class, Integer.TYPE).newInstance(GCBlocks.basicBlock, 3), "tile.gcBlockCore.decoblock1");
                registerMethod.invoke(null, clazzbm.getConstructor(Block.class, Integer.TYPE).newInstance(GCBlocks.basicBlock, 4), "tile.gcBlockCore.decoblock2");
                registerMethod.invoke(null, clazzbm.getConstructor(Block.class, Integer.TYPE).newInstance(GCBlocks.basicBlock, 9), "tile.gcBlockCore.copperBlock");
                registerMethod.invoke(null, clazzbm.getConstructor(Block.class, Integer.TYPE).newInstance(GCBlocks.basicBlock, 10), "tile.gcBlockCore.tinBlock");
                registerMethod.invoke(null, clazzbm.getConstructor(Block.class, Integer.TYPE).newInstance(GCBlocks.basicBlock, 11), "tile.gcBlockCore.aluminumBlock");
                registerMethod.invoke(null, clazzbm.getConstructor(Block.class, Integer.TYPE).newInstance(GCBlocks.basicBlock, 12), "tile.gcBlockCore.meteorironBlock");
                registerMethod.invoke(null, clazzbm.getConstructor(Block.class, Integer.TYPE).newInstance(GCBlocks.blockMoon, 3), "tile.moonBlock.moondirt");
                registerMethod.invoke(null, clazzbm.getConstructor(Block.class, Integer.TYPE).newInstance(GCBlocks.blockMoon, 4), "tile.moonBlock.moonstone");
                registerMethod.invoke(null, clazzbm.getConstructor(Block.class, Integer.TYPE).newInstance(GCBlocks.blockMoon, 5), "tile.moonBlock.moongrass");
                registerMethod.invoke(null, clazzbm.getConstructor(Block.class, Integer.TYPE).newInstance(GCBlocks.blockMoon, 14), "tile.moonBlock.bricks");
                GalacticraftCore.logger.info("Activating CodeChicken Microblocks compatibility.", new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isAndroid(EntityPlayer player) {
        if (modMatterOverdriveLoaded) {
            try {
                Object androidPlayer = androidPlayerGet.invoke(null, player);
                if (androidPlayer != null) {
                    return (Boolean)androidPlayerIsAndroid.invoke(androidPlayer, new Object[0]);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean useAluDust() {
        return modIc2Loaded || modAppEngLoaded || modTELoaded || modEIOLoaded || modAALoaded;
    }

    static {
        modBCraftLoaded = Loader.isModLoaded((String)modidBuildcraft);
        modBCraftEnergyLoaded = Loader.isModLoaded((String)modBCraftEnergy);
        modTELoaded = Loader.isModLoaded((String)"thermalexpansion");
        modMekLoaded = Loader.isModLoaded((String)modidMekanism);
        modBOPLoaded = Loader.isModLoaded((String)"biomesoplenty");
        modEIOLoaded = Loader.isModLoaded((String)"enderio");
        modAALoaded = Loader.isModLoaded((String)"actuallyadditions");
        isMFRLoaded = Loader.isModLoaded((String)"minefactoryreloaded");
        isSmartMovingLoaded = Loader.isModLoaded((String)"smartmoving");
        isTConstructLoaded = Loader.isModLoaded((String)"tconstruct");
        isWitcheryLoaded = Loader.isModLoaded((String)"witchery");
        classGTOre = null;
        spongeOverrideSet = null;
        spongeOverrideGet = null;
        classBOPWorldType = null;
        classBOPws = null;
        classBOPwcm = null;
        classIC2wrench = null;
        classIC2wrenchElectric = null;
        classIC2cableType = null;
        constructorIC2cableTE = null;
    }
}

