/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.util;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.relauncher.FMLLaunchHandler;
import org.apache.commons.lang3.StringUtils;

public class ASMUtil {
    private static HashMap<String, Field> sFieldCache = new HashMap();

    public static <T> T getInstance(Constructor<T> constructor, Object ... arguments) {
        try {
            return constructor.newInstance(arguments);
        }
        catch (Exception e) {
            GalacticraftCore.logger.error("Exception creating instance of " + constructor.getClass().getName(), new Object[0]);
            return null;
        }
    }

    public static <T> T getInstance(String className, Class<T> assignable) {
        try {
            Class<?> clazz = Class.forName(className);
            if (!assignable.isAssignableFrom(assignable)) {
                throw new RuntimeException("Class '" + className + "' is not assignable from " + assignable.getSimpleName());
            }
            return (T)clazz.newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            GalacticraftCore.logger.error("Exception creating instance of " + className, new Object[0]);
            return null;
        }
    }

    public static Constructor<?> getConstructor(String className, Class<?> ... argumentTypes) {
        if (className == null || argumentTypes == null) {
            GalacticraftCore.logger.error("The provided class name or arguments can't be null.", new Object[0]);
            return null;
        }
        try {
            Class<?> clazz = Class.forName(className);
            Constructor<?> constructor = clazz.getDeclaredConstructor(argumentTypes);
            constructor.setAccessible(true);
            return constructor;
        }
        catch (Exception ex) {
            GalacticraftCore.logger.error("Exception getting constructor of " + className, new Object[0]);
            return null;
        }
    }

    public static <T> Constructor<T> getConstructor(Class<T> clazz, Class<?> ... types) {
        try {
            Constructor<T> constructor = clazz.getDeclaredConstructor(types);
            constructor.setAccessible(true);
            return constructor;
        }
        catch (Exception ex) {
            GalacticraftCore.logger.error("Exception getting constructor of " + clazz.getName(), new Object[0]);
            return null;
        }
    }

    public static <T> T getObject(Object object, String ... fieldNames) {
        Class<?> cls = object.getClass();
        for (String field : fieldNames) {
            try {
                Field result = cls.getDeclaredField(field);
                result.setAccessible(true);
                return (T)result.get(object);
            }
            catch (Exception ex) {
                GalacticraftCore.logger.error("Exception in getObject()", new Object[0]);
            }
        }
        GalacticraftCore.logger.error("Could not retrieve any object for the provided field names.", new Object[0]);
        return null;
    }

    public static <T> T getFinalObject(Object object, String ... fieldNames) {
        Class<?> cls = object.getClass();
        for (String field : fieldNames) {
            try {
                Field result = cls.getDeclaredField(field);
                result.setAccessible(true);
                Field modifiersField = Field.class.getDeclaredField("modifiers");
                modifiersField.setAccessible(true);
                modifiersField.setInt(result, result.getModifiers() & 0xFFFFFFEF);
                return (T)result.get(object);
            }
            catch (Exception ex) {
                GalacticraftCore.logger.error("Exception in getFinalObject()", new Object[0]);
            }
        }
        GalacticraftCore.logger.error("Could not retrieve any final object for the provided field names.", new Object[0]);
        return null;
    }

    public static <T> Optional<T> getStaticObject(Class<?> clazz, String fieldName) {
        Optional<Object> object = Optional.empty();
        try {
            Field result = clazz.getDeclaredField(fieldName);
            result.setAccessible(true);
            object = Optional.of(result.get(null));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return object;
    }

    @Nonnull
    public static Method findMethod(@Nonnull Class<?> clazz, @Nonnull String methodName, Class<?> ... parameterTypes) {
        Preconditions.checkNotNull(clazz);
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)methodName), (Object)"Method name cannot be empty");
        try {
            Method m = clazz.getDeclaredMethod(methodName, parameterTypes);
            m.setAccessible(true);
            return m;
        }
        catch (Exception e) {
            throw new ReflectionThrows.UnableToFindMethodException(e);
        }
    }

    @Nonnull
    public static Method findMethod(@Nonnull Class<?> clazz, @Nonnull String methodName, @Nullable String methodObfName, Class<?> ... parameterTypes) {
        Preconditions.checkNotNull(clazz);
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)methodName), (Object)"Method name cannot be empty");
        String nameToFind = FMLLaunchHandler.isDeobfuscatedEnvironment() ? methodName : (String)MoreObjects.firstNonNull((Object)methodObfName, (Object)methodName);
        try {
            Method m = clazz.getDeclaredMethod(nameToFind, parameterTypes);
            m.setAccessible(true);
            return m;
        }
        catch (Exception e) {
            throw new ReflectionThrows.UnableToFindMethodException(e);
        }
    }

    public static <T, E> T getPrivateValue(Class<? super E> classToAccess, @Nullable E instance, String fieldName) {
        try {
            return (T)ASMUtil.findField(classToAccess, fieldName, null).get(instance);
        }
        catch (Exception e) {
            e.getStackTrace();
            return null;
        }
    }

    public static <T, E> T getPrivateValue(Class<? super E> classToAccess, @Nullable E instance, String fieldName, @Nullable String fieldObfName) {
        try {
            return (T)ASMUtil.findField(classToAccess, fieldName, fieldObfName).get(instance);
        }
        catch (Exception e) {
            e.getStackTrace();
            return null;
        }
    }

    public static <T, E> void setPrivateValue(Class<? super T> classToAccess, @Nullable T instance, @Nullable E value, String fieldName) {
        try {
            ASMUtil.findField(classToAccess, fieldName, null).set(instance, value);
        }
        catch (Exception e) {
            e.getStackTrace();
        }
    }

    public static <T, E> void setPrivateValue(Class<? super T> classToAccess, @Nullable T instance, @Nullable E value, String fieldName, @Nullable String fieldObfName) {
        try {
            ASMUtil.findField(classToAccess, fieldName, fieldObfName).set(instance, value);
        }
        catch (Exception e) {
            e.getStackTrace();
        }
    }

    public static Field findField(@Nonnull Class<?> clazz, @Nonnull String fieldName, @Nullable String fieldObfName) {
        Preconditions.checkNotNull(clazz);
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)fieldName), (Object)"Field name cannot be empty");
        String nameToFind = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment") != false ? fieldName : (String)MoreObjects.firstNonNull((Object)fieldObfName, (Object)fieldName);
        try {
            Field f = clazz.getDeclaredField(nameToFind);
            f.setAccessible(true);
            return f;
        }
        catch (Exception e) {
            e.getStackTrace();
            return null;
        }
    }

    public static void setStaticFieldObject(Class<?> clazz, String fieldName, Object value) {
        Field field = ASMUtil.getStaticField(clazz, fieldName);
        try {
            field.set(clazz, value);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            GalacticraftCore.logger.error("An error occured when attempting to set static Field [ " + fieldName + " ]", new Object[0]);
        }
    }

    private static Field getStaticField(Class<?> clazz, String fieldName) {
        Preconditions.checkNotNull(clazz);
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)fieldName), (Object)"Field name cannot be empty");
        String fullFieldName = ASMUtil.genFieldFullName(clazz, fieldName);
        if (sFieldCache.containsKey(fullFieldName)) {
            return sFieldCache.get(fullFieldName);
        }
        Field field = null;
        try {
            field = clazz.getField(fieldName);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        if (field == null) {
            try {
                field = clazz.getDeclaredField(fieldName);
                field.setAccessible(true);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
        if (field == null) {
            for (clazz = clazz.getSuperclass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
                try {
                    field = clazz.getDeclaredField(fieldName);
                    field.setAccessible(true);
                    continue;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    // empty catch block
                }
            }
        }
        if (field == null) {
            GalacticraftCore.logger.error("Can't get [ " + fieldName + " ] Field from Class [ " + clazz.getSimpleName() + " ]", new Object[0]);
        }
        sFieldCache.put(fullFieldName, field);
        return field;
    }

    private static String genFieldFullName(Class<?> clazz, String fieldName) {
        StringBuilder name = new StringBuilder();
        name.append(clazz.getName());
        name.append(":");
        name.append(fieldName);
        return name.toString();
    }

    public static <E> String getBiomeName(Biome.BiomeProperties instance) {
        return (String)ASMUtil.getPrivateValue(Biome.BiomeProperties.class, instance, "biomeName", "field_185412_a");
    }

    static class ReflectionThrows {
        ReflectionThrows() {
        }

        public static class UnknownConstructorException
        extends RuntimeException {
            public UnknownConstructorException(String message) {
                super(message);
            }
        }

        public static class UnableToFindFieldException
        extends RuntimeException {
            private static final long serialVersionUID = 1L;

            public UnableToFindFieldException(String[] fieldNameList, Exception e) {
                super(e);
            }

            public UnableToFindFieldException(Exception e) {
                super(e);
            }
        }

        public static class UnableToAccessFieldException
        extends RuntimeException {
            private static final long serialVersionUID = 1L;

            public UnableToAccessFieldException(String[] fieldNames, Exception e) {
                super(e);
            }

            public UnableToAccessFieldException(Exception e) {
                super(e);
            }
        }

        public static class UnableToFindClassException
        extends RuntimeException {
            private static final long serialVersionUID = 1L;

            public UnableToFindClassException(String[] classNames, @Nullable Exception err) {
                super(err);
            }
        }

        public static class UnableToFindMethodException
        extends RuntimeException {
            private static final long serialVersionUID = 1L;

            public UnableToFindMethodException(String[] methodNames, Exception failed) {
                super(failed);
            }

            public UnableToFindMethodException(Throwable failed) {
                super(failed);
            }
        }
    }
}

