/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tick;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import micdoodle8.mods.galacticraft.api.block.IDetectableResource;
import micdoodle8.mods.galacticraft.api.entity.IEntityNoisy;
import micdoodle8.mods.galacticraft.api.entity.IIgnoreShift;
import micdoodle8.mods.galacticraft.api.item.ISensorGlassesArmor;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntityAutoRocket;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntitySpaceshipBase;
import micdoodle8.mods.galacticraft.api.recipe.CompressorRecipes;
import micdoodle8.mods.galacticraft.api.vector.BlockTuple;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.client.BubbleRenderer;
import micdoodle8.mods.galacticraft.core.client.CloudRenderer;
import micdoodle8.mods.galacticraft.core.client.FootprintRenderer;
import micdoodle8.mods.galacticraft.core.client.SkyProviderMoon;
import micdoodle8.mods.galacticraft.core.client.SkyProviderOverworld;
import micdoodle8.mods.galacticraft.core.client.gui.overlay.OverlayDockingRocket;
import micdoodle8.mods.galacticraft.core.client.gui.overlay.OverlayLander;
import micdoodle8.mods.galacticraft.core.client.gui.overlay.OverlayLaunchCountdown;
import micdoodle8.mods.galacticraft.core.client.gui.overlay.OverlayOxygenTanks;
import micdoodle8.mods.galacticraft.core.client.gui.overlay.OverlayOxygenWarning;
import micdoodle8.mods.galacticraft.core.client.gui.overlay.OverlayRocket;
import micdoodle8.mods.galacticraft.core.client.gui.screen.GuiCelestialSelection;
import micdoodle8.mods.galacticraft.core.client.gui.screen.GuiNewSpaceRace;
import micdoodle8.mods.galacticraft.core.client.gui.screen.GuiTeleporting;
import micdoodle8.mods.galacticraft.core.client.jei.GalacticraftJEI;
import micdoodle8.mods.galacticraft.core.dimension.WorldProviderMoon;
import micdoodle8.mods.galacticraft.core.dimension.WorldProviderSpaceStation;
import micdoodle8.mods.galacticraft.core.entities.EntityLander;
import micdoodle8.mods.galacticraft.core.entities.IBubbleProviderColored;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStatsClient;
import micdoodle8.mods.galacticraft.core.fluid.FluidNetwork;
import micdoodle8.mods.galacticraft.core.network.GalacticraftPacketHandler;
import micdoodle8.mods.galacticraft.core.network.PacketRotateRocket;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.proxy.ClientProxyCore;
import micdoodle8.mods.galacticraft.core.tick.KeyHandlerClient;
import micdoodle8.mods.galacticraft.core.tile.TileEntityOxygenSealer;
import micdoodle8.mods.galacticraft.core.tile.TileEntityScreen;
import micdoodle8.mods.galacticraft.core.util.ColorUtil;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.MapUtil;
import micdoodle8.mods.galacticraft.core.util.OxygenUtil;
import micdoodle8.mods.galacticraft.core.util.PlayerUtil;
import micdoodle8.mods.galacticraft.core.wrappers.BlockMetaList;
import micdoodle8.mods.galacticraft.core.wrappers.Footprint;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiIngameMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldProviderSurface;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class TickHandlerClient {
    public static int airRemaining;
    public static int airRemaining2;
    private static boolean lastInvKeyPressed;
    private static long tickCount;
    public static boolean spaceRaceGuiScheduled;
    private static List<GalacticraftPacketHandler> packetHandlers;
    private static Set<FluidNetwork> fluidNetworks;
    public static GuiTeleporting teleportingGui;
    public static volatile boolean menuReset;
    public static volatile boolean updateJEIhiding;
    public static HashSet<TileEntityScreen> screenConnectionsUpdateList;

    public static void resetClient() {
        ClientProxyCore.playerItemData.clear();
        ClientProxyCore.overworldTextureRequestSent = false;
        ClientProxyCore.flagRequestsSent.clear();
        TickHandlerClient.clearLiquidNetworks();
        ClientProxyCore.clientSpaceStationID.clear();
        ConfigManagerCore.challengeModeUpdate();
        MapUtil.resetClient();
        GCBlocks.spaceGlassVanilla.resetColor();
        GCBlocks.spaceGlassClear.resetColor();
        GCBlocks.spaceGlassStrong.resetColor();
        GCBlocks.spaceGlassTinVanilla.resetColor();
        GCBlocks.spaceGlassTinClear.resetColor();
        GCBlocks.spaceGlassTinStrong.resetColor();
    }

    public static void addFluidNetwork(FluidNetwork network) {
        fluidNetworks.add(network);
    }

    public static void removeFluidNetwork(FluidNetwork network) {
        fluidNetworks.remove(network);
    }

    public static void clearLiquidNetworks() {
        fluidNetworks.clear();
    }

    public static void addPacketHandler(GalacticraftPacketHandler handler) {
        packetHandlers.add(handler);
    }

    @SubscribeEvent
    public void worldUnloadEvent(WorldEvent.Unload event) {
        for (GalacticraftPacketHandler packetHandler : packetHandlers) {
            packetHandler.unload(event.getWorld());
        }
    }

    public static void registerDetectableBlocks(boolean logging) {
        ClientProxyCore.detectableBlocks.clear();
        for (String s : ConfigManagerCore.detectableIDs) {
            BlockTuple bt = ConfigManagerCore.stringToBlock(s, "External Detectable IDs", logging);
            if (bt == null) continue;
            int meta = bt.meta;
            if (meta == -1) {
                meta = 0;
            }
            boolean flag = false;
            for (BlockMetaList blockMetaList : ClientProxyCore.detectableBlocks) {
                if (blockMetaList.getBlock() != bt.block) continue;
                if (!blockMetaList.getMetaList().contains(meta)) {
                    blockMetaList.getMetaList().add(meta);
                }
                flag = true;
                break;
            }
            if (flag) continue;
            ArrayList metaList = Lists.newArrayList();
            metaList.add(meta);
            ClientProxyCore.detectableBlocks.add(new BlockMetaList(bt.block, metaList));
        }
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        Minecraft minecraft = FMLClientHandler.instance().getClient();
        EntityPlayerSP player = minecraft.field_71439_g;
        EntityPlayerSP playerBaseClient = PlayerUtil.getPlayerBaseClientFromPlayer((EntityPlayer)player, false);
        if (player == null || playerBaseClient == null) {
            return;
        }
        GCPlayerStatsClient stats = GCPlayerStatsClient.get((Entity)playerBaseClient);
        if (event.phase == TickEvent.Phase.END) {
            if (minecraft.field_71462_r instanceof GuiIngameMenu) {
                int i = Mouse.getEventX() * minecraft.field_71462_r.field_146294_l / minecraft.field_71443_c;
                int j = minecraft.field_71462_r.field_146295_m - Mouse.getEventY() * minecraft.field_71462_r.field_146295_m / minecraft.field_71440_d - 1;
                int k = Mouse.getEventButton();
                int deltaColor = 0;
                if (i > minecraft.field_71462_r.field_146294_l - 100 && j > minecraft.field_71462_r.field_146295_m - 35) {
                    deltaColor = 20;
                    if (k == 0 && Mouse.getEventButtonState()) {
                        minecraft.func_147108_a((GuiScreen)new GuiNewSpaceRace((EntityPlayer)playerBaseClient));
                    }
                }
                this.drawGradientRect(minecraft.field_71462_r.field_146294_l - 100, minecraft.field_71462_r.field_146295_m - 35, minecraft.field_71462_r.field_146294_l, minecraft.field_71462_r.field_146295_m, ColorUtil.to32BitColor(150, 10 + deltaColor, 10 + deltaColor, 10 + deltaColor), ColorUtil.to32BitColor(250, 10 + deltaColor, 10 + deltaColor, 10 + deltaColor));
                minecraft.field_71466_p.func_78276_b(GCCoreUtil.translate("gui.space_race.create.title.name.0"), minecraft.field_71462_r.field_146294_l - 50 - minecraft.field_71466_p.func_78256_a(GCCoreUtil.translate("gui.space_race.create.title.name.0")) / 2, minecraft.field_71462_r.field_146295_m - 26, ColorUtil.to32BitColor(255, 240, 240, 240));
                minecraft.field_71466_p.func_78276_b(GCCoreUtil.translate("gui.space_race.create.title.name.1"), minecraft.field_71462_r.field_146294_l - 50 - minecraft.field_71466_p.func_78256_a(GCCoreUtil.translate("gui.space_race.create.title.name.1")) / 2, minecraft.field_71462_r.field_146295_m - 16, ColorUtil.to32BitColor(255, 240, 240, 240));
                Gui.func_73734_a((int)(minecraft.field_71462_r.field_146294_l - 100), (int)(minecraft.field_71462_r.field_146295_m - 35), (int)(minecraft.field_71462_r.field_146294_l - 99), (int)minecraft.field_71462_r.field_146295_m, (int)ColorUtil.to32BitColor(255, 0, 0, 0));
                Gui.func_73734_a((int)(minecraft.field_71462_r.field_146294_l - 100), (int)(minecraft.field_71462_r.field_146295_m - 35), (int)minecraft.field_71462_r.field_146294_l, (int)(minecraft.field_71462_r.field_146295_m - 34), (int)ColorUtil.to32BitColor(255, 0, 0, 0));
            }
            ClientProxyCore.playerPosX = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)event.renderTickTime;
            ClientProxyCore.playerPosY = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)event.renderTickTime;
            ClientProxyCore.playerPosZ = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)event.renderTickTime;
            ClientProxyCore.playerRotationYaw = player.field_70126_B + (player.field_70177_z - player.field_70126_B) * event.renderTickTime;
            ClientProxyCore.playerRotationPitch = player.field_70127_C + (player.field_70125_A - player.field_70127_C) * event.renderTickTime;
            if (minecraft.field_71462_r == null && minecraft.field_71474_y.field_74320_O != 0 && !minecraft.field_71474_y.field_74319_N) {
                if (player.func_184187_bx() instanceof EntitySpaceshipBase) {
                    OverlayRocket.renderSpaceshipOverlay(minecraft, ((EntitySpaceshipBase)player.func_184187_bx()).getSpaceshipGui());
                }
                if (player.func_184187_bx() instanceof EntityLander) {
                    OverlayLander.renderLanderOverlay(minecraft, tickCount);
                }
                if (player.func_184187_bx() instanceof EntityAutoRocket) {
                    OverlayDockingRocket.renderDockingOverlay(minecraft, tickCount);
                }
                if (player.func_184187_bx() instanceof EntitySpaceshipBase && !((EntitySpaceshipBase)minecraft.field_71439_g.func_184187_bx()).getLaunched()) {
                    OverlayLaunchCountdown.renderCountdownOverlay(minecraft);
                }
            }
            if (player.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider && OxygenUtil.shouldDisplayTankGui(minecraft.field_71462_r) && OxygenUtil.noAtmosphericCombustion(player.field_70170_p.field_73011_w) && !playerBaseClient.func_184812_l_() && !playerBaseClient.func_175149_v() && !minecraft.field_71474_y.field_74330_P) {
                int var6 = (airRemaining - 90) * -1;
                if (airRemaining <= 0) {
                    var6 = 90;
                }
                int var7 = (airRemaining2 - 90) * -1;
                if (airRemaining2 <= 0) {
                    var7 = 90;
                }
                int thermalLevel = stats.getThermalLevel() + 22;
                OverlayOxygenTanks.renderOxygenTankIndicator(minecraft, thermalLevel, var6, var7, !ConfigManagerCore.oxygenIndicatorLeft, !ConfigManagerCore.oxygenIndicatorBottom, Math.abs(thermalLevel - 22) >= 10 && !stats.isThermalLevelNormalising());
            }
            if (playerBaseClient != null && player.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider && !stats.isOxygenSetupValid() && OxygenUtil.noAtmosphericCombustion(player.field_70170_p.field_73011_w) && minecraft.field_71462_r == null && !minecraft.field_71474_y.field_74319_N && !playerBaseClient.func_184812_l_() && !playerBaseClient.func_175149_v()) {
                OverlayOxygenWarning.renderOxygenWarningOverlay(minecraft, tickCount);
            }
        }
    }

    @SubscribeEvent
    public void onPreGuiRender(RenderGameOverlayEvent.Pre event) {
        String str;
        Minecraft minecraft = FMLClientHandler.instance().getClient();
        EntityPlayerSP player = minecraft.field_71439_g;
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL && player != null && player.func_184187_bx() != null && player.func_184187_bx() instanceof IIgnoreShift && ((IIgnoreShift)player.func_184187_bx()).shouldIgnoreShiftExit() && minecraft.field_71456_v.field_73838_g.equals(str = I18n.func_135052_a((String)"mount.onboard", (Object[])new Object[]{GameSettings.func_74298_c((int)minecraft.field_71474_y.field_74311_E.func_151463_i())}))) {
            minecraft.field_71456_v.field_73838_g = "";
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        block51: {
            WorldClient world;
            block50: {
                boolean bl;
                Minecraft minecraft = FMLClientHandler.instance().getClient();
                world = minecraft.field_71441_e;
                EntityPlayerSP player = minecraft.field_71439_g;
                if (teleportingGui != null && minecraft.field_71462_r != teleportingGui) {
                    minecraft.field_71462_r = teleportingGui;
                }
                if (menuReset) {
                    TickHandlerClient.resetClient();
                    menuReset = false;
                }
                if (event.phase != TickEvent.Phase.START || player == null) break block50;
                if (ClientProxyCore.playerHead == null && player.func_146103_bH() != null) {
                    Map map = minecraft.func_152342_ad().func_152788_a(player.func_146103_bH());
                    ClientProxyCore.playerHead = map.containsKey(MinecraftProfileTexture.Type.SKIN) ? minecraft.func_152342_ad().func_152792_a((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN) : DefaultPlayerSkin.func_177334_a((UUID)EntityPlayer.func_146094_a((GameProfile)player.func_146103_bH()));
                }
                ++tickCount;
                if (!GalacticraftCore.proxy.isPaused()) {
                    Iterator<Object> it = fluidNetworks.iterator();
                    while (it.hasNext()) {
                        FluidNetwork fluidNetwork = it.next();
                        if (fluidNetwork.getTransmitters().size() == 0) {
                            it.remove();
                            continue;
                        }
                        fluidNetwork.clientTick();
                    }
                }
                if (tickCount % 20L == 0L) {
                    BubbleRenderer.clearBubbles();
                    for (TileEntity tileEntity : player.field_70170_p.field_175730_i) {
                        if (!(tileEntity instanceof IBubbleProviderColored)) continue;
                        BubbleRenderer.addBubble((IBubbleProviderColored)tileEntity);
                    }
                    if (updateJEIhiding) {
                        updateJEIhiding = false;
                        GalacticraftJEI.updateHidden(CompressorRecipes.steelIngotsPresent && ConfigManagerCore.hardMode && !ConfigManagerCore.challengeRecipes, !ConfigManagerCore.challengeRecipes);
                    }
                    for (List list : FootprintRenderer.footprints.values()) {
                        Iterator fpIt = list.iterator();
                        while (fpIt.hasNext()) {
                            Footprint fp = (Footprint)fpIt.next();
                            fp.age = (short)(fp.age + 20);
                            fp.lightmapVal = player.field_70170_p.func_175626_b(new BlockPos(fp.position.x, fp.position.y, fp.position.z), 0);
                            if (fp.age < 3200) continue;
                            fpIt.remove();
                        }
                    }
                    if (!player.field_71071_by.func_70440_f(3).func_190926_b() && player.field_71071_by.func_70440_f(3).func_77973_b() instanceof ISensorGlassesArmor) {
                        ClientProxyCore.valueableBlocks.clear();
                        for (int i = -4; i < 5; ++i) {
                            int n = MathHelper.func_76128_c((double)(player.field_70165_t + (double)i));
                            for (int j = -4; j < 5; ++j) {
                                int y = MathHelper.func_76128_c((double)(player.field_70163_u + (double)j));
                                for (int k = -4; k < 5; ++k) {
                                    int z = MathHelper.func_76128_c((double)(player.field_70161_v + (double)k));
                                    BlockPos pos = new BlockPos(n, y, z);
                                    IBlockState state = player.field_70170_p.func_180495_p(pos);
                                    Block block = state.func_177230_c();
                                    if (block.func_149688_o(state) == Material.field_151579_a) continue;
                                    int metadata = block.func_176201_c(state);
                                    boolean isDetectable = false;
                                    for (BlockMetaList blockMetaList : ClientProxyCore.detectableBlocks) {
                                        if (blockMetaList.getBlock() != block || !blockMetaList.getMetaList().contains(metadata)) continue;
                                        isDetectable = true;
                                        break;
                                    }
                                    if (!isDetectable && (!(block instanceof IDetectableResource) || !((IDetectableResource)block).isValueable(state))) continue;
                                    ClientProxyCore.valueableBlocks.add(new BlockVec3(n, y, z));
                                }
                            }
                        }
                        TileEntityOxygenSealer nearestSealer = TileEntityOxygenSealer.getNearestSealer((World)world, MathHelper.func_76128_c((double)player.field_70165_t), MathHelper.func_76128_c((double)player.field_70163_u), MathHelper.func_76128_c((double)player.field_70161_v));
                        ClientProxyCore.leakTrace = nearestSealer != null && !nearestSealer.sealed ? nearestSealer.getLeakTraceClient() : null;
                    } else {
                        ClientProxyCore.leakTrace = null;
                    }
                    if (world != null && MapUtil.resetClientFlag.getAndSet(false)) {
                        MapUtil.resetClientBody();
                    }
                }
                if (ClientProxyCore.leakTrace != null) {
                    this.spawnLeakParticles();
                }
                if (world != null && spaceRaceGuiScheduled && minecraft.field_71462_r == null && ConfigManagerCore.enableSpaceRaceManagerPopup) {
                    player.openGui((Object)GalacticraftCore.instance, 6, player.field_70170_p, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
                    spaceRaceGuiScheduled = false;
                }
                boolean inSpaceShip = false;
                if (player.func_184187_bx() instanceof EntitySpaceshipBase) {
                    inSpaceShip = true;
                    EntitySpaceshipBase entitySpaceshipBase = (EntitySpaceshipBase)player.func_184187_bx();
                    if (entitySpaceshipBase.field_70127_C != entitySpaceshipBase.field_70125_A || entitySpaceshipBase.field_70126_B != entitySpaceshipBase.field_70177_z) {
                        GalacticraftCore.packetPipeline.sendToServer(new PacketRotateRocket(player.func_184187_bx()));
                    }
                }
                if (world != null) {
                    if (world.field_73011_w instanceof WorldProviderSurface) {
                        if (world.field_73011_w.getSkyRenderer() == null && inSpaceShip && player.func_184187_bx().field_70163_u > 200.0) {
                            world.field_73011_w.setSkyRenderer((IRenderHandler)new SkyProviderOverworld());
                        } else if (world.field_73011_w.getSkyRenderer() instanceof SkyProviderOverworld && player.field_70163_u <= 200.0) {
                            world.field_73011_w.setSkyRenderer(null);
                        }
                    } else if (world.field_73011_w instanceof WorldProviderSpaceStation) {
                        if (world.field_73011_w.getSkyRenderer() == null) {
                            ((WorldProviderSpaceStation)world.field_73011_w).createSkyProvider();
                        }
                    } else if (world.field_73011_w instanceof WorldProviderMoon) {
                        if (world.field_73011_w.getSkyRenderer() == null) {
                            world.field_73011_w.setSkyRenderer((IRenderHandler)new SkyProviderMoon());
                        }
                        if (world.field_73011_w.getCloudRenderer() == null) {
                            world.field_73011_w.setCloudRenderer((IRenderHandler)new CloudRenderer());
                        }
                    }
                }
                if (inSpaceShip) {
                    EntitySpaceshipBase entitySpaceshipBase = (EntitySpaceshipBase)player.func_184187_bx();
                    boolean hasChanged = false;
                    if (minecraft.field_71474_y.field_74370_x.func_151470_d()) {
                        entitySpaceshipBase.turnYaw(-1.0f);
                        hasChanged = true;
                    }
                    if (minecraft.field_71474_y.field_74366_z.func_151470_d()) {
                        entitySpaceshipBase.turnYaw(1.0f);
                        hasChanged = true;
                    }
                    if (minecraft.field_71474_y.field_74351_w.func_151470_d() && entitySpaceshipBase.getLaunched()) {
                        entitySpaceshipBase.turnPitch(-0.7f);
                        hasChanged = true;
                    }
                    if (minecraft.field_71474_y.field_74368_y.func_151470_d() && entitySpaceshipBase.getLaunched()) {
                        entitySpaceshipBase.turnPitch(0.7f);
                        hasChanged = true;
                    }
                    if (hasChanged) {
                        GalacticraftCore.packetPipeline.sendToServer(new PacketRotateRocket(entitySpaceshipBase));
                    }
                }
                if (world != null) {
                    List list = world.field_72996_f;
                    for (Object e : list) {
                        ISound noise;
                        IEntityNoisy vehicle;
                        if (!(e instanceof IEntityNoisy) || (vehicle = (IEntityNoisy)e).getSoundUpdater() != null || (noise = vehicle.setSoundUpdater(FMLClientHandler.instance().getClient().field_71439_g)) == null) continue;
                        FMLClientHandler.instance().getClient().func_147118_V().func_147682_a(noise);
                    }
                }
                if (FMLClientHandler.instance().getClient().field_71462_r instanceof GuiCelestialSelection) {
                    player.field_70181_x = 0.0;
                }
                if (world != null && world.field_73011_w instanceof IGalacticraftWorldProvider && OxygenUtil.noAtmosphericCombustion(world.field_73011_w) && ((IGalacticraftWorldProvider)world.field_73011_w).shouldDisablePrecipitation()) {
                    world.func_72894_k(0.0f);
                }
                if (!(bl = KeyHandlerClient.spaceKey.func_151470_d())) {
                    ClientProxyCore.lastSpacebarDown = false;
                }
                if (player.func_184187_bx() != null && bl && !ClientProxyCore.lastSpacebarDown) {
                    GalacticraftCore.packetPipeline.sendToServer(new PacketSimple(PacketSimple.EnumSimplePacket.S_IGNITE_ROCKET, GCCoreUtil.getDimensionID(player.field_70170_p), new Object[0]));
                    ClientProxyCore.lastSpacebarDown = true;
                }
                if (screenConnectionsUpdateList.isEmpty()) break block51;
                HashSet updateListCopy = (HashSet)screenConnectionsUpdateList.clone();
                screenConnectionsUpdateList.clear();
                for (TileEntityScreen te : updateListCopy) {
                    if (te.func_145831_w().func_180495_p(te.func_174877_v()).func_177230_c() != GCBlocks.screen) continue;
                    if (te.refreshOnUpdate) {
                        te.refreshConnections(true);
                    }
                    te.func_145831_w().func_175704_b(te.func_174877_v(), te.func_174877_v());
                }
                break block51;
            }
            if (event.phase == TickEvent.Phase.END && world != null) {
                for (GalacticraftPacketHandler galacticraftPacketHandler : packetHandlers) {
                    galacticraftPacketHandler.tick((World)world);
                }
            }
        }
    }

    private void spawnLeakParticles() {
        Random rand = new Random();
        for (int i = ClientProxyCore.leakTrace.size() - 1; i >= 0; --i) {
            if (i == 1) continue;
            BlockVec3 curr = ClientProxyCore.leakTrace.get(i);
            int nx = i - 2;
            if (i > 2 && rand.nextInt(3) == 0) {
                --nx;
            }
            BlockVec3 vec = i > 1 ? ClientProxyCore.leakTrace.get(nx).clone() : curr.clone().translate(0, -2, 0);
            Vector3 mot = new Vector3(vec.subtract(curr));
            Vector3 rnd = new Vector3(rand.nextDouble() / 2.0 - 0.25, rand.nextDouble() / 2.0 - 0.25, rand.nextDouble() / 2.0 - 0.25);
            GalacticraftCore.proxy.spawnParticle("oxygen", curr.midPoint().add(rnd), mot, new Object[]{new Vector3(0.7, 0.7, 1.0)});
        }
    }

    private boolean alreadyContainsBlock(int x1, int y1, int z1) {
        return ClientProxyCore.valueableBlocks.contains(new BlockVec3(x1, y1, z1));
    }

    public static void zoom(float value) {
    }

    private void drawGradientRect(int par1, int par2, int par3, int par4, int par5, int par6) {
        float f = (float)(par5 >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(par5 >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(par5 >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(par5 & 0xFF) / 255.0f;
        float f4 = (float)(par6 >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(par6 >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(par6 >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(par6 & 0xFF) / 255.0f;
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glShadeModel((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder worldRenderer = tessellator.func_178180_c();
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        worldRenderer.func_181662_b((double)par3, (double)par2, 0.0).func_181666_a(f1, f2, f3, f).func_181675_d();
        worldRenderer.func_181662_b((double)par1, (double)par2, 0.0).func_181666_a(f1, f2, f3, f).func_181675_d();
        worldRenderer.func_181662_b((double)par1, (double)par4, 0.0).func_181666_a(f5, f6, f7, f4).func_181675_d();
        worldRenderer.func_181662_b((double)par3, (double)par4, 0.0).func_181666_a(f5, f6, f7, f4).func_181675_d();
        tessellator.func_78381_a();
        GL11.glShadeModel((int)7424);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
    }

    static {
        spaceRaceGuiScheduled = false;
        packetHandlers = Lists.newCopyOnWriteArrayList();
        fluidNetworks = Sets.newHashSet();
        menuReset = true;
        updateJEIhiding = false;
        screenConnectionsUpdateList = new HashSet();
        TickHandlerClient.registerDetectableBlocks(true);
    }
}

