/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.event;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeSet;
import micdoodle8.mods.galacticraft.api.entity.IEntityBreathable;
import micdoodle8.mods.galacticraft.api.event.oxygen.GCCoreOxygenSuffocationEvent;
import micdoodle8.mods.galacticraft.api.item.IKeyItem;
import micdoodle8.mods.galacticraft.api.item.IKeyable;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntityAutoRocket;
import micdoodle8.mods.galacticraft.api.recipe.ISchematicPage;
import micdoodle8.mods.galacticraft.api.recipe.SchematicEvent;
import micdoodle8.mods.galacticraft.api.recipe.SchematicRegistry;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.api.world.IZeroGDimension;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.TransformerHooks;
import micdoodle8.mods.galacticraft.core.client.SkyProviderOverworld;
import micdoodle8.mods.galacticraft.core.client.gui.container.GuiPositionedContainer;
import micdoodle8.mods.galacticraft.core.dimension.WorldProviderSpaceStation;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedZombie;
import micdoodle8.mods.galacticraft.core.entities.EntityLanderBase;
import micdoodle8.mods.galacticraft.core.entities.EntityMeteor;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStatsClient;
import micdoodle8.mods.galacticraft.core.event.EventWakePlayer;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.proxy.ClientProxyCore;
import micdoodle8.mods.galacticraft.core.tick.TickHandlerServer;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.DamageSourceGC;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.OxygenUtil;
import micdoodle8.mods.galacticraft.core.util.PlayerUtil;
import micdoodle8.mods.galacticraft.core.wrappers.PlayerGearData;
import micdoodle8.mods.galacticraft.planets.asteroids.AsteroidsModule;
import micdoodle8.mods.galacticraft.planets.mars.network.PacketSimpleMars;
import net.minecraft.block.Block;
import net.minecraft.block.BlockGravel;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockSand;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemFireball;
import net.minecraft.item.ItemFlintAndSteel;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeDesert;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.ZombieEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EventHandlerGC {
    public static Map<Block, Item> bucketList = new HashMap<Block, Item>(4, 1.0f);
    public static boolean bedActivated;
    private List<SoundPlayEntry> soundPlayList = new ArrayList<SoundPlayEntry>();
    private static Field volumeField;
    private static Field pitchField;

    @SubscribeEvent
    public void playerJoinWorld(EntityJoinWorldEvent event) {
        TickHandlerServer.markWorldNeedsUpdate(GCCoreUtil.getDimensionID(event.getWorld()));
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent event) {
        if (event.getModID().equals("galacticraftcore")) {
            ConfigManagerCore.syncConfig(false);
        }
    }

    @SubscribeEvent
    public void onPortalSpawn(BlockEvent.PortalSpawnEvent event) {
        WorldProvider provider = event.getWorld().field_73011_w;
        if (provider instanceof IGalacticraftWorldProvider) {
            event.setCanceled(!((IGalacticraftWorldProvider)provider).netherPortalsOperational());
        }
    }

    @SubscribeEvent
    public void onEntityDamaged(LivingHurtEvent event) {
        if (event.getSource().field_76373_n.equals(DamageSource.field_76370_b.field_76373_n) && OxygenUtil.noAtmosphericCombustion(event.getEntityLiving().field_70170_p.field_73011_w)) {
            if (OxygenUtil.isAABBInBreathableAirBlock(event.getEntityLiving().field_70170_p, event.getEntityLiving().func_174813_aQ())) {
                return;
            }
            if (event.getEntityLiving().field_70170_p instanceof WorldServer) {
                ((WorldServer)event.getEntityLiving().field_70170_p).func_175739_a(EnumParticleTypes.SMOKE_NORMAL, event.getEntityLiving().field_70165_t, event.getEntityLiving().field_70163_u + event.getEntityLiving().func_174813_aQ().field_72337_e - event.getEntityLiving().func_174813_aQ().field_72338_b, event.getEntityLiving().field_70161_v, 50, 0.0, 0.05, 0.0, 0.001, new int[0]);
            }
            event.getEntityLiving().func_70066_B();
        }
    }

    @SubscribeEvent
    public void onEntityFall(LivingFallEvent event) {
        EntityPlayer player;
        if (event.getEntityLiving() instanceof EntityPlayer && ((player = (EntityPlayer)event.getEntityLiving()).func_184187_bx() instanceof EntityAutoRocket || player.func_184187_bx() instanceof EntityLanderBase)) {
            event.setDistance(0.0f);
            event.setCanceled(true);
            return;
        }
        if (event.getEntityLiving().field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider) {
            event.setDistance(event.getDistance() * ((IGalacticraftWorldProvider)event.getEntityLiving().field_70170_p.field_73011_w).getFallDamageModifier());
        }
    }

    @SubscribeEvent
    public void blockBreakSpeed(PlayerEvent.BreakSpeed event) {
        EntityPlayer p = event.getEntityPlayer();
        if (!p.field_70122_E && p.field_70170_p.field_73011_w instanceof IZeroGDimension && !ConfigManagerCore.hardMode && event.getOriginalSpeed() < 5.0f) {
            event.setNewSpeed(event.getOriginalSpeed() * 5.0f);
        }
    }

    @SubscribeEvent
    public void onPlayerLeftClickedBlock(PlayerInteractEvent.LeftClickBlock event) {
        if (event.getEntityPlayer() == null || event.getEntityPlayer().field_71071_by == null || event.getPos() == null || event.getPos().func_177958_n() == 0 && event.getPos().func_177956_o() == 0 && event.getPos().func_177952_p() == 0) {
            return;
        }
        World worldObj = event.getEntityPlayer().field_70170_p;
        if (worldObj == null) {
            return;
        }
        ItemStack heldStack = event.getEntityPlayer().field_71071_by.func_70448_g();
        TileEntity tileClicked = worldObj.func_175625_s(event.getPos());
        if (!heldStack.func_190926_b()) {
            if (tileClicked != null && tileClicked instanceof IKeyable) {
                event.setCanceled(!((IKeyable)tileClicked).canBreak() && !event.getEntityPlayer().field_71075_bZ.field_75098_d);
            }
        } else if (tileClicked != null && tileClicked instanceof IKeyable) {
            event.setCanceled(!((IKeyable)tileClicked).canBreak() && !event.getEntityPlayer().field_71075_bZ.field_75098_d);
        }
    }

    @SubscribeEvent
    public void onPlayerRightClickedBlock(PlayerInteractEvent.RightClickBlock event) {
        if (event.getEntityPlayer() == null || event.getEntityPlayer().field_71071_by == null || event.getPos() == null || event.getPos().func_177958_n() == 0 && event.getPos().func_177956_o() == 0 && event.getPos().func_177952_p() == 0) {
            return;
        }
        World worldObj = event.getEntityPlayer().field_70170_p;
        if (worldObj == null) {
            return;
        }
        Block idClicked = worldObj.func_180495_p(event.getPos()).func_177230_c();
        if (idClicked == Blocks.field_150324_C && worldObj.field_73011_w instanceof IGalacticraftWorldProvider && !worldObj.field_72995_K && !((IGalacticraftWorldProvider)worldObj.field_73011_w).hasBreathableAtmosphere()) {
            GCPlayerStats stats;
            if (GalacticraftCore.isPlanetsLoaded && !(stats = GCPlayerStats.get((Entity)event.getEntityPlayer())).hasReceivedBedWarning()) {
                event.getEntityPlayer().func_145747_a((ITextComponent)new TextComponentString(GCCoreUtil.translate("gui.bed_fail.message")));
                stats.setReceivedBedWarning(true);
            }
            if (worldObj.field_73011_w instanceof WorldProviderSpaceStation) {
                event.setCanceled(true);
                return;
            }
            bedActivated = true;
            if (worldObj.field_73011_w.func_76567_e() && !bedActivated) {
                bedActivated = true;
                event.getEntityPlayer().setSpawnChunk(event.getPos(), false, GCCoreUtil.getDimensionID(event.getWorld()));
            } else {
                bedActivated = false;
            }
        }
        ItemStack heldStack = event.getEntityPlayer().field_71071_by.func_70448_g();
        TileEntity tileClicked = worldObj.func_175625_s(event.getPos());
        if (!heldStack.func_190926_b()) {
            if (tileClicked != null && tileClicked instanceof IKeyable) {
                if (heldStack.func_77973_b() instanceof IKeyItem) {
                    if (((IKeyItem)heldStack.func_77973_b()).getTier(heldStack) == -1 || ((IKeyable)tileClicked).getTierOfKeyRequired() == -1 || ((IKeyItem)heldStack.func_77973_b()).getTier(heldStack) == ((IKeyable)tileClicked).getTierOfKeyRequired()) {
                        event.setCanceled(((IKeyable)tileClicked).onValidKeyActivated(event.getEntityPlayer(), heldStack, event.getFace()));
                    } else if (!event.getEntityPlayer().func_70093_af()) {
                        event.setCanceled(((IKeyable)tileClicked).onActivatedWithoutKey(event.getEntityPlayer(), event.getFace()));
                    }
                } else {
                    event.setCanceled(((IKeyable)tileClicked).onActivatedWithoutKey(event.getEntityPlayer(), event.getFace()));
                }
            }
            if ((heldStack.func_77973_b() instanceof ItemFlintAndSteel || heldStack.func_77973_b() instanceof ItemFireball) && !worldObj.field_72995_K && idClicked != Blocks.field_150335_W && OxygenUtil.noAtmosphericCombustion(event.getEntityPlayer().field_70170_p.field_73011_w) && !OxygenUtil.isAABBInBreathableAirBlock(event.getEntityLiving().field_70170_p, new AxisAlignedBB((double)event.getPos().func_177958_n(), (double)event.getPos().func_177956_o(), (double)event.getPos().func_177952_p(), (double)(event.getPos().func_177958_n() + 1), (double)(event.getPos().func_177956_o() + 2), (double)(event.getPos().func_177952_p() + 1)))) {
                event.setCanceled(true);
            }
        } else if (tileClicked != null && tileClicked instanceof IKeyable) {
            event.setCanceled(((IKeyable)tileClicked).onActivatedWithoutKey(event.getEntityPlayer(), event.getFace()));
        }
    }

    @SubscribeEvent
    public void entityLivingEvent(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entityLiving = event.getEntityLiving();
        if (entityLiving instanceof EntityPlayerMP) {
            GalacticraftCore.handler.onPlayerUpdate((EntityPlayerMP)entityLiving);
            if (GalacticraftCore.isPlanetsLoaded) {
                AsteroidsModule.playerHandler.onPlayerUpdate((EntityPlayerMP)entityLiving);
            }
            return;
        }
        if (!(entityLiving.field_70173_aa % ConfigManagerCore.suffocationCooldown != 0 || !(entityLiving.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider) || entityLiving instanceof EntityPlayer || entityLiving instanceof IEntityBreathable && ((IEntityBreathable)entityLiving).canBreath() || ((IGalacticraftWorldProvider)entityLiving.field_70170_p.field_73011_w).hasBreathableAtmosphere() || OxygenUtil.isAABBInBreathableAirBlock(entityLiving))) {
            GCCoreOxygenSuffocationEvent.Pre suffocationEvent = new GCCoreOxygenSuffocationEvent.Pre(entityLiving);
            MinecraftForge.EVENT_BUS.post((Event)suffocationEvent);
            if (suffocationEvent.isCanceled()) {
                return;
            }
            entityLiving.func_70097_a((DamageSource)DamageSourceGC.oxygenSuffocation, (float)Math.max(ConfigManagerCore.suffocationDamage / 2, 1));
            GCCoreOxygenSuffocationEvent.Post suffocationEventPost = new GCCoreOxygenSuffocationEvent.Post(entityLiving);
            MinecraftForge.EVENT_BUS.post((Event)suffocationEventPost);
        }
    }

    @SubscribeEvent
    public void entityUpdateCancelInFreefall(EntityEvent.CanUpdate event) {
        if (event.getEntity() instanceof EntityMeteor) {
            event.setCanUpdate(true);
            return;
        }
        if (event.getEntity().field_70170_p.field_73011_w instanceof IZeroGDimension && ((IZeroGDimension)event.getEntity().field_70170_p.field_73011_w).inFreefall(event.getEntity())) {
            event.setCanUpdate(true);
        }
    }

    private ItemStack fillBucket(World world, RayTraceResult position) {
        IBlockState state = world.func_180495_p(position.func_178782_a());
        Block block = state.func_177230_c();
        Item bucket = bucketList.get(block);
        if (bucket != null && block.func_176201_c(state) == 0) {
            world.func_175698_g(position.func_178782_a());
            return new ItemStack(bucket);
        }
        return null;
    }

    @SubscribeEvent
    public void onBucketFill(FillBucketEvent event) {
        if (event.getEmptyBucket() == null || !(event.getEmptyBucket().func_77973_b() instanceof ItemBucket)) {
            return;
        }
        RayTraceResult pos = event.getTarget();
        if (pos == null) {
            return;
        }
        ItemStack ret = this.fillBucket(event.getWorld(), pos);
        if (ret == null) {
            return;
        }
        event.setFilledBucket(ret);
        event.setResult(Event.Result.ALLOW);
    }

    @SubscribeEvent
    public void populate(PopulateChunkEvent.Post event) {
        boolean doGen = TerrainGen.populate((IChunkGenerator)event.getGenerator(), (World)event.getWorld(), (Random)event.getRand(), (int)event.getChunkX(), (int)event.getChunkZ(), (boolean)event.isHasVillageGenerated(), (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.CUSTOM);
        if (!doGen) {
            return;
        }
        int worldX = event.getChunkX() << 4;
        int worldZ = event.getChunkZ() << 4;
        EventHandlerGC.generateOil(event.getWorld(), event.getRand(), worldX + 15, worldZ + 15, false);
    }

    public static boolean oilPresent(World world, Random rand, int x, int z, BlockVec3 pos) {
        boolean flag2;
        boolean doGen2 = false;
        int[] nArray = ConfigManagerCore.externalOilGen;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer dim = nArray[i];
            if (dim != GCCoreUtil.getDimensionID(world)) continue;
            doGen2 = true;
            break;
        }
        if (!doGen2) {
            return false;
        }
        Biome biome = world.func_180494_b(new BlockPos(x + 8, 0, z + 8));
        if (biome == Biomes.field_76779_k || biome == Biomes.field_76778_j) {
            return false;
        }
        rand.setSeed(world.func_72905_C());
        long i1 = (long)rand.nextInt() / 2L * 2L + 1L;
        long j1 = (long)rand.nextInt() / 2L * 2L + 1L;
        rand.setSeed((long)x * i1 + (long)z * j1 ^ world.func_72905_C());
        double randMod = Math.min(0.2, 0.05 * ConfigManagerCore.oilGenFactor);
        if (biome.func_185355_j() >= 0.45f) {
            randMod /= 2.0;
        }
        if (biome.func_185355_j() < -0.5f) {
            randMod *= 1.8;
        }
        if (biome instanceof BiomeDesert) {
            randMod *= 1.8;
        }
        boolean flag1 = rand.nextDouble() <= randMod;
        boolean bl = flag2 = rand.nextDouble() <= randMod;
        if (flag1 || flag2) {
            pos.y = 17 + rand.nextInt(10) + rand.nextInt(5);
            pos.x = x + 8 - rand.nextInt(16);
            pos.z = z + 8 - rand.nextInt(16);
            return true;
        }
        return false;
    }

    public static void generateOil(World world, Random rand, int xx, int zz, boolean testFirst) {
        BlockVec3 pos = new BlockVec3();
        if (EventHandlerGC.oilPresent(world, rand, xx, zz, pos)) {
            int x = pos.x;
            int cy = pos.y;
            int z = pos.z;
            int r = 3 + rand.nextInt(5);
            if (testFirst && EventHandlerGC.checkOilPresent(world, x, cy, z, r)) {
                return;
            }
            int r2 = r * r;
            IBlockState crudeOil = GCBlocks.crudeOil.func_176223_P();
            for (int bx = -r; bx <= r; ++bx) {
                for (int by = -r + 2; by <= r - 2; ++by) {
                    int xySquared = bx * bx + by * by * 3;
                    for (int bz = -r; bz <= r; ++bz) {
                        if (xySquared + bz * bz > r2 || EventHandlerGC.checkBlock(world, new BlockPos(bx + x - 1, by + cy, bz + z)) || EventHandlerGC.checkBlock(world, new BlockPos(bx + x + 1, by + cy, bz + z)) || EventHandlerGC.checkBlock(world, new BlockPos(bx + x, by + cy - 1, bz + z)) || EventHandlerGC.checkBlock(world, new BlockPos(bx + x, by + cy, bz + z - 1)) || EventHandlerGC.checkBlock(world, new BlockPos(bx + x, by + cy, bz + z + 1)) || EventHandlerGC.checkBlockAbove(world, new BlockPos(bx + x, by + cy + 1, bz + z))) continue;
                        world.func_180501_a(new BlockPos(bx + x, by + cy, bz + z), crudeOil, 2);
                    }
                }
            }
        }
    }

    private static boolean checkOilPresent(World world, int x, int cy, int z, int r) {
        int r2 = r * r;
        for (int bx = -r; bx <= r; ++bx) {
            for (int by = -r + 2; by <= r - 2; ++by) {
                int xySquared = bx * bx + by * by * 3;
                for (int bz = -r; bz <= r; ++bz) {
                    if (xySquared + bz * bz > r2 || EventHandlerGC.checkBlock(world, new BlockPos(bx + x - 1, by + cy, bz + z)) || EventHandlerGC.checkBlock(world, new BlockPos(bx + x + 1, by + cy, bz + z)) || EventHandlerGC.checkBlock(world, new BlockPos(bx + x, by + cy - 1, bz + z)) || EventHandlerGC.checkBlock(world, new BlockPos(bx + x, by + cy, bz + z - 1)) || EventHandlerGC.checkBlock(world, new BlockPos(bx + x, by + cy, bz + z + 1)) || EventHandlerGC.checkBlockAbove(world, new BlockPos(bx + x, by + cy + 1, bz + z)) || world.func_180495_p(new BlockPos(bx + x, by + cy, bz + z)).func_177230_c() != GCBlocks.crudeOil) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static void retrogenOil(World world, Chunk chunk) {
        int cx = chunk.field_76635_g;
        int cz = chunk.field_76647_h;
        EventHandlerGC.generateOil(world, new Random(), cx << 4, cz << 4, true);
    }

    private static boolean checkBlock(World w, BlockPos pos) {
        IBlockState state = w.func_180495_p(pos);
        Block b = state.func_177230_c();
        if (b.func_149688_o(state) == Material.field_151579_a) {
            return true;
        }
        return b instanceof BlockLiquid && b != GCBlocks.crudeOil;
    }

    private static boolean checkBlockAbove(World w, BlockPos pos) {
        Block b = w.func_180495_p(pos).func_177230_c();
        if (b instanceof BlockSand) {
            return true;
        }
        return b instanceof BlockGravel;
    }

    @SubscribeEvent
    public void schematicUnlocked(SchematicEvent.Unlock event) {
        GCPlayerStats stats = GCPlayerStats.get((Entity)event.player);
        if (!stats.getUnlockedSchematics().contains(event.page)) {
            stats.getUnlockedSchematics().add(event.page);
            Collections.sort(stats.getUnlockedSchematics());
            if (event.player != null && event.player.field_71135_a != null) {
                Integer[] iArray = new Integer[stats.getUnlockedSchematics().size()];
                for (int i = 0; i < iArray.length; ++i) {
                    ISchematicPage page = stats.getUnlockedSchematics().get(i);
                    iArray[i] = page == null ? -2 : page.getPageID();
                }
                ArrayList<Object> objList = new ArrayList<Object>();
                objList.add(iArray);
                GalacticraftCore.packetPipeline.sendTo(new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_SCHEMATIC_LIST, GCCoreUtil.getDimensionID(event.player.field_70170_p), objList), event.player);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void schematicFlipEvent(SchematicEvent.FlipPage event) {
        ISchematicPage page = null;
        switch (event.direction) {
            case 1: {
                page = EventHandlerGC.getNextSchematic(event.index);
                break;
            }
            case -1: {
                page = EventHandlerGC.getLastSchematic(event.index);
            }
        }
        if (page != null) {
            GuiScreen cs = event.currentGui;
            int benchX = (int)FMLClientHandler.instance().getClient().field_71439_g.field_70165_t;
            int benchY = (int)FMLClientHandler.instance().getClient().field_71439_g.field_70163_u;
            int benchZ = (int)FMLClientHandler.instance().getClient().field_71439_g.field_70161_v;
            if (cs instanceof GuiPositionedContainer) {
                benchX = ((GuiPositionedContainer)cs).getX();
                benchY = ((GuiPositionedContainer)cs).getY();
                benchZ = ((GuiPositionedContainer)cs).getZ();
            }
            GalacticraftCore.packetPipeline.sendToServer(new PacketSimple(PacketSimple.EnumSimplePacket.S_OPEN_SCHEMATIC_PAGE, GCCoreUtil.getDimensionID((World)FMLClientHandler.instance().getClient().field_71441_e), new Object[]{page.getPageID(), benchX, benchY, benchZ}));
            FMLClientHandler.instance().getClient().field_71439_g.openGui((Object)GalacticraftCore.instance, page.getGuiID(), FMLClientHandler.instance().getClient().field_71439_g.field_70170_p, benchX, benchY, benchZ);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static ISchematicPage getNextSchematic(int currentIndex) {
        EntityPlayerSP player = PlayerUtil.getPlayerBaseClientFromPlayer((EntityPlayer)FMLClientHandler.instance().getClient().field_71439_g, false);
        GCPlayerStatsClient stats = GCPlayerStatsClient.get((Entity)player);
        int size = stats.getUnlockedSchematics().size();
        HashMap<Integer, Integer> idList = new HashMap<Integer, Integer>(size, 1.0f);
        for (int i = 0; i < size; ++i) {
            idList.put(i, stats.getUnlockedSchematics().get(i).getPageID());
        }
        TreeSet keys = new TreeSet(idList.keySet());
        Iterator iterator = keys.iterator();
        for (int count = 0; count < keys.size(); ++count) {
            int i = (Integer)iterator.next();
            ISchematicPage page = SchematicRegistry.getMatchingRecipeForID((Integer)idList.get(i));
            if (page.getPageID() != currentIndex) continue;
            if (count + 1 < stats.getUnlockedSchematics().size()) {
                return stats.getUnlockedSchematics().get(count + 1);
            }
            return null;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private static ISchematicPage getLastSchematic(int currentIndex) {
        EntityPlayerSP player = PlayerUtil.getPlayerBaseClientFromPlayer((EntityPlayer)FMLClientHandler.instance().getClient().field_71439_g, false);
        GCPlayerStatsClient stats = GCPlayerStatsClient.get((Entity)player);
        int size = stats.getUnlockedSchematics().size();
        HashMap<Integer, Integer> idList = new HashMap<Integer, Integer>(size, 1.0f);
        for (int i = 0; i < size; ++i) {
            idList.put(i, stats.getUnlockedSchematics().get(i).getPageID());
        }
        TreeSet keys = new TreeSet(idList.keySet());
        Iterator iterator = keys.iterator();
        for (int count = 0; count < keys.size(); ++count) {
            int i = (Integer)iterator.next();
            ISchematicPage page = SchematicRegistry.getMatchingRecipeForID((Integer)idList.get(i));
            if (page.getPageID() != currentIndex) continue;
            if (count - 1 >= 0) {
                return stats.getUnlockedSchematics().get(count - 1);
            }
            return null;
        }
        return null;
    }

    @SubscribeEvent
    public void onPlayerDeath(PlayerDropsEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayerMP) {
            GCPlayerStats stats = GCPlayerStats.get((Entity)event.getEntityPlayer());
            if (!event.getEntityPlayer().field_70170_p.func_82736_K().func_82766_b("keepInventory")) {
                event.getEntityPlayer().captureDrops = true;
                for (int i = stats.getExtendedInventory().func_70302_i_() - 1; i >= 0; --i) {
                    ItemStack stack = stats.getExtendedInventory().func_70301_a(i);
                    if (stack.func_190926_b()) continue;
                    event.getEntityPlayer().func_146097_a(stack, true, false);
                    stats.getExtendedInventory().func_70299_a(i, ItemStack.field_190927_a);
                }
                event.getEntityLiving().captureDrops = false;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onLeaveBedButtonClicked(SleepCancelledEvent event) {
        EntityPlayerSP player = FMLClientHandler.instance().getClient().field_71439_g;
        BlockPos c = player.field_71081_bT;
        if (c != null) {
            EventWakePlayer event0 = new EventWakePlayer((EntityPlayer)player, c, true, true, false, true);
            MinecraftForge.EVENT_BUS.post((Event)event0);
            player.func_70999_a(true, true, false);
            if (player.field_70170_p.field_72995_K && GalacticraftCore.isPlanetsLoaded) {
                GalacticraftCore.packetPipeline.sendToServer(new PacketSimpleMars(PacketSimpleMars.EnumSimplePacketMars.S_WAKE_PLAYER, GCCoreUtil.getDimensionID(player.field_70170_p), new Object[0]));
            }
        }
    }

    @SubscribeEvent
    public void onZombieSummonAid(ZombieEvent.SummonAidEvent event) {
        if (event.getEntity() instanceof EntityEvolvedZombie) {
            event.setCustomSummonedAid((EntityZombie)new EntityEvolvedZombie(event.getWorld()));
            if ((double)((EntityLivingBase)event.getEntity()).func_70681_au().nextFloat() < ((EntityEvolvedZombie)event.getEntity()).func_110148_a(((EntityEvolvedZombie)event.getEntity()).getReinforcementsAttribute()).func_111126_e()) {
                event.setResult(Event.Result.ALLOW);
            } else {
                event.setResult(Event.Result.DENY);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void overrideSkyColor(EntityViewRenderEvent.FogColors event) {
        if (event.getEntity() instanceof EntityLivingBase && ((EntityLivingBase)event.getEntity()).func_70644_a(MobEffects.field_76439_r)) {
            WorldClient worldclient = Minecraft.func_71410_x().field_71441_e;
            if (worldclient.field_73011_w instanceof IGalacticraftWorldProvider && ((IGalacticraftWorldProvider)worldclient.field_73011_w).hasNoAtmosphere() && event.getState().func_185904_a() == Material.field_151579_a && !((IGalacticraftWorldProvider)worldclient.field_73011_w).hasBreathableAtmosphere()) {
                Vec3d vec = worldclient.func_72948_g(1.0f);
                event.setRed((float)vec.field_72450_a);
                event.setGreen((float)vec.field_72448_b);
                event.setBlue((float)vec.field_72449_c);
                return;
            }
            if (worldclient.field_73011_w.getSkyRenderer() instanceof SkyProviderOverworld && event.getEntity().field_70163_u > 200.0) {
                Vec3d vec = TransformerHooks.getFogColorHook(event.getEntity().field_70170_p);
                event.setRed((float)vec.field_72450_a);
                event.setGreen((float)vec.field_72448_b);
                event.setBlue((float)vec.field_72449_c);
                return;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onSoundPlayed(PlaySoundEvent event) {
        if (event.getResultSound() == null) {
            return;
        }
        EntityPlayerSP player = FMLClientHandler.instance().getClient().field_71439_g;
        if (player != null && player.field_70170_p != null && player.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider && event.getResultSound().func_147656_j() != ISound.AttenuationType.NONE) {
            PlayerGearData gearData = ClientProxyCore.playerItemData.get(PlayerUtil.getName((EntityPlayer)player));
            float x = event.getResultSound().func_147649_g();
            float y = event.getResultSound().func_147654_h();
            float z = event.getResultSound().func_147651_i();
            if (gearData == null || gearData.getFrequencyModule() == -1) {
                AxisAlignedBB bb = new AxisAlignedBB((double)x - 0.0015, (double)y - 0.0015, (double)z - 0.0015, (double)x + 0.0015, (double)y + 0.0015, (double)z + 0.0015);
                boolean playerInAtmosphere = OxygenUtil.isAABBInBreathableAirBlock((EntityLivingBase)player);
                boolean soundInAtmosphere = OxygenUtil.isAABBInBreathableAirBlock(player.field_70170_p, bb);
                if (!playerInAtmosphere || !soundInAtmosphere) {
                    float volume = 1.0f;
                    float pitch = 1.0f;
                    if (volumeField == null) {
                        try {
                            volumeField = PositionedSound.class.getDeclaredField(GCCoreUtil.isDeobfuscated() ? "volume" : "field_147662_b");
                            volumeField.setAccessible(true);
                            pitchField = PositionedSound.class.getDeclaredField(GCCoreUtil.isDeobfuscated() ? "pitch" : "field_147663_c");
                            pitchField.setAccessible(true);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (volumeField != null && pitchField != null) {
                        try {
                            volume = event.getSound() instanceof PositionedSound ? ((Float)volumeField.get(event.getSound())).floatValue() : 1.0f;
                            pitch = event.getSound() instanceof PositionedSound ? ((Float)pitchField.get(event.getSound())).floatValue() : 1.0f;
                        }
                        catch (IllegalAccessException e) {
                            e.printStackTrace();
                        }
                    }
                    for (int i = 0; i < this.soundPlayList.size(); ++i) {
                        SoundPlayEntry entry = this.soundPlayList.get(i);
                        if (!entry.name.equals(event.getName()) || entry.x != x || entry.y != y || entry.z != z || entry.volume != volume) continue;
                        this.soundPlayList.remove(i);
                        return;
                    }
                    float newVolume = volume / Math.max(0.01f, ((IGalacticraftWorldProvider)player.field_70170_p.field_73011_w).getSoundVolReductionAmount());
                    this.soundPlayList.add(new SoundPlayEntry(event.getName(), x, y, z, newVolume));
                    SoundEvent soundEvent = (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)event.getResultSound().func_147650_b());
                    if (soundEvent != null) {
                        PositionedSoundRecord newSound = new PositionedSoundRecord(soundEvent, SoundCategory.NEUTRAL, newVolume, pitch, x, y, z);
                        event.getManager().func_148611_c((ISound)newSound);
                        event.setResultSound(null);
                    } else {
                        GalacticraftCore.logger.error("Sound event null! " + event.getName() + " " + event.getResultSound().func_147650_b(), new Object[0]);
                    }
                }
            }
        }
    }

    public static class OrientCameraEvent
    extends Event {
    }

    public static class SleepCancelledEvent
    extends Event {
    }

    private static class SoundPlayEntry {
        private final String name;
        private final float x;
        private final float y;
        private final float z;
        private final float volume;

        private SoundPlayEntry(String name, float x, float y, float z, float volume) {
            this.name = name;
            this.volume = volume;
            this.x = x;
            this.y = y;
            this.z = z;
        }
    }
}

