/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.client.render.tile;

import com.google.common.collect.Maps;
import java.util.HashMap;
import micdoodle8.mods.galacticraft.api.transmission.tile.IBufferTransmitter;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.client.EventHandlerClient;
import micdoodle8.mods.galacticraft.core.fluid.FluidNetwork;
import micdoodle8.mods.galacticraft.core.tile.TileEntityFluidPipe;
import micdoodle8.mods.galacticraft.core.tile.TileEntityFluidTank;
import micdoodle8.mods.galacticraft.core.util.ClientUtil;
import micdoodle8.mods.galacticraft.core.util.OxygenUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.Fluid;
import org.lwjgl.opengl.GL11;

public class TileEntityFluidPipeRenderer
extends TileEntitySpecialRenderer<TileEntityFluidPipe> {
    private static HashMap<Integer, HashMap<Fluid, Integer[]>> cache = new HashMap();
    private final int stages = 100;

    public void render(TileEntityFluidPipe pipe, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        Fluid fluid;
        float scale;
        if (pipe.func_145838_q() == GCBlocks.oxygenPipePull) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
            RenderHelper.func_74518_a();
            this.func_147499_a(TextureMap.field_110575_b);
            if (Minecraft.func_71379_u()) {
                GlStateManager.func_179103_j((int)7425);
            } else {
                GlStateManager.func_179103_j((int)7424);
            }
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            TileEntity[] adj = OxygenUtil.getAdjacentFluidConnections(pipe);
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                EnumFacing[] sideTile = adj[facing.ordinal()];
                if (sideTile == null || sideTile instanceof IBufferTransmitter) continue;
                GL11.glPushMatrix();
                if (sideTile instanceof TileEntityFluidTank) {
                    switch (facing) {
                        case SOUTH: {
                            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.0625f);
                            break;
                        }
                        case NORTH: {
                            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.0625f);
                            break;
                        }
                        case EAST: {
                            GL11.glTranslatef((float)0.0625f, (float)0.0f, (float)0.0f);
                            break;
                        }
                        case WEST: {
                            GL11.glTranslatef((float)-0.0625f, (float)0.0f, (float)0.0f);
                            break;
                        }
                    }
                }
                ClientUtil.drawBakedModel(EventHandlerClient.fluidPipeModels[facing.ordinal()]);
                GL11.glPopMatrix();
            }
            GL11.glPopMatrix();
        }
        if (pipe.hasNetwork()) {
            FluidNetwork network = (FluidNetwork)pipe.getNetwork();
            scale = network.fluidScale;
        } else {
            scale = (float)pipe.buffer.getFluidAmount() / (float)pipe.buffer.getCapacity();
        }
        if (pipe.hasNetwork()) {
            FluidNetwork network = (FluidNetwork)pipe.getNetwork();
            fluid = network.refFluid;
        } else {
            Fluid fluid2 = fluid = pipe.getBuffer() == null ? null : pipe.getBuffer().getFluid();
        }
        if (fluid == null) {
            return;
        }
        if ((double)scale > 0.01) {
            this.func_147499_a(TextureMap.field_110575_b);
            GL11.glPushMatrix();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glTranslatef((float)((float)x), (float)((float)y + 1.0f), (float)((float)z + 1.0f));
            GL11.glScalef((float)1.0f, (float)-1.0f, (float)-1.0f);
            GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
            GlStateManager.func_179140_f();
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            float opacity = 1.0f;
            boolean gas = fluid.isGaseous();
            if (gas) {
                opacity = scale;
            }
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)opacity);
            TileEntity[] connections = OxygenUtil.getAdjacentFluidConnections(pipe);
            for (EnumFacing side : EnumFacing.field_82609_l) {
                Integer list;
                Integer[] displayLists;
                TileEntity sideTile = connections[side.ordinal()];
                if (sideTile == null || (displayLists = this.getListAndRender(side, fluid)) == null) continue;
                if (!gas) {
                    list = displayLists[Math.max(3, (int)(scale * 99.0f))];
                    GL11.glCallList((int)list);
                    continue;
                }
                list = displayLists[99];
                GL11.glCallList((int)list);
            }
            Integer[] displayLists = this.getListAndRender(null, fluid);
            if (displayLists != null) {
                if (!gas) {
                    Integer list = displayLists[Math.max(3, (int)(scale * 99.0f))];
                    GL11.glCallList((int)list);
                } else {
                    Integer list = displayLists[99];
                    GL11.glCallList((int)list);
                }
            }
            GlStateManager.func_179145_e();
            GlStateManager.func_179084_k();
            GL11.glPopMatrix();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    private Integer[] getListAndRender(EnumFacing side, Fluid fluid) {
        int sideIndex;
        if (fluid == null) {
            return null;
        }
        TextureAtlasSprite sprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(fluid.getStill().toString());
        int n = sideIndex = side == null ? 6 : side.ordinal();
        if (cache.containsKey(sideIndex) && cache.get(sideIndex).containsKey(fluid)) {
            return cache.get(sideIndex).get(fluid);
        }
        float size = 0.09f;
        float mid = 0.0f;
        Integer[] displayLists = new Integer[this.stages];
        if (cache.containsKey(sideIndex)) {
            cache.get(sideIndex).put(fluid, displayLists);
        } else {
            HashMap map = Maps.newHashMap();
            map.put(fluid, displayLists);
            cache.put(sideIndex, map);
        }
        for (int i = 0; i < 100; ++i) {
            float maxZ;
            float minZ;
            float maxY;
            float minY;
            float maxX;
            float minX;
            displayLists[i] = GLAllocation.func_74526_a((int)1);
            GL11.glNewList((int)displayLists[i], (int)4864);
            float level = (float)i / 100.0f;
            switch (sideIndex) {
                case 0: {
                    minX = mid - level * size;
                    maxX = mid + level * size;
                    minY = mid + size;
                    maxY = mid + 0.5f;
                    minZ = mid - level * size;
                    maxZ = mid + level * size;
                    break;
                }
                case 1: {
                    minX = mid - level * size;
                    maxX = mid + level * size;
                    minY = mid - 0.5f;
                    maxY = mid - size;
                    minZ = mid - level * size;
                    maxZ = mid + level * size;
                    break;
                }
                case 2: {
                    minX = mid - size;
                    maxX = mid + size;
                    maxY = mid + size;
                    minY = mid + size - level * size * 2.0f;
                    minZ = mid + size;
                    maxZ = mid + 0.5f;
                    break;
                }
                case 3: {
                    minX = mid - size;
                    maxX = mid + size;
                    maxY = mid + size;
                    minY = mid + size - level * size * 2.0f;
                    minZ = mid - 0.5f;
                    maxZ = mid - size;
                    break;
                }
                case 4: {
                    minX = mid - 0.5f;
                    maxX = mid - size;
                    maxY = mid + size;
                    minY = mid + size - level * size * 2.0f;
                    minZ = mid - size;
                    maxZ = mid + size;
                    break;
                }
                case 5: {
                    minX = mid + size;
                    maxX = mid + 0.5f;
                    maxY = mid + size;
                    minY = mid + size - level * size * 2.0f;
                    minZ = mid - size;
                    maxZ = mid + size;
                    break;
                }
                default: {
                    minX = mid - size;
                    maxX = mid + size;
                    maxY = mid + size;
                    minY = mid + size - level * size * 2.0f;
                    minZ = mid - size;
                    maxZ = mid + size;
                }
            }
            this.renderBox(minX, maxX, minY, maxY, minZ, maxZ, level, sprite);
            GL11.glEndList();
        }
        return displayLists;
    }

    private void renderBox(float minX, float maxX, float minY, float maxY, float minZ, float maxZ, float level, TextureAtlasSprite sprite) {
        double uMin = sprite.func_94209_e();
        double uMax = sprite.func_94212_f();
        double vMin = sprite.func_94206_g();
        double vMax = sprite.func_94210_h();
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder worldRenderer = tess.func_178180_c();
        double uDiff = uMax - uMin;
        double vDiff = vMax - vMin;
        double texMinX_U = uMin + (double)(minX + 0.5f) * uDiff;
        double texMaxX_U = uMin + (double)(maxX + 0.5f) * uDiff;
        double texMinZ_U = uMin + (double)(minZ + 0.5f) * uDiff;
        double texMaxZ_U = uMin + (double)(maxZ + 0.5f) * uDiff;
        double texMinX_V = vMin + (double)(minX + 0.5f) * vDiff;
        double texMaxX_V = vMin + (double)(maxX + 0.5f) * vDiff;
        double texMinY_V = vMin + (double)(minY + 0.5f) * vDiff;
        double texMaxY_V = vMin + (double)(maxY + 0.5f) * vDiff;
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        worldRenderer.func_181662_b((double)minX, (double)minY, (double)minZ).func_187315_a(texMinX_U, texMinY_V).func_181675_d();
        worldRenderer.func_181662_b((double)minX, (double)maxY, (double)minZ).func_187315_a(texMinX_U, texMaxY_V).func_181675_d();
        worldRenderer.func_181662_b((double)maxX, (double)maxY, (double)minZ).func_187315_a(texMaxX_U, texMaxY_V).func_181675_d();
        worldRenderer.func_181662_b((double)maxX, (double)minY, (double)minZ).func_187315_a(texMaxX_U, texMinY_V).func_181675_d();
        tess.func_78381_a();
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        worldRenderer.func_181662_b((double)maxX, (double)minY, (double)maxZ).func_187315_a(texMaxX_U, texMinY_V).func_181675_d();
        worldRenderer.func_181662_b((double)maxX, (double)maxY, (double)maxZ).func_187315_a(texMaxX_U, texMaxY_V).func_181675_d();
        worldRenderer.func_181662_b((double)minX, (double)maxY, (double)maxZ).func_187315_a(texMinX_U, texMaxY_V).func_181675_d();
        worldRenderer.func_181662_b((double)minX, (double)minY, (double)maxZ).func_187315_a(texMinX_U, texMinY_V).func_181675_d();
        tess.func_78381_a();
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        worldRenderer.func_181662_b((double)minX, (double)maxY, (double)minZ).func_187315_a(texMinZ_U, texMaxY_V).func_181675_d();
        worldRenderer.func_181662_b((double)minX, (double)minY, (double)minZ).func_187315_a(texMinZ_U, texMinY_V).func_181675_d();
        worldRenderer.func_181662_b((double)minX, (double)minY, (double)maxZ).func_187315_a(texMaxZ_U, texMinY_V).func_181675_d();
        worldRenderer.func_181662_b((double)minX, (double)maxY, (double)maxZ).func_187315_a(texMaxZ_U, texMaxY_V).func_181675_d();
        tess.func_78381_a();
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        worldRenderer.func_181662_b((double)maxX, (double)maxY, (double)maxZ).func_187315_a(texMaxZ_U, texMaxY_V).func_181675_d();
        worldRenderer.func_181662_b((double)maxX, (double)minY, (double)maxZ).func_187315_a(texMaxZ_U, texMinY_V).func_181675_d();
        worldRenderer.func_181662_b((double)maxX, (double)minY, (double)minZ).func_187315_a(texMinZ_U, texMinY_V).func_181675_d();
        worldRenderer.func_181662_b((double)maxX, (double)maxY, (double)minZ).func_187315_a(texMinZ_U, texMaxY_V).func_181675_d();
        tess.func_78381_a();
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        worldRenderer.func_181662_b((double)maxX, (double)minY, (double)maxZ).func_187315_a(texMaxZ_U, texMaxX_V).func_181675_d();
        worldRenderer.func_181662_b((double)minX, (double)minY, (double)maxZ).func_187315_a(texMaxZ_U, texMinX_V).func_181675_d();
        worldRenderer.func_181662_b((double)minX, (double)minY, (double)minZ).func_187315_a(texMinZ_U, texMinX_V).func_181675_d();
        worldRenderer.func_181662_b((double)maxX, (double)minY, (double)minZ).func_187315_a(texMinZ_U, texMaxX_V).func_181675_d();
        tess.func_78381_a();
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        worldRenderer.func_181662_b((double)maxX, (double)maxY, (double)maxZ).func_187315_a(texMaxZ_U, texMaxX_V).func_181675_d();
        worldRenderer.func_181662_b((double)maxX, (double)maxY, (double)minZ).func_187315_a(texMinZ_U, texMaxX_V).func_181675_d();
        worldRenderer.func_181662_b((double)minX, (double)maxY, (double)minZ).func_187315_a(texMinZ_U, texMinX_V).func_181675_d();
        worldRenderer.func_181662_b((double)minX, (double)maxY, (double)maxZ).func_187315_a(texMaxZ_U, texMinX_V).func_181675_d();
        tess.func_78381_a();
    }
}

