/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.api.prefab.world.gen;

import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.prefab.core.BlockMetaPair;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.BiomeDecoratorSpace;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.MapGenBaseMeta;
import micdoodle8.mods.galacticraft.api.world.ChunkProviderBase;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.perlin.generator.GradientNoise;
import micdoodle8.mods.galacticraft.core.world.gen.EnumCraterSize;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;

public abstract class ChunkProviderSpace
extends ChunkProviderBase {
    protected final Random rand;
    private final GradientNoise noiseGen1;
    private final GradientNoise noiseGen2;
    private final GradientNoise noiseGen3;
    private final GradientNoise noiseGen4;
    private final GradientNoise noiseGen5;
    private final GradientNoise noiseGen6;
    private final GradientNoise noiseGen7;
    protected final World world;
    private Biome[] biomesForGeneration = this.getBiomesForGeneration();
    private final double TERRAIN_HEIGHT_MOD = this.getHeightModifier();
    private final double SMALL_FEATURE_HEIGHT_MOD = this.getSmallFeatureHeightModifier();
    private final double MOUNTAIN_HEIGHT_MOD = this.getMountainHeightModifier();
    private final double VALLEY_HEIGHT_MOD = this.getValleyHeightModifier();
    private final int CRATER_PROB = this.getCraterProbability();
    private final int MID_HEIGHT = this.getSeaLevel();
    private static final int CHUNK_SIZE = 16;
    private static final double MAIN_FEATURE_FILTER_MOD = 4.0;
    private static final double LARGE_FEATURE_FILTER_MOD = 8.0;
    private static final double SMALL_FEATURE_FILTER_MOD = 8.0;
    private List<MapGenBaseMeta> worldGenerators;

    public ChunkProviderSpace(World world, long seed, boolean mapFeaturesEnabled) {
        this.world = world;
        this.rand = new Random(seed);
        this.noiseGen1 = new GradientNoise(this.rand.nextLong(), 4, 0.25);
        this.noiseGen2 = new GradientNoise(this.rand.nextLong(), 4, 0.25);
        this.noiseGen3 = new GradientNoise(this.rand.nextLong(), 4, 0.25);
        this.noiseGen4 = new GradientNoise(this.rand.nextLong(), 2, 0.25);
        this.noiseGen5 = new GradientNoise(this.rand.nextLong(), 1, 0.25);
        this.noiseGen6 = new GradientNoise(this.rand.nextLong(), 1, 0.25);
        this.noiseGen7 = new GradientNoise(this.rand.nextLong(), 1, 0.25);
    }

    public void generateTerrain(int chunkX, int chunkZ, ChunkPrimer primer) {
        this.noiseGen1.setFrequencyAll(0.015f);
        this.noiseGen2.setFrequencyAll(0.0030000000474999914);
        this.noiseGen3.setFrequencyAll(0.01);
        this.noiseGen4.setFrequencyAll(0.01);
        this.noiseGen5.setFrequencyAll(0.01);
        this.noiseGen6.setFrequencyAll(0.001f);
        this.noiseGen7.setFrequencyAll(0.005f);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                double baseHeight = this.noiseGen1.evalNoise(chunkX * 16 + x, chunkZ * 16 + z) * this.TERRAIN_HEIGHT_MOD;
                double smallHillHeight = this.noiseGen2.evalNoise(chunkX * 16 + x, chunkZ * 16 + z) * this.SMALL_FEATURE_HEIGHT_MOD;
                double mountainHeight = Math.abs(this.noiseGen3.evalNoise(chunkX * 16 + x, chunkZ * 16 + z));
                double valleyHeight = Math.abs(this.noiseGen4.evalNoise(chunkX * 16 + x, chunkZ * 16 + z));
                double featureFilter = this.noiseGen5.evalNoise(chunkX * 16 + x, chunkZ * 16 + z) * 4.0;
                double largeFilter = this.noiseGen6.evalNoise(chunkX * 16 + x, chunkZ * 16 + z) * 8.0;
                double smallFilter = this.noiseGen7.evalNoise(chunkX * 16 + x, chunkZ * 16 + z) * 8.0 - 0.5;
                mountainHeight = this.lerp(smallHillHeight, mountainHeight * this.MOUNTAIN_HEIGHT_MOD, this.fade(this.clamp(mountainHeight * 2.0, 0.0, 1.0)));
                valleyHeight = this.lerp(smallHillHeight, valleyHeight * this.VALLEY_HEIGHT_MOD - this.VALLEY_HEIGHT_MOD + 9.0, this.fade(this.clamp((valleyHeight + 2.0) * 4.0, 0.0, 1.0)));
                double yDev = this.lerp(valleyHeight, mountainHeight, this.fade(largeFilter));
                yDev = this.lerp(smallHillHeight, yDev, smallFilter);
                yDev = this.lerp(baseHeight, yDev, featureFilter);
                for (int y = 0; y < 255; ++y) {
                    if (!((double)y < (double)this.MID_HEIGHT + yDev)) continue;
                    primer.func_177855_a(x, y, z, this.getStoneBlock().getBlock().func_176203_a((int)this.getStoneBlock().getMetadata()));
                }
            }
        }
    }

    private double lerp(double d1, double d2, double t) {
        if (t < 0.0) {
            return d1;
        }
        if (t > 1.0) {
            return d2;
        }
        return d1 + (d2 - d1) * t;
    }

    private double fade(double n) {
        return n * n * n * (n * (n * 6.0 - 15.0) + 10.0);
    }

    private double clamp(double x, double min, double max) {
        if (x < min) {
            return min;
        }
        if (x > max) {
            return max;
        }
        return x;
    }

    public void replaceBiomeBlocks(int x, int z, ChunkPrimer primer, Biome[] biomesIn) {
        int var5 = 20;
        this.noiseGen4.setFrequencyAll(0.0625);
        for (int var8 = 0; var8 < 16; ++var8) {
            for (int var9 = 0; var9 < 16; ++var9) {
                int var12 = (int)(this.noiseGen4.evalNoise(x * 16 + var8, z * 16 + var9) / 3.0 + 3.0 + this.rand.nextDouble() * 0.25);
                int var13 = -1;
                Block var14 = this.getGrassBlock().getBlock();
                byte var14m = this.getGrassBlock().getMetadata();
                Block var15 = this.getDirtBlock().getBlock();
                byte var15m = this.getDirtBlock().getMetadata();
                for (int var16 = 254; var16 >= 0; --var16) {
                    if (var16 <= 0 + this.rand.nextInt(5)) {
                        primer.func_177855_a(var8, var16, var9, Blocks.field_150357_h.func_176223_P());
                        continue;
                    }
                    Block var18 = primer.func_177856_a(var8, var16, var9).func_177230_c();
                    if (Blocks.field_150350_a == var18) {
                        var13 = -1;
                        continue;
                    }
                    if (var18 != this.getStoneBlock().getBlock()) continue;
                    if (var13 == -1) {
                        if (var12 <= 0) {
                            var14 = Blocks.field_150350_a;
                            var14m = 0;
                            var15 = this.getStoneBlock().getBlock();
                            var15m = this.getStoneBlock().getMetadata();
                        } else if (var16 >= 36 && var16 <= 21) {
                            var14 = this.getGrassBlock().getBlock();
                            var14m = this.getGrassBlock().getMetadata();
                            var14 = this.getDirtBlock().getBlock();
                            var14m = this.getDirtBlock().getMetadata();
                        }
                        var13 = var12;
                        if (var16 >= 19) {
                            primer.func_177855_a(var8, var16, var9, var14.func_176203_a((int)var14m));
                            continue;
                        }
                        primer.func_177855_a(var8, var16, var9, var15.func_176203_a((int)var15m));
                        continue;
                    }
                    if (var13 <= 0) continue;
                    --var13;
                    primer.func_177855_a(var8, var16, var9, var15.func_176203_a((int)var15m));
                }
            }
        }
    }

    public Chunk func_185932_a(int x, int z) {
        ChunkPrimer primer = new ChunkPrimer();
        try {
            this.rand.setSeed((long)x * 341873128712L + (long)z * 132897987541L);
            this.generateTerrain(x, z, primer);
            this.createCraters(x, z, primer);
            this.biomesForGeneration = this.world.func_72959_q().func_76933_b(this.biomesForGeneration, x * 16, z * 16, 16, 16);
            this.replaceBiomeBlocks(x, z, primer, this.biomesForGeneration);
            if (this.worldGenerators == null) {
                this.worldGenerators = this.getWorldGenerators();
            }
            for (MapGenBaseMeta generator : this.worldGenerators) {
                generator.generate(this.world, x, z, primer);
            }
            this.onChunkProvide(x, z, primer);
        }
        catch (Exception e) {
            GalacticraftCore.logger.error("Error caught in planetary worldgen at coords " + x + "," + z + ".  If the next 2 lines are showing an Add-On mod name, please report to that mod's author!", new Object[0]);
            e.printStackTrace();
        }
        Chunk var4 = new Chunk(this.world, primer, x, z);
        byte[] var5 = var4.func_76605_m();
        for (int var6 = 0; var6 < var5.length; ++var6) {
            var5[var6] = (byte)Biome.func_185362_a((Biome)this.biomesForGeneration[var6]);
        }
        var4.func_76603_b();
        return var4;
    }

    public void createCraters(int chunkX, int chunkZ, ChunkPrimer primer) {
        this.noiseGen5.setFrequencyAll(0.015f);
        for (int cx = chunkX - 2; cx <= chunkX + 2; ++cx) {
            for (int cz = chunkZ - 2; cz <= chunkZ + 2; ++cz) {
                for (int x = 0; x < 16; ++x) {
                    for (int z = 0; z < 16; ++z) {
                        if (!(Math.abs(this.randFromPoint(cx * 16 + x, (cz * 16 + z) * 1000)) < this.noiseGen5.evalNoise(cx * 16 + x, cz * 16 + z) / (double)this.CRATER_PROB)) continue;
                        Random random = new Random(cx * 16 + x + (cz * 16 + z) * 5000);
                        EnumCraterSize cSize = EnumCraterSize.sizeArray[random.nextInt(EnumCraterSize.sizeArray.length)];
                        int size = random.nextInt(cSize.MAX_SIZE - cSize.MIN_SIZE) + cSize.MIN_SIZE + 15;
                        this.makeCrater(cx * 16 + x, cz * 16 + z, chunkX * 16, chunkZ * 16, size, primer);
                    }
                }
            }
        }
    }

    public void makeCrater(int craterX, int craterZ, int chunkX, int chunkZ, int size, ChunkPrimer primer) {
        for (int x = 0; x < 16; ++x) {
            block1: for (int z = 0; z < 16; ++z) {
                double xDev = craterX - (chunkX + x);
                double zDev = craterZ - (chunkZ + z);
                if (!(xDev * xDev + zDev * zDev < (double)(size * size))) continue;
                double sqrtY = (xDev /= (double)size) * xDev + (zDev /= (double)size) * zDev;
                double yDev = sqrtY * sqrtY * 6.0;
                yDev = 5.0 - yDev;
                int helper = 0;
                for (int y = 127; y > 0; --y) {
                    if (Blocks.field_150350_a != primer.func_177856_a(x, y, z).func_177230_c() && (double)helper <= yDev) {
                        primer.func_177855_a(x, y, z, Blocks.field_150350_a.func_176223_P());
                        ++helper;
                    }
                    if ((double)helper > yDev) continue block1;
                }
            }
        }
    }

    private double randFromPoint(int x, int z) {
        int n = x + z * 57;
        n = n << 13 ^ n;
        return 1.0 - (double)(n * (n * n * 15731 + 789221) + 1376312589 & Integer.MAX_VALUE) / 1.073741824E9;
    }

    public void decoratePlanet(World world, Random rand, int posX, int posZ) {
        this.getBiomeGenerator().decorate(world, rand, posX, posZ);
    }

    public void func_185931_b(int x, int z) {
        BlockFalling.field_149832_M = true;
        int var4 = x * 16;
        int var5 = z * 16;
        this.world.func_180494_b(new BlockPos(var4 + 16, 0, var5 + 16));
        this.rand.setSeed(this.world.func_72905_C());
        long var7 = this.rand.nextLong() / 2L * 2L + 1L;
        long var9 = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)x * var7 + (long)z * var9 ^ this.world.func_72905_C());
        this.decoratePlanet(this.world, this.rand, var4, var5);
        this.onPopulate(x, z);
        BlockFalling.field_149832_M = false;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        Biome biomegenbase = this.world.func_180494_b(pos);
        return biomegenbase.func_76747_a(creatureType);
    }

    protected abstract BiomeDecoratorSpace getBiomeGenerator();

    protected abstract Biome[] getBiomesForGeneration();

    protected abstract int getSeaLevel();

    protected abstract List<MapGenBaseMeta> getWorldGenerators();

    protected abstract BlockMetaPair getGrassBlock();

    protected abstract BlockMetaPair getDirtBlock();

    protected abstract BlockMetaPair getStoneBlock();

    public abstract double getHeightModifier();

    public abstract double getSmallFeatureHeightModifier();

    public abstract double getMountainHeightModifier();

    public abstract double getValleyHeightModifier();

    public abstract int getCraterProbability();

    public abstract void onChunkProvide(int var1, int var2, ChunkPrimer var3);

    public abstract void onPopulate(int var1, int var2);
}

