/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.api.galaxies;

import java.util.Locale;
import micdoodle8.mods.galacticraft.annotations.ReplaceWith;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialObject;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialType;
import micdoodle8.mods.galacticraft.api.galaxies.Star;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.util.TranslateUtil;

public class SolarSystem
extends CelestialObject {
    protected Vector3 mapPosition = null;
    protected Star mainStar = null;
    protected String unlocalizedGalaxyName;

    public SolarSystem(String solarSystem, String parentGalaxy) {
        super(CelestialType.SOLARSYSTEM, solarSystem.toLowerCase(Locale.ENGLISH));
        this.unlocalizedGalaxyName = parentGalaxy;
    }

    @Override
    public void setOwnerId(String ownerId) {
        super.setOwnerId(ownerId);
    }

    public Vector3 getMapPosition() {
        return this.mapPosition;
    }

    public SolarSystem setMapPosition(Vector3 mapPosition) {
        mapPosition.scale(500.0);
        this.mapPosition = mapPosition;
        return this;
    }

    public Star getMainStar() {
        return this.mainStar;
    }

    public SolarSystem setMainStar(Star star) {
        this.mainStar = star;
        return this;
    }

    public String getTranslatedParentGalaxyName() {
        return TranslateUtil.getInstance().translate(this.getTranslationKey());
    }

    public String getParentGalaxyTranslationKey() {
        return "galaxy." + this.unlocalizedGalaxyName;
    }

    @Deprecated
    @ReplaceWith(value="getTranslationKey()")
    public String getUnlocalizedName() {
        return this.getTranslationKey();
    }

    @Deprecated
    @ReplaceWith(value="getTranslatedName()")
    public String getLocalizedName() {
        return this.getTranslatedName();
    }

    @Deprecated
    @ReplaceWith(value="getTranslatedParentGalaxyName()")
    public String getLocalizedParentGalaxyName() {
        return this.getTranslatedParentGalaxyName();
    }

    @Deprecated
    @ReplaceWith(value="getParentGalaxyTranslationKey()")
    public String getUnlocalizedParentGalaxyName() {
        return "galaxy." + this.unlocalizedGalaxyName;
    }
}

